/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.chat;

import io.github.maxmar628.DestruyeElNexus.Util;
import io.github.maxmar628.DestruyeElNexus.VaultHooks;
import io.github.maxmar628.DestruyeElNexus.object.Boss;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ChatUtil {
    private static final String DARK_AQUA = ChatColor.DARK_AQUA.toString();
    private static final String DARK_GRAY = ChatColor.DARK_GRAY.toString();
    private static final String DARK_PURPLE = ChatColor.DARK_PURPLE.toString();
    private static final String DARK_RED = ChatColor.DARK_RED.toString();
    private static final String RESET = ChatColor.RESET.toString();
    private static final String GRAY = ChatColor.GRAY.toString();
    private static final String RED = ChatColor.RED.toString();
    private static boolean roman = false;

    public static void setRoman(boolean b) {
        roman = b;
    }

    public static void allMessage(GameTeam team, Player sender, String message, boolean dead) {
        String username;
        String group;
        if (team == GameTeam.NONE) {
            group = String.valueOf(GRAY) + "(All) " + GRAY + "[" + DARK_PURPLE + "Lobby" + GRAY + "]";
            username = String.valueOf(RESET) + sender.getName();
        } else {
            group = String.valueOf(DARK_GRAY) + "(" + team.color() + "All" + DARK_GRAY + ")";
            username = team.color() + sender.getName();
            if (dead) {
                group = String.valueOf(DARK_GRAY) + "(" + DARK_RED + "DEAD" + DARK_GRAY + ") " + group;
            }
        }
        String msg = message;
        String permGroup = VaultHooks.getGroup(sender.getName());
        if (!permGroup.equals("")) {
            group = String.valueOf(group) + " " + permGroup + RESET;
        }
        String toSend = String.valueOf(group) + " " + username + RESET + ": " + msg;
        Player[] playerArray = Bukkit.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            player.sendMessage(toSend);
            ++n2;
        }
    }

    public static void teamMessage(GameTeam team, Player sender, String message, boolean dead) {
        String permGroup;
        if (team == GameTeam.NONE) {
            ChatUtil.allMessage(team, sender, message, false);
            return;
        }
        String group = String.valueOf(GRAY) + "[" + team.color() + "Team" + GRAY + "]";
        if (dead) {
            group = String.valueOf(DARK_GRAY) + "[" + DARK_RED + "DEAD" + DARK_GRAY + "] " + group;
        }
        if (!(permGroup = VaultHooks.getGroup(sender.getName())).equals("")) {
            group = String.valueOf(group) + " " + permGroup + RESET;
        }
        String toSend = String.valueOf(group) + " " + team.color() + sender.getName() + RESET + ": " + message;
        for (Player player : team.getPlayers()) {
            player.sendMessage(toSend);
        }
    }

    public static void broadcast(String message) {
        Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public static void nexusDestroyed(GameTeam attacker, GameTeam victim, Player p) {
        ChatUtil.broadcast(String.valueOf(GRAY) + "===============[ " + victim.color().toString() + "Nexus Destruido" + GRAY + " ]===============");
        ChatUtil.broadcast(String.valueOf(attacker.color().toString()) + p.getName() + GRAY + " por " + attacker.coloredName() + GRAY + " destroyed " + victim.coloredName() + "'s" + GRAY + " Nexus!");
        ChatUtil.broadcast(String.valueOf(GRAY) + "===============================================");
    }

    public static String nexusBreakMessage(Player breaker, GameTeam attacker, GameTeam victim) {
        return String.valueOf(ChatUtil.colorizeName(breaker, attacker)) + GRAY + " ha golpeado el " + victim.coloredName() + " Nexus!";
    }

    private static String colorizeName(Player player, GameTeam team) {
        return team.color() + player.getName();
    }

    public static void phaseMessage(int phase) {
        ChatUtil.broadcast(String.valueOf(GRAY) + "===========[ " + DARK_AQUA + "Progreso" + GRAY + " ]===========");
        ChatUtil.broadcast(String.valueOf(Util.getPhaseColor(phase)) + "Fase " + ChatUtil.translateRoman(phase) + GRAY + " ha comenzado");
        switch (phase) {
            case 1: {
                ChatUtil.broadcast(String.valueOf(GRAY) + "Los Nexus son indestructible hasta la fase " + ChatUtil.translateRoman(2));
                break;
            }
            case 2: {
                ChatUtil.broadcast(String.valueOf(GRAY) + "EL Nexus ya no es mas indestructible");
                ChatUtil.broadcast(String.valueOf(GRAY) + "Boss Iron Golems han aparecido");
                break;
            }
            case 3: {
                ChatUtil.broadcast(String.valueOf(GRAY) + "Los Diamantes aparecieron");
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                ChatUtil.broadcast(String.valueOf(RED) + "Doble da\u00f1o a los Nexus");
            }
        }
        ChatUtil.broadcast(String.valueOf(GRAY) + "================================");
    }

    public static void winMessage(GameTeam winner) {
        ChatUtil.broadcast(String.valueOf(GRAY) + "================[ " + winner.color().toString() + "End Game" + GRAY + " ]================");
        ChatUtil.broadcast(String.valueOf(GRAY) + "Team " + winner.coloredName() + GRAY + " Gano DestruyeElNexus! Reseteando el juego...");
        ChatUtil.broadcast(String.valueOf(GRAY) + "==========================================");
    }

    public static void bossDeath(Boss b, Player killer, GameTeam team) {
        ChatUtil.broadcast(String.valueOf(GRAY) + "==========[ " + DARK_AQUA + "Boss Asesinado" + GRAY + " ]==========");
        ChatUtil.broadcast(String.valueOf(GRAY) + b.getBossName() + GRAY + " fue asesinado por " + ChatUtil.colorizeName(killer, team));
        ChatUtil.broadcast(String.valueOf(GRAY) + "================================");
    }

    public static void bossRespawn(Boss b) {
        ChatUtil.broadcast(String.valueOf(GRAY) + "================[ " + DARK_AQUA + "Boss" + GRAY + " ]================");
        ChatUtil.broadcast(String.valueOf(GRAY) + b.getBossName() + GRAY + " ha reaparecido! Que gane el mejor!");
        ChatUtil.broadcast(String.valueOf(GRAY) + "=======================================");
    }

    public static String formatDeathMessage(Player victim, Player killer, String original) {
        GameTeam killerTeam = PlayerMeta.getMeta(killer).getTeam();
        String killerColor = killerTeam != null ? killerTeam.color().toString() : ChatColor.DARK_PURPLE.toString();
        String killerName = String.valueOf(killerColor) + killer.getName() + ChatColor.GRAY;
        String message = ChatColor.GRAY + ChatUtil.formatDeathMessage(victim, original);
        message = message.replace(killer.getName(), killerName);
        return message;
    }

    public static String formatDeathMessage(Player victim, String original) {
        GameTeam victimTeam = PlayerMeta.getMeta(victim).getTeam();
        String victimColor = victimTeam != null ? victimTeam.color().toString() : ChatColor.DARK_PURPLE.toString();
        String victimName = String.valueOf(victimColor) + victim.getName() + ChatColor.GRAY;
        String message = ChatColor.GRAY + original;
        if ((message = message.replace(victim.getName(), victimName)).contains(" \u00ef\u00bf\u00bd8\u00ef\u00bf\u00bd")) {
            String[] arr = message.split(" \u00ef\u00bf\u00bd8\u00ef\u00bf\u00bd");
            message = arr[0];
        }
        return message.replace("was slain by", "was killed by");
    }

    public static String translateRoman(int number) {
        if (!roman) {
            return String.valueOf(number);
        }
        switch (number) {
            case 0: {
                return "0";
            }
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return String.valueOf(number);
    }
}

