/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus.bar;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.bar.FakeDragon;
import io.github.maxmar628.DestruyeElNexus.bar.Util;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class BarUtil
implements Listener {
    private static BarUtil instance;
    private DestruyeElNexus plugin;
    private HashMap<String, FakeDragon> players = new HashMap();

    private BarUtil() {
    }

    public static void init(DestruyeElNexus plugin) {
        instance = new BarUtil();
        BarUtil.instance.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)instance, (Plugin)plugin);
    }

    public static void setMessageAndPercent(Player player, String message, float percent) {
        FakeDragon dragon = instance.getDragon(player, message);
        dragon.name = message.length() > 64 ? message.substring(0, 63) : message;
        dragon.health = percent * 200.0f;
        instance.sendDragon(dragon, player);
    }

    public static void setMessage(Player player, String message) {
        FakeDragon dragon = instance.getDragon(player, message);
        dragon.name = message.length() > 64 ? message.substring(0, 63) : message;
        dragon.health = 200.0f;
        instance.sendDragon(dragon, player);
    }

    public static void setPercent(Player player, float percent) {
        if (!instance.hasBar(player)) {
            return;
        }
        FakeDragon dragon = instance.getDragon(player, "");
        dragon.health = percent * 200.0f;
        instance.sendDragon(dragon, player);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void PlayerLogout(PlayerQuitEvent event) {
        this.quit(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        this.quit(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getTo() != null) {
            this.handleTeleport(event.getPlayer(), event.getTo().clone());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerRespawnEvent event) {
        this.handleTeleport(event.getPlayer(), event.getRespawnLocation().clone());
    }

    private void quit(Player player) {
        this.removeBar(player);
    }

    private void handleTeleport(final Player player, final Location loc) {
        if (!this.hasBar(player)) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                FakeDragon oldDragon = BarUtil.this.getDragon(player, "");
                Object destroyPacket = BarUtil.this.getDragon(player, "").getDestroyPacket();
                Util.sendPacket(player, destroyPacket);
                BarUtil.this.players.remove(player.getName());
                FakeDragon dragon = BarUtil.this.addDragon(player, loc, oldDragon.name);
                dragon.health = oldDragon.health;
                BarUtil.this.sendDragon(dragon, player);
            }
        }, 2L);
    }

    private boolean hasBar(Player player) {
        return this.players.get(player.getName()) != null;
    }

    private void removeBar(Player player) {
        if (instance.hasBar(player)) {
            Util.sendPacket(player, instance.getDragon(player, "").getDestroyPacket());
            BarUtil.instance.players.remove(player.getName());
        }
    }

    private void sendDragon(FakeDragon dragon, Player player) {
        Object metaPacket = dragon.getMetaPacket(dragon.getWatcher());
        Object teleportPacket = dragon.getTeleportPacket(player.getLocation().add(0.0, -300.0, 0.0));
        Util.sendPacket(player, metaPacket);
        Util.sendPacket(player, teleportPacket);
    }

    private FakeDragon getDragon(Player player, String message) {
        if (this.hasBar(player)) {
            return this.players.get(player.getName());
        }
        return this.addDragon(player, message);
    }

    private FakeDragon addDragon(Player player, String message) {
        FakeDragon dragon = Util.newDragon(message, player.getLocation().add(0.0, -300.0, 0.0));
        Util.sendPacket(player, dragon.getSpawnPacket());
        this.players.put(player.getName(), dragon);
        return dragon;
    }

    private FakeDragon addDragon(Player player, Location loc, String message) {
        FakeDragon dragon = Util.newDragon(message, loc.add(0.0, -300.0, 0.0));
        Util.sendPacket(player, dragon.getSpawnPacket());
        this.players.put(player.getName(), dragon);
        return dragon;
    }
}

