/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus;

import io.github.maxmar628.DestruyeElNexus.DestruyeElNexus;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import io.github.maxmar628.DestruyeElNexus.object.Kit;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Util {
    public static Location parseLocation(World w, String in) {
        String[] params;
        String[] stringArray = params = in.split(",");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            s.replace("-0", "0");
            ++n2;
        }
        if (params.length == 3 || params.length == 5) {
            double x = Double.parseDouble(params[0]);
            double y = Double.parseDouble(params[1]);
            double z = Double.parseDouble(params[2]);
            Location loc = new Location(w, x, y, z);
            if (params.length == 5) {
                loc.setYaw(Float.parseFloat(params[4]));
                loc.setPitch(Float.parseFloat(params[5]));
            }
            return loc;
        }
        return null;
    }

    public static void sendPlayerToGame(final Player player, DestruyeElNexus plugin) {
        final PlayerMeta meta = PlayerMeta.getMeta(player);
        if (meta.getTeam() != null) {
            meta.setAlive(true);
            player.teleport(meta.getTeam().getRandomSpawn());
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    meta.getKit().give(player, meta.getTeam());
                    player.setCompassTarget(meta.getTeam().getNexus().getLocation());
                    player.setGameMode(GameMode.SURVIVAL);
                    player.setFoodLevel(20);
                    player.setSaturation(20.0f);
                }
            }, 10L);
        }
    }

    public static boolean isEmptyColumn(Location loc) {
        boolean hasBlock = false;
        Location test = loc.clone();
        int y = 0;
        while (y < loc.getWorld().getMaxHeight()) {
            test.setY((double)y);
            if (test.getBlock().getType() != Material.AIR) {
                hasBlock = true;
            }
            ++y;
        }
        return !hasBlock;
    }

    public static void showClassSelector(Player p, String title) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)p, (int)54, (String)title);
        Kit[] kitArray = Kit.values();
        int n = kitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kit kit = kitArray[n2];
            ItemStack i = kit.getIcon().clone();
            ItemMeta im = i.getItemMeta();
            List lore = im.getLore();
            lore.add(ChatColor.GRAY + "---------------");
            if (kit.isOwnedBy(p)) {
                lore.add(ChatColor.GREEN + "Unlocked");
            } else {
                lore.add(ChatColor.RED + "Locked");
            }
            im.setLore(lore);
            i.setItemMeta(im);
            inv.addItem(new ItemStack[]{i});
            ++n2;
        }
        p.openInventory(inv);
    }

    public static void spawnFirework(Location loc) {
        Random colour = new Random();
        Firework fw = (Firework)loc.getWorld().spawn(loc, Firework.class);
        FireworkMeta fwMeta = fw.getFireworkMeta();
        FireworkEffect.Type fwType = FireworkEffect.Type.BALL_LARGE;
        int c1i = colour.nextInt(17) + 1;
        int c2i = colour.nextInt(17) + 1;
        Color c1 = Util.getFWColor(c1i);
        Color c2 = Util.getFWColor(c2i);
        FireworkEffect effect = FireworkEffect.builder().withFade(c2).withColor(c1).with(fwType).build();
        fwMeta.addEffect(effect);
        fwMeta.setPower(1);
        fw.setFireworkMeta(fwMeta);
    }

    public static void spawnFirework(Location loc, Color c1, Color c2) {
        Firework fw = (Firework)loc.getWorld().spawn(loc, Firework.class);
        FireworkMeta fwMeta = fw.getFireworkMeta();
        FireworkEffect.Type fwType = FireworkEffect.Type.BALL_LARGE;
        FireworkEffect effect = FireworkEffect.builder().withFade(c2).withColor(c1).with(fwType).build();
        fwMeta.addEffect(effect);
        fwMeta.setPower(1);
        fw.setFireworkMeta(fwMeta);
    }

    public static Color getFWColor(int c) {
        switch (c) {
            case 1: {
                return Color.TEAL;
            }
            default: {
                return Color.WHITE;
            }
            case 3: {
                return Color.YELLOW;
            }
            case 4: {
                return Color.AQUA;
            }
            case 5: {
                return Color.BLACK;
            }
            case 6: {
                return Color.BLUE;
            }
            case 7: {
                return Color.FUCHSIA;
            }
            case 8: {
                return Color.GRAY;
            }
            case 9: {
                return Color.GREEN;
            }
            case 10: {
                return Color.LIME;
            }
            case 11: {
                return Color.MAROON;
            }
            case 12: {
                return Color.NAVY;
            }
            case 13: {
                return Color.OLIVE;
            }
            case 14: {
                return Color.ORANGE;
            }
            case 15: {
                return Color.PURPLE;
            }
            case 16: {
                return Color.RED;
            }
            case 17: 
        }
        return Color.SILVER;
    }

    public static String getPhaseColor(int phase) {
        switch (phase) {
            case 1: {
                return ChatColor.BLUE.toString();
            }
            case 2: {
                return ChatColor.GREEN.toString();
            }
            case 3: {
                return ChatColor.YELLOW.toString();
            }
            case 4: {
                return ChatColor.GOLD.toString();
            }
            case 5: {
                return ChatColor.RED.toString();
            }
        }
        return ChatColor.WHITE.toString();
    }

    public static boolean isTeamTooBig(GameTeam team) {
        int players = team.getPlayers().size();
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameTeam gt = gameTeamArray[n2];
            if (players >= gt.getPlayers().size() + 3 && gt.getNexus().isAlive()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static enum ParticleEffects {
        HUGE_EXPLODE("hugeexplosion", 0),
        LARGE_EXPLODE("largeexplode", 1),
        FIREWORK_SPARK("fireworksSpark", 2),
        AIR_BUBBLE("bubble", 3),
        SUSPEND("suspend", 4),
        DEPTH_SUSPEND("depthSuspend", 5),
        TOWN_AURA("townaura", 6),
        CRITICAL_HIT("crit", 7),
        MAGIC_CRITICAL_HIT("magicCrit", 8),
        MOB_SPELL("mobSpell", 9),
        MOB_SPELL_AMBIENT("mobSpellAmbient", 10),
        SPELL("spell", 11),
        INSTANT_SPELL("instantSpell", 12),
        BLUE_SPARKLE("witchMagic", 13),
        NOTE_BLOCK("note", 14),
        ENDER("portal", 15),
        ENCHANTMENT_TABLE("enchantmenttable", 16),
        EXPLODE("explode", 17),
        FIRE("flame", 18),
        LAVA_SPARK("lava", 19),
        FOOTSTEP("footstep", 20),
        SPLASH("splash", 21),
        LARGE_SMOKE("largesmoke", 22),
        CLOUD("cloud", 23),
        REDSTONE_DUST("reddust", 24),
        SNOWBALL_HIT("snowballpoof", 25),
        DRIP_WATER("dripWater", 26),
        DRIP_LAVA("dripLava", 27),
        SNOW_DIG("snowshovel", 28),
        SLIME("slime", 29),
        HEART("heart", 30),
        ANGRY_VILLAGER("angryVillager", 31),
        GREEN_SPARKLE("happyVillager", 32),
        ICONCRACK("iconcrack", 33),
        TILECRACK("tilecrack", 34);

        private String name;
        private int id;

        private ParticleEffects(String name, int id) {
            this.name = name;
            this.id = id;
        }

        String getName() {
            return this.name;
        }

        int getId() {
            return this.id;
        }

        public static void sendToPlayer(ParticleEffects effect, Player player, Location location, float offsetX, float offsetY, float offsetZ, float speed, int count) {
            try {
                Object packet = ParticleEffects.createPacket(effect, location, offsetX, offsetY, offsetZ, speed, count);
                ParticleEffects.sendPacket(player, packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static void sendToLocation(ParticleEffects effect, Location location, float offsetX, float offsetY, float offsetZ, float speed, int count) {
            try {
                Object packet = ParticleEffects.createPacket(effect, location, offsetX, offsetY, offsetZ, speed, count);
                Player[] playerArray = Bukkit.getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    ParticleEffects.sendPacket(player, packet);
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static Object createPacket(ParticleEffects effect, Location location, float offsetX, float offsetY, float offsetZ, float speed, int count) throws Exception {
            if (count <= 0) {
                count = 1;
            }
            Class<?> packetClass = ParticleEffects.getCraftClass("PacketPlayOutWorldParticles");
            Object packet = packetClass.getConstructor(String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE).newInstance(effect.name, Float.valueOf((float)location.getX()), Float.valueOf((float)location.getY()), Float.valueOf((float)location.getZ()), Float.valueOf(offsetX), Float.valueOf(offsetY), Float.valueOf(offsetZ), Float.valueOf(speed), count);
            return packet;
        }

        private static void sendPacket(Player p, Object packet) throws Exception {
            Object eplayer = ParticleEffects.getHandle((Entity)p);
            Field playerConnectionField = eplayer.getClass().getField("playerConnection");
            Object playerConnection = playerConnectionField.get(eplayer);
            Method[] methodArray = playerConnection.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equalsIgnoreCase("sendPacket")) {
                    m.invoke(playerConnection, packet);
                    return;
                }
                ++n2;
            }
        }

        private static Object getHandle(Entity entity) {
            try {
                Method entity_getHandle = entity.getClass().getMethod("getHandle", new Class[0]);
                Object nms_entity = entity_getHandle.invoke((Object)entity, new Object[0]);
                return nms_entity;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private static Class<?> getCraftClass(String name) {
            String version = String.valueOf(ParticleEffects.getVersion()) + ".";
            String className = "net.minecraft.server." + version + name;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return clazz;
        }

        private static String getVersion() {
            return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
    }
}

