/*
 * Decompiled with CFR 0.152.
 */
package io.github.maxmar628.DestruyeElNexus;

import io.github.maxmar628.DestruyeElNexus.Translation;
import io.github.maxmar628.DestruyeElNexus.Util;
import io.github.maxmar628.DestruyeElNexus.VaultHooks;
import io.github.maxmar628.DestruyeElNexus.api.GameStartEvent;
import io.github.maxmar628.DestruyeElNexus.api.PhaseChangeEvent;
import io.github.maxmar628.DestruyeElNexus.bar.BarUtil;
import io.github.maxmar628.DestruyeElNexus.chat.ChatListener;
import io.github.maxmar628.DestruyeElNexus.chat.ChatUtil;
import io.github.maxmar628.DestruyeElNexus.commands.DestruyeElNexusCommand;
import io.github.maxmar628.DestruyeElNexus.commands.DistanceCommand;
import io.github.maxmar628.DestruyeElNexus.commands.KitCommand;
import io.github.maxmar628.DestruyeElNexus.commands.MapCommand;
import io.github.maxmar628.DestruyeElNexus.commands.StatsCommand;
import io.github.maxmar628.DestruyeElNexus.commands.TeamCommand;
import io.github.maxmar628.DestruyeElNexus.commands.TeamShortcutCommand;
import io.github.maxmar628.DestruyeElNexus.commands.VoteCommand;
import io.github.maxmar628.DestruyeElNexus.listeners.BossListener;
import io.github.maxmar628.DestruyeElNexus.listeners.CraftingListener;
import io.github.maxmar628.DestruyeElNexus.listeners.EnderBrewingStandListener;
import io.github.maxmar628.DestruyeElNexus.listeners.EnderChestListener;
import io.github.maxmar628.DestruyeElNexus.listeners.EnderFurnaceListener;
import io.github.maxmar628.DestruyeElNexus.listeners.KitAbilityListener;
import io.github.maxmar628.DestruyeElNexus.listeners.PlayerListener;
import io.github.maxmar628.DestruyeElNexus.listeners.ResourceListener;
import io.github.maxmar628.DestruyeElNexus.listeners.SoulboundListener;
import io.github.maxmar628.DestruyeElNexus.listeners.WandListener;
import io.github.maxmar628.DestruyeElNexus.listeners.WorldListener;
import io.github.maxmar628.DestruyeElNexus.manager.BossManager;
import io.github.maxmar628.DestruyeElNexus.manager.ConfigManager;
import io.github.maxmar628.DestruyeElNexus.manager.DatabaseManager;
import io.github.maxmar628.DestruyeElNexus.manager.MapManager;
import io.github.maxmar628.DestruyeElNexus.manager.PhaseManager;
import io.github.maxmar628.DestruyeElNexus.manager.RestartHandler;
import io.github.maxmar628.DestruyeElNexus.manager.ScoreboardManager;
import io.github.maxmar628.DestruyeElNexus.manager.SignManager;
import io.github.maxmar628.DestruyeElNexus.manager.VotingManager;
import io.github.maxmar628.DestruyeElNexus.maps.MapLoader;
import io.github.maxmar628.DestruyeElNexus.object.Boss;
import io.github.maxmar628.DestruyeElNexus.object.GameTeam;
import io.github.maxmar628.DestruyeElNexus.object.Kit;
import io.github.maxmar628.DestruyeElNexus.object.PlayerMeta;
import io.github.maxmar628.DestruyeElNexus.object.Shop;
import io.github.maxmar628.DestruyeElNexus.stats.StatType;
import io.github.maxmar628.DestruyeElNexus.stats.StatsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import net.gravitydevelopment.updater.Updater;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scoreboard.Team;

public final class DestruyeElNexus
extends JavaPlugin {
    private ConfigManager configManager;
    private VotingManager voting;
    private MapManager maps;
    private PhaseManager timer;
    private ResourceListener resources;
    private EnderFurnaceListener enderFurnaces;
    private EnderBrewingStandListener enderBrewingStands;
    private EnderChestListener enderChests;
    private StatsManager stats;
    private SignManager sign;
    private ScoreboardManager sb;
    private DatabaseManager db;
    private BossManager boss;
    public static HashMap<String, String> messages = new HashMap();
    public boolean useMysql = false;
    public boolean updateAvailable = false;
    public boolean motd = true;
    public String newVersion;
    public int build = 1;
    public int lastJoinPhase = 2;
    public int respawn = 10;
    public boolean runCommand = false;
    public List<String> commands = new ArrayList<String>();
    public String mysqlName = "DestruyeElNexus";

    public void onEnable() {
        Updater.UpdateResult updateResult = null;
        Updater u = null;
        if (this.getConfig().getBoolean("allowUpdater")) {
            u = new Updater((Plugin)this, 72127, this.getFile(), Updater.UpdateType.DEFAULT, true);
        }
        if (u != null) {
            updateResult = u.getResult();
        }
        if (updateResult != null && updateResult == Updater.UpdateResult.SUCCESS) {
            this.updateAvailable = true;
            this.newVersion = u.getLatestName();
        }
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfigFiles("config.yml", "maps.yml", "shops.yml", "stats.yml", "messages.yml");
        MapLoader mapLoader = new MapLoader(this.getLogger(), this.getDataFolder());
        this.runCommand = this.getConfig().contains("commandsToRunAtEndGame");
        this.commands = this.runCommand ? this.getConfig().getStringList("commandsToRunAtEndGame") : null;
        this.maps = new MapManager(this, mapLoader, (Configuration)this.configManager.getConfig("maps.yml"));
        YamlConfiguration shops = this.configManager.getConfig("shops.yml");
        new Shop(this, "Weapon", (Configuration)shops);
        new Shop(this, "Brewing", (Configuration)shops);
        this.stats = new StatsManager(this, this.configManager);
        this.resources = new ResourceListener(this);
        this.enderFurnaces = new EnderFurnaceListener(this);
        this.enderBrewingStands = new EnderBrewingStandListener(this);
        this.enderChests = new EnderChestListener();
        this.sign = new SignManager(this);
        YamlConfiguration config = this.configManager.getConfig("config.yml");
        this.timer = new PhaseManager(this, config.getInt("start-delay"), config.getInt("phase-period"));
        this.voting = new VotingManager(this);
        this.sb = new ScoreboardManager();
        this.boss = new BossManager(this);
        PluginManager pm = this.getServer().getPluginManager();
        File messagesFile = new File("plugins/" + this.getDescription().getName() + "/messages.yml");
        YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)messagesFile);
        for (String id : yml.getKeys(false)) {
            messages.put(id, yml.getString(id));
        }
        this.sign.loadSigns();
        this.sb.resetScoreboard(ChatColor.GREEN + "Votar" + ChatColor.WHITE + " | " + ChatColor.GOLD + "/v <mapa>");
        this.build = this.getConfig().getInt("build", 5);
        this.lastJoinPhase = this.getConfig().getInt("lastJoinPhase", 2);
        this.respawn = this.getConfig().getInt("bossRespawnDelay", 10);
        pm.registerEvents((Listener)this.resources, (Plugin)this);
        pm.registerEvents((Listener)this.enderFurnaces, (Plugin)this);
        pm.registerEvents((Listener)this.enderBrewingStands, (Plugin)this);
        pm.registerEvents((Listener)this.enderChests, (Plugin)this);
        pm.registerEvents((Listener)new ChatListener(this), (Plugin)this);
        pm.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        pm.registerEvents((Listener)new WorldListener(), (Plugin)this);
        pm.registerEvents((Listener)new SoulboundListener(), (Plugin)this);
        pm.registerEvents((Listener)new WandListener(this), (Plugin)this);
        pm.registerEvents((Listener)new CraftingListener(), (Plugin)this);
        pm.registerEvents((Listener)new KitAbilityListener(this), (Plugin)this);
        pm.registerEvents((Listener)new BossListener(this), (Plugin)this);
        this.getCommand("DestruyeElNexus").setExecutor((CommandExecutor)new DestruyeElNexusCommand(this));
        this.getCommand("a1112568").setExecutor((CommandExecutor)new KitCommand());
        this.getCommand("stats").setExecutor((CommandExecutor)new StatsCommand(this.stats));
        this.getCommand("team").setExecutor((CommandExecutor)new TeamCommand(this));
        this.getCommand("vote").setExecutor((CommandExecutor)new VoteCommand(this.voting));
        this.getCommand("red").setExecutor((CommandExecutor)new TeamShortcutCommand());
        this.getCommand("green").setExecutor((CommandExecutor)new TeamShortcutCommand());
        this.getCommand("yellow").setExecutor((CommandExecutor)new TeamShortcutCommand());
        this.getCommand("blue").setExecutor((CommandExecutor)new TeamShortcutCommand());
        this.getCommand("distance").setExecutor((CommandExecutor)new DistanceCommand(this));
        this.getCommand("map").setExecutor((CommandExecutor)new MapCommand(this, mapLoader));
        BarUtil.init(this);
        if (config.getString("stats").equalsIgnoreCase("sql")) {
            this.useMysql = true;
        }
        this.motd = config.getBoolean("enableMotd", true);
        if (this.useMysql) {
            String host = config.getString("MySQL.host");
            Integer port = config.getInt("MySQL.port");
            String name = config.getString("MySQL.name");
            String user = config.getString("MySQL.user");
            String pass = config.getString("MySQL.pass");
            this.db = new DatabaseManager(host, port, name, user, pass, this);
            this.db.query("CREATE TABLE IF NOT EXISTS `" + this.mysqlName + "` ( `username` varchar(16) NOT NULL, " + "`kills` int(16) NOT NULL, `deaths` int(16) NOT NULL, `wins` int(16) NOT NULL, " + "`losses` int(16) NOT NULL, `nexus_damage` int(16) NOT NULL, " + "UNIQUE KEY `username` (`username`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1;");
        } else {
            this.db = new DatabaseManager(this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Vault")) {
            VaultHooks.vault = true;
            if (!VaultHooks.instance().setupPermissions()) {
                VaultHooks.vault = false;
                this.getLogger().warning("Unable to load Vault: No permission plugin found.");
            } else if (!VaultHooks.instance().setupChat()) {
                VaultHooks.vault = false;
                this.getLogger().warning("Unable to load Vault: No chat plugin found.");
            } else {
                this.getLogger().info("Vault hook initalized!");
            }
        } else {
            this.getLogger().warning("Vault not found! Permissions features disabled.");
        }
        this.reset();
        ChatUtil.setRoman(this.getConfig().getBoolean("roman", false));
    }

    public boolean startTimer() {
        if (this.timer.isRunning()) {
            return false;
        }
        this.timer.start();
        return true;
    }

    public void loadMap(String map) {
        YamlConfiguration config = this.configManager.getConfig("maps.yml");
        ConfigurationSection section = config.getConfigurationSection(map);
        World w = this.getServer().getWorld(map);
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc;
            GameTeam team = gameTeamArray[n2];
            String name = team.name().toLowerCase();
            if (section.contains("spawns." + name)) {
                for (String s : section.getStringList("spawns." + name)) {
                    team.addSpawn(Util.parseLocation(this.getServer().getWorld(map), s));
                }
            }
            if (section.contains("nexuses." + name)) {
                loc = Util.parseLocation(w, section.getString("nexuses." + name));
                team.loadNexus(loc, 75);
            }
            if (section.contains("furnaces." + name)) {
                loc = Util.parseLocation(w, section.getString("furnaces." + name));
                this.enderFurnaces.setFurnaceLocation(team, loc);
                loc.getBlock().setType(Material.FURNACE);
            }
            if (section.contains("brewingstands." + name)) {
                loc = Util.parseLocation(w, section.getString("brewingstands." + name));
                this.enderBrewingStands.setBrewingStandLocation(team, loc);
                loc.getBlock().setType(Material.BREWING_STAND);
            }
            if (section.contains("enderchests." + name)) {
                loc = Util.parseLocation(w, section.getString("enderchests." + name));
                this.enderChests.setEnderChestLocation(team, loc);
                loc.getBlock().setType(Material.ENDER_CHEST);
            }
            ++n2;
        }
        if (section.contains("bosses")) {
            HashMap<String, Boss> bosses = new HashMap<String, Boss>();
            ConfigurationSection sec = section.getConfigurationSection("bosses");
            for (String boss : sec.getKeys(false)) {
                bosses.put(boss, new Boss(boss, sec.getInt(String.valueOf(boss) + ".hearts") * 2, sec.getString(String.valueOf(boss) + ".name"), Util.parseLocation(w, sec.getString(String.valueOf(boss) + ".spawn")), Util.parseLocation(w, sec.getString(String.valueOf(boss) + ".chest"))));
            }
            this.boss.loadBosses(bosses);
        }
        if (section.contains("diamonds")) {
            HashSet<Location> diamonds = new HashSet<Location>();
            for (String s : section.getStringList("diamonds")) {
                diamonds.add(Util.parseLocation(w, s));
            }
            this.resources.loadDiamonds(diamonds);
        }
    }

    public void startGame() {
        Player p;
        Object[] objectArray = Bukkit.getOnlinePlayers();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = objectArray[n2];
            Player[] playerArray = Bukkit.getOnlinePlayers();
            int n3 = playerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Player pp = playerArray[n4];
                p.showPlayer(pp);
                pp.showPlayer(p);
                ++n4;
            }
            ++n2;
        }
        Bukkit.getPluginManager().callEvent((Event)new GameStartEvent(this.maps.getCurrentMap()));
        this.sb.scores.clear();
        for (OfflinePlayer score : this.sb.sb.getPlayers()) {
            this.sb.sb.resetScores(score);
        }
        this.sb.obj.setDisplayName(ChatColor.GOLD + "Mapa: " + WordUtils.capitalize((String)this.voting.getWinner()));
        objectArray = GameTeam.teams();
        n = objectArray.length;
        int n5 = 0;
        while (n5 < n) {
            Player t = objectArray[n5];
            this.sb.scores.put(t.name(), this.sb.obj.getScore(Bukkit.getOfflinePlayer((String)WordUtils.capitalize((String)(String.valueOf(t.name().toLowerCase()) + " Nexus")))));
            this.sb.scores.get(t.name()).setScore(t.getNexus().getHealth());
            Team sbt = this.sb.sb.registerNewTeam(String.valueOf(t.name()) + "SB");
            sbt.addPlayer(Bukkit.getOfflinePlayer((String)WordUtils.capitalize((String)WordUtils.capitalize((String)(String.valueOf(t.name().toLowerCase()) + " Nexus")))));
            sbt.setPrefix(t.color().toString());
            ++n5;
        }
        this.sb.obj.setDisplayName(ChatColor.GOLD + "Mapa: " + WordUtils.capitalize((String)this.voting.getWinner()));
        objectArray = this.getServer().getOnlinePlayers();
        n = objectArray.length;
        n5 = 0;
        while (n5 < n) {
            p = objectArray[n5];
            if (PlayerMeta.getMeta(p).getTeam() != GameTeam.NONE) {
                Util.sendPlayerToGame(p, this);
            }
            ++n5;
        }
        this.sb.update();
        this.getServer().getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Player[] playerArray = DestruyeElNexus.this.getServer().getOnlinePlayers();
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player p = playerArray[n2];
                    if (PlayerMeta.getMeta(p).getKit() == Kit.SCOUT) {
                        PlayerMeta.getMeta(p).getKit().addScoutParticles(p);
                    }
                    ++n2;
                }
            }
        }, 0L, 1200L);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                GameTeam[] gameTeamArray = GameTeam.values();
                int n = gameTeamArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GameTeam t = gameTeamArray[n2];
                    if (t != GameTeam.NONE && t.getNexus().isAlive()) {
                        Location nexus = t.getNexus().getLocation().clone();
                        nexus.add(0.5, 0.0, 0.5);
                        Util.ParticleEffects.sendToLocation(Util.ParticleEffects.ENDER, nexus, 1.0f, 1.0f, 1.0f, 0.0f, 20);
                        Util.ParticleEffects.sendToLocation(Util.ParticleEffects.ENCHANTMENT_TABLE, nexus, 1.0f, 1.0f, 1.0f, 0.0f, 20);
                    }
                    ++n2;
                }
            }
        }, 100L, 5L);
    }

    public void advancePhase() {
        ChatUtil.phaseMessage(this.timer.getPhase());
        if (this.timer.getPhase() == 2) {
            this.boss.spawnBosses();
        }
        if (this.timer.getPhase() == 3) {
            this.resources.spawnDiamonds();
        }
        Bukkit.getPluginManager().callEvent((Event)new PhaseChangeEvent(this.timer.getPhase()));
        this.getSignHandler().updateSigns(GameTeam.RED);
        this.getSignHandler().updateSigns(GameTeam.BLUE);
        this.getSignHandler().updateSigns(GameTeam.GREEN);
        this.getSignHandler().updateSigns(GameTeam.YELLOW);
    }

    public void onSecond() {
        long time = this.timer.getTime();
        if (time == -5L) {
            String winner = this.voting.getWinner();
            this.maps.selectMap(winner);
            this.getServer().broadcastMessage(ChatColor.GOLD + WordUtils.capitalize((String)winner) + ChatColor.GREEN + " gano la votacion!");
            this.loadMap(winner);
            this.voting.end();
        }
        if (time == 0L) {
            this.startGame();
        }
    }

    public int getPhase() {
        return this.timer.getPhase();
    }

    public MapManager getMapManager() {
        return this.maps;
    }

    public StatsManager getStatsManager() {
        return this.stats;
    }

    public DatabaseManager getDatabaseHandler() {
        return this.db;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public int getPhaseDelay() {
        return this.configManager.getConfig("config.yml").getInt("phase-period");
    }

    public void log(String m, Level l) {
        this.getLogger().log(l, m);
    }

    public VotingManager getVotingManager() {
        return this.voting;
    }

    public ScoreboardManager getScoreboardHandler() {
        return this.sb;
    }

    public void endGame(GameTeam winner) {
        if (winner == null) {
            return;
        }
        ChatUtil.winMessage(winner);
        this.timer.stop();
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (PlayerMeta.getMeta(p).getTeam() == winner) {
                this.stats.incrementStat(StatType.WINS, p);
            }
            ++n2;
        }
        long restartDelay = this.configManager.getConfig("config.yml").getLong("restart-delay");
        RestartHandler rs = new RestartHandler(this, restartDelay);
        rs.start(this.timer.getTime(), winner.getColor(winner));
    }

    public void reset() {
        Player p;
        this.sb.resetScoreboard(ChatColor.GREEN + "/v <mapa>" + ChatColor.GOLD + " (para votar)");
        this.maps.reset();
        this.timer.reset();
        PlayerMeta.reset();
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = playerArray[n2];
            PlayerMeta.getMeta(p).setTeam(GameTeam.NONE);
            p.teleport(this.maps.getLobbySpawnPoint());
            p.setMaxHealth(20.0);
            p.setHealth(20.0);
            p.setFoodLevel(20);
            p.setSaturation(20.0f);
            ++n2;
        }
        this.voting.start();
        this.sb.update();
        playerArray = Bukkit.getOnlinePlayers();
        n = playerArray.length;
        n2 = 0;
        while (n2 < n) {
            p = playerArray[n2];
            Player[] playerArray2 = Bukkit.getOnlinePlayers();
            int n3 = playerArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Player pp = playerArray2[n4];
                p.showPlayer(pp);
                pp.showPlayer(p);
                ++n4;
            }
            ++n2;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = DestruyeElNexus.this.getServer().getOnlinePlayers();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player p = objectArray[n2];
                    PlayerInventory inv = p.getInventory();
                    inv.setHelmet(null);
                    inv.setChestplate(null);
                    inv.setLeggings(null);
                    inv.setBoots(null);
                    p.getInventory().clear();
                    for (PotionEffect effect : p.getActivePotionEffects()) {
                        p.removePotionEffect(effect.getType());
                    }
                    p.setLevel(0);
                    p.setExp(0.0f);
                    p.setSaturation(20.0f);
                    ItemStack selector = new ItemStack(Material.FEATHER);
                    ItemMeta itemMeta = selector.getItemMeta();
                    itemMeta.setDisplayName(ChatColor.AQUA + "(Click Derecho) para seleccionar un kit");
                    selector.setItemMeta(itemMeta);
                    p.getInventory().setItem(0, selector);
                    p.updateInventory();
                    ++n2;
                }
                objectArray = GameTeam.values();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Player t = objectArray[n2];
                    if (t != GameTeam.NONE) {
                        DestruyeElNexus.this.sign.updateSigns((GameTeam)t);
                    }
                    ++n2;
                }
                DestruyeElNexus.this.checkStarting();
            }
        }, 2L);
    }

    public void checkWin() {
        int alive = 0;
        GameTeam aliveTeam = null;
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameTeam t = gameTeamArray[n2];
            if (t.getNexus().isAlive()) {
                ++alive;
                aliveTeam = t;
            }
            ++n2;
        }
        if (alive == 1) {
            this.endGame(aliveTeam);
        }
    }

    public SignManager getSignHandler() {
        return this.sign;
    }

    public void setSignHandler(SignManager sign) {
        this.sign = sign;
    }

    public void checkStarting() {
        if (!this.timer.isRunning() && Bukkit.getOnlinePlayers().length >= this.getConfig().getInt("requiredToStart")) {
            this.timer.start();
        }
    }

    public BossManager getBossManager() {
        return this.boss;
    }

    public PhaseManager getPhaseManager() {
        return this.timer;
    }

    public void listTeams(CommandSender sender) {
        sender.sendMessage(ChatColor.GRAY + "============[ " + ChatColor.DARK_AQUA + "Equipos" + ChatColor.GRAY + " ]============");
        GameTeam[] gameTeamArray = GameTeam.teams();
        int n = gameTeamArray.length;
        int n2 = 0;
        while (n2 < n) {
            GameTeam t = gameTeamArray[n2];
            int size = 0;
            Player[] playerArray = Bukkit.getOnlinePlayers();
            int n3 = playerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Player p = playerArray[n4];
                PlayerMeta meta = PlayerMeta.getMeta(p);
                if (meta.getTeam() == t) {
                    ++size;
                }
                ++n4;
            }
            if (size != 1) {
                sender.sendMessage(String.valueOf(t.coloredName()) + " - " + size + " " + Translation._("INFO_TEAM_LIST_PLAYERS") + Translation._("DYNAMIC_S"));
            } else {
                sender.sendMessage(String.valueOf(t.coloredName()) + " - " + size + " " + Translation._("INFO_TEAM_LIST_PLAYERS"));
            }
            ++n2;
        }
        sender.sendMessage(ChatColor.GRAY + "===============================");
    }

    public void joinTeam(Player player, String team) {
        GameTeam target;
        PlayerMeta meta = PlayerMeta.getMeta(player);
        if (meta.getTeam() != GameTeam.NONE && !player.hasPermission("DestruyeElNexus.bypass.teamlimitor")) {
            player.sendMessage(ChatColor.DARK_AQUA + Translation._("ERROR_PLAYER_NOSWITCHTEAM"));
            return;
        }
        try {
            target = GameTeam.valueOf(team.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(ChatColor.RED + Translation._("ERROR_GAME_INVALIDTEAM"));
            this.listTeams((CommandSender)player);
            return;
        }
        if (Util.isTeamTooBig(target) && !player.hasPermission("DestruyeElNexus.bypass.teamlimit")) {
            player.sendMessage(ChatColor.RED + Translation._("ERROR_GAME_TEAMFULL"));
            return;
        }
        if (target.getNexus() != null && target.getNexus().getHealth() == 0 && this.getPhase() > 1) {
            player.sendMessage(ChatColor.RED + Translation._("ERROR_GAME_TEAMNONEXUS"));
            return;
        }
        if (this.getPhase() > this.lastJoinPhase && !player.hasPermission("DestruyeElNexus.bypass.phaselimiter")) {
            player.kickPlayer(ChatColor.RED + "No se puede entrar al juego en esta Fase");
            return;
        }
        player.sendMessage(ChatColor.GOLD + "Entraste al equipo: " + target.coloredName());
        meta.setTeam(target);
        this.getScoreboardHandler().teams.get(team.toUpperCase()).addPlayer((OfflinePlayer)player);
        if (this.getPhase() > 0) {
            Util.sendPlayerToGame(player, this);
        }
        this.getSignHandler().updateSigns(GameTeam.RED);
        this.getSignHandler().updateSigns(GameTeam.BLUE);
        this.getSignHandler().updateSigns(GameTeam.GREEN);
        this.getSignHandler().updateSigns(GameTeam.YELLOW);
    }
}

