/*
 * Decompiled with CFR 0.152.
 */
package com.minestom.Utils;

import com.minestom.BossBarTimer;
import com.minestom.DataHandler.BossBarHandler;
import com.minestom.DataHandler.PlayerEditingData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Utilities {
    private BossBarTimer plugin;
    private Map<Player, PlayerEditingData> playerEditingDataMap = new HashMap<Player, PlayerEditingData>();

    public Utilities(BossBarTimer plugin) {
        this.plugin = plugin;
    }

    public String format(long input) {
        return this.formatDurationWords(input * 1000L, true, true);
    }

    private String formatDurationWords(long durationMillis, boolean suppressLeadingZero, boolean suppressTrailingZero) {
        String tmp;
        FileConfiguration configuration = this.plugin.getConfig();
        String days = configuration.getString("Messages.Format.Plural.Days");
        String hours = configuration.getString("Messages.Format.Plural.Hours");
        String minutes = configuration.getString("Messages.Format.Plural.Minutes");
        String seconds = configuration.getString("Messages.Format.Plural.Seconds");
        String day = configuration.getString("Messages.Format.Singular.Day");
        String hour = configuration.getString("Messages.Format.Singular.Hour");
        String minute = configuration.getString("Messages.Format.Singular.Minute");
        String second = configuration.getString("Messages.Format.Singular.Second");
        String duration = DurationFormatUtils.formatDuration((long)durationMillis, (String)("d' " + days + " 'H' " + hours + " 'm' " + minutes + " 's' " + seconds + "'"));
        if (suppressLeadingZero) {
            duration = " " + duration;
            tmp = StringUtils.replaceOnce((String)duration, (String)(" 0 " + days), (String)"");
            if (tmp.length() != duration.length()) {
                duration = tmp;
                if ((tmp = StringUtils.replaceOnce((String)tmp, (String)(" 0 " + hours), (String)"")).length() != duration.length()) {
                    duration = tmp = StringUtils.replaceOnce((String)tmp, (String)(" 0 " + minutes), (String)"");
                    if (tmp.length() != tmp.length()) {
                        duration = StringUtils.replaceOnce((String)tmp, (String)(" 0 " + seconds), (String)"");
                    }
                }
            }
            if (duration.length() != 0) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZero && (tmp = StringUtils.replaceOnce((String)duration, (String)(" 0 " + seconds), (String)"")).length() != duration.length()) {
            duration = tmp;
            if ((tmp = StringUtils.replaceOnce((String)tmp, (String)(" 0 " + minutes), (String)"")).length() != duration.length()) {
                duration = tmp;
                if ((tmp = StringUtils.replaceOnce((String)tmp, (String)(" 0 " + hours), (String)"")).length() != duration.length()) {
                    duration = StringUtils.replaceOnce((String)tmp, (String)(" 0 " + days), (String)"");
                }
            }
        }
        duration = " " + duration;
        duration = StringUtils.replaceOnce((String)duration, (String)(" 1 " + seconds), (String)(" 1 " + second));
        duration = StringUtils.replaceOnce((String)duration, (String)(" 1 " + minutes), (String)(" 1 " + minute));
        duration = StringUtils.replaceOnce((String)duration, (String)(" 1 " + hours), (String)(" 1 " + hour));
        duration = StringUtils.replaceOnce((String)duration, (String)(" 1 " + days), (String)(" 1 " + day));
        return duration.trim();
    }

    public Long timeToMillis(String timeFormat) {
        return this.timeToSeconds(timeFormat) * 1000L;
    }

    public Long timeToSeconds(String timeFormat) {
        String[] timeBefore = timeFormat.split(" ");
        long time = 0L;
        for (String timeString : timeBefore) {
            if (timeString.contains("s")) {
                time += Long.parseLong(timeString.replaceAll("[a-zA-Z]", ""));
            }
            if (timeString.contains("m")) {
                time += Long.parseLong(timeString.replaceAll("[a-zA-Z]", "")) * 60L;
            }
            if (timeString.contains("h")) {
                time += Long.parseLong(timeString.replaceAll("[a-zA-Z]", "")) * 3600L;
            }
            if (!timeString.contains("d")) continue;
            time += Long.parseLong(timeString.replaceAll("[a-zA-Z]", "")) * 86400L;
        }
        return time;
    }

    public void executeCommand(List<String> cmds) {
        for (String command : cmds) {
            if (command.contains("none") || command.isEmpty()) continue;
            if (!command.startsWith("[")) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
            if (command.startsWith("[message]")) {
                for (Object players : Bukkit.getOnlinePlayers()) {
                    players.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)command.replace("[message]", "")));
                }
            }
            if (command.startsWith("[title-subtitle]")) {
                Object players;
                String[] strings = command.replace("[title-subtitle]", "").split(";");
                players = Bukkit.getOnlinePlayers().iterator();
                while (players.hasNext()) {
                    Player players2 = (Player)players.next();
                    if (strings[1] == null) {
                        players2.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)strings[0]), null, 10, 40, 10);
                        continue;
                    }
                    if (strings[2] == null) {
                        players2.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)strings[0]), ChatColor.translateAlternateColorCodes((char)'&', (String)strings[1]), 10, 40, 10);
                        continue;
                    }
                    players2.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)strings[0]), ChatColor.translateAlternateColorCodes((char)'&', (String)strings[1]), Integer.valueOf(strings[2]).intValue(), Integer.valueOf(strings[3]).intValue(), Integer.valueOf(strings[4]).intValue());
                }
            }
            if (command.startsWith("[sound]")) {
                for (Object players : Bukkit.getOnlinePlayers()) {
                    players.playSound(players.getLocation(), Sound.valueOf((String)command.replace("[sound]", "").replace(" ", "").toUpperCase()), 1.0f, 2.0f);
                }
            }
            if (command.startsWith("[console]")) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command.replace("[console]", ""));
            }
            if (!command.startsWith("[player]")) continue;
            for (Object players : Bukkit.getOnlinePlayers()) {
                Bukkit.getServer().dispatchCommand((CommandSender)players, command.replace("[player]", ""));
            }
        }
    }

    public void addPlayerEditing(Player player) {
        this.playerEditingDataMap.put(player, new PlayerEditingData(new BossBarHandler(this.plugin)));
    }

    public void removePlayerEditing(Player player) {
        this.playerEditingDataMap.remove(player);
    }

    public Map<Player, PlayerEditingData> getPlayerEditingDataMap() {
        return this.playerEditingDataMap;
    }

    public PlayerEditingData getEditingData(Player player) {
        return this.playerEditingDataMap.get(player);
    }
}

