/*
 * Decompiled with CFR 0.152.
 */
package com.minestom.Utils;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtil {
    private static String prefix = "&cBossBarTimer > &7";

    public static void sendMessage(Player player, String message) {
        MessageUtil.sendMessage(player, message, true);
    }

    public static void sendMessage(CommandSender sender, String message) {
        String fullMessage = "";
        fullMessage = fullMessage + prefix;
        fullMessage = fullMessage + message;
        sender.sendMessage(MessageUtil.colorMessage(fullMessage));
    }

    public static void sendMessage(Player player, String message, boolean usePrefix) {
        String fullMessage = "";
        if (usePrefix) {
            fullMessage = fullMessage + prefix;
        }
        fullMessage = fullMessage + message;
        player.sendMessage(MessageUtil.colorMessage(fullMessage));
    }

    public static void sendDebugMessage(String message) {
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (player.hasPermission("bossbartimer.debug")) {
                player.sendMessage(MessageUtil.colorMessage("&cBBT Debug > " + message));
            }
        });
        Bukkit.getLogger().info(message);
    }

    public static void sendMessages(Player player, String[] messages) {
        MessageUtil.sendMessages(player, messages, true);
    }

    public static void sendMessages(Player player, String[] messages, boolean usePrefix) {
        for (String message : messages) {
            MessageUtil.sendMessage(player, message, usePrefix);
        }
    }

    public static void sendMessages(CommandSender sender, String[] messages, boolean prefix) {
        for (String message : messages) {
            if (!prefix) {
                sender.sendMessage(MessageUtil.colorMessage(message));
                continue;
            }
            MessageUtil.sendMessage(sender, message);
        }
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    private static String colorMessage(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

