/*
 * Decompiled with CFR 0.152.
 */
package com.minestom.Updater;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.minestom.BossBarTimer;
import com.minestom.Utils.MessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.bukkit.entity.Player;

public class Update {
    private final String REQUEST_URL;
    private final BossBarTimer plugin;
    private final Logger logger;
    private final int resourceId;

    public Update(BossBarTimer plugin, int resourceId) {
        this.REQUEST_URL = "https://api.spiget.org/v2/resources/" + resourceId + "/versions?sort=-releaseDate";
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.resourceId = resourceId;
    }

    public void sendUpdateMessage() {
        int newVersion = Integer.parseInt(this.getNewVersion().replaceAll("[^\\d]", ""));
        int currentVersion = Integer.parseInt(this.getCurrentVersion().replaceAll("[^\\d]", ""));
        this.logger.info("Looking for updates...");
        if (newVersion > currentVersion) {
            this.logger.info("There is a new update available.");
            this.logger.info("Current version " + this.getCurrentVersion());
            this.logger.info("Newest version " + this.getNewVersion());
            this.logger.info("Download the new version here: https://www.spigotmc.org/resources/" + this.resourceId);
        } else {
            this.logger.info("Plugin is up-to-date");
        }
    }

    public void sendUpdateMessage(Player player) {
        int currentVersion;
        int newVersion = Integer.parseInt(this.getNewVersion().replaceAll("[^\\d]", ""));
        if (newVersion > (currentVersion = Integer.parseInt(this.getCurrentVersion().replaceAll("[^\\d]", "")))) {
            String[] message = new String[]{"There is a new update available.", "Current version: &c" + this.getCurrentVersion(), "Newest version: &c" + this.getNewVersion(), "Download the new version here:", "https://www.spigotmc.org/resources/" + this.resourceId};
            MessageUtil.sendMessages(player, message, true);
        }
    }

    private String getNewVersion() {
        try {
            URL url = new URL(this.REQUEST_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            InputStream inputStream = connection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            JsonElement element = new JsonParser().parse((Reader)reader).getAsJsonArray().get(0);
            JsonObject jsonObject = element.getAsJsonObject();
            return jsonObject.get("name").getAsString();
        }
        catch (IOException e) {
            this.logger.info("Error while checking for update.");
            this.logger.info(e.getMessage());
            return "0";
        }
    }

    private String getCurrentVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

