/*
 * Decompiled with CFR 0.152.
 */
package com.minestom.Runnables;

import com.minestom.BossBarTimer;
import com.minestom.DataHandler.BossBarHandler;
import com.minestom.DataHandler.PlayerEditingData;
import com.minestom.Utils.MessageUtil;
import com.minestom.Utils.Utilities;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class Announcer
extends BukkitRunnable {
    private BossBarTimer plugin;
    private Utilities utilities;

    public Announcer(BossBarTimer plugin) {
        this.plugin = plugin;
        this.utilities = plugin.getUtilities();
    }

    public void run() {
        Map<String, Long> announcer = this.plugin.getAnnouncerTimer();
        for (Map.Entry<String, Long> entry : announcer.entrySet()) {
            String barName = entry.getKey();
            long time = entry.getValue();
            BossBarHandler bossBarHandler = this.plugin.getBarDataMap().get(barName);
            if (time == 0L) {
                long announcerTime = this.utilities.timeToSeconds(bossBarHandler.getAnnouncerTime());
                announcer.put(barName, announcerTime);
                bossBarHandler.start();
                if (!this.plugin.debug) continue;
                MessageUtil.sendDebugMessage("Announcing " + barName + "\nTime: " + time);
                continue;
            }
            if (time <= 1L) continue;
            announcer.put(barName, time - 1L);
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (!this.utilities.getPlayerEditingDataMap().containsKey(player)) {
                return;
            }
            PlayerEditingData editingData = this.utilities.getEditingData((Player)player);
            if (editingData.isEditingName() || editingData.isCreateBar()) {
                MessageUtil.sendTitle(player, "\u00a7aPlease enter the name", "\u00a7cin the chat", 0, 25, 0);
            }
            if (editingData.isEditTimer() || editingData.isAnnouncerTime() || editingData.isEditPeriod()) {
                MessageUtil.sendTitle(player, "\u00a7aPlease enter the time", "\u00a7cin the chat", 0, 25, 0);
            }
        });
    }
}

