/*
 * Decompiled with CFR 0.152.
 */
package com.minestom.DataHandler;

import com.minestom.Api.BarEndEvent;
import com.minestom.Api.BarStartEvent;
import com.minestom.BossBarTimer;
import com.minestom.Hooks.PlaceholderAPIHook;
import com.minestom.Utils.MessageUtil;
import com.minestom.Utils.Utilities;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BossBarHandler {
    private List<String> nameFrames;
    private List<String> commands;
    private int namePeriod;
    private long initialTime;
    private boolean announcerEnabled;
    private String countdownTime;
    private String color;
    private String style;
    private String announcerTime;
    private String barKeyName;
    private long currentTime;
    private int framesTask;
    private int countDownTask;
    private BossBarTimer plugin;
    private Utilities utilities;
    private boolean running;
    private boolean usePapi;
    private BossBar bar;

    public BossBarHandler() {
        this.running = false;
        this.usePapi = false;
    }

    public BossBarHandler(BossBarTimer plugin) {
        this.plugin = plugin;
        this.utilities = plugin.getUtilities();
        this.bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.running = false;
        this.usePapi = false;
    }

    public BossBarHandler(BossBarTimer plugin, String barKeyName, List<String> nameFrames, List<String> commands, int namePeriod, String countdownTime, String color, String style, boolean announcerEnabled, String announcerTime, long initialTime) {
        this.plugin = plugin;
        this.utilities = plugin.getUtilities();
        this.barKeyName = barKeyName;
        this.nameFrames = nameFrames;
        this.commands = commands;
        this.namePeriod = namePeriod;
        this.countdownTime = countdownTime;
        this.color = color;
        this.style = style;
        this.announcerEnabled = announcerEnabled;
        this.announcerTime = announcerTime;
        this.initialTime = initialTime;
        this.currentTime = this.utilities.timeToSeconds(countdownTime);
        this.bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.running = false;
        this.usePapi = false;
    }

    public void start() {
        if (this.plugin.debug) {
            MessageUtil.sendDebugMessage("Stating countdown...");
        }
        this.setRunning(true);
        this.setCurrentTime(this.utilities.timeToSeconds(this.countdownTime));
        this.setBarColor(this.getColor());
        this.setBarStyle(this.getStyle());
        Bukkit.getOnlinePlayers().forEach(this::addPlayer);
        new BukkitRunnable(){

            public void run() {
                if (BossBarHandler.this.currentTime == 0L) {
                    BossBarHandler.this.stop(true);
                } else {
                    BossBarHandler.this.currentTime--;
                    BossBarHandler.this.setBarProgress(BossBarHandler.this.currentTime, BossBarHandler.this.getInitialTime());
                }
                BossBarHandler.this.countDownTask = this.getTaskId();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.startAnimatedTitle();
        BarStartEvent barStartEvent = new BarStartEvent(this.plugin.getUtilities(), this);
        Bukkit.getServer().getPluginManager().callEvent((Event)barStartEvent);
    }

    public void startAnimatedTitle() {
        if (this.plugin.debug) {
            MessageUtil.sendDebugMessage("Stating Animation...");
        }
        new BukkitRunnable(){
            int i = -1;

            public void run() {
                if (BossBarHandler.this.nameFrames.isEmpty()) {
                    BossBarHandler.this.nameFrames.addAll(Arrays.asList("&cExample &fText", "&fExample &cText"));
                }
                if (this.i <= BossBarHandler.this.nameFrames.size()) {
                    ++this.i;
                }
                if (this.i >= BossBarHandler.this.nameFrames.size()) {
                    this.i = 0;
                }
                if (!BossBarHandler.this.usePapi) {
                    BossBarHandler.this.setBarName(((String)BossBarHandler.this.nameFrames.get(this.i)).replace("{time}", BossBarHandler.this.utilities.format(BossBarHandler.this.getCurrentTime())));
                } else {
                    BossBarHandler.this.bar.getPlayers().forEach(player -> BossBarHandler.this.setBarName(PlaceholderAPIHook.translateToString(player, ((String)BossBarHandler.this.nameFrames.get(this.i)).replace("{time}", BossBarHandler.this.utilities.format(BossBarHandler.this.getCurrentTime())))));
                }
                BossBarHandler.this.framesTask = this.getTaskId();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)this.namePeriod);
        if (this.plugin.debug) {
            MessageUtil.sendDebugMessage("Stopping countdown...");
        }
    }

    public void stop(boolean b) {
        Bukkit.getOnlinePlayers().forEach(this::removeBar);
        this.setRunning(false);
        this.setBarProgress(1.0, 1.0);
        if (b) {
            this.utilities.executeCommand(this.getCommands());
        }
        this.stopAnimatedTitle();
        Bukkit.getScheduler().cancelTask(this.countDownTask);
        BarEndEvent barEndEvent = new BarEndEvent(this.utilities, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)barEndEvent);
        if (this.plugin.debug) {
            MessageUtil.sendDebugMessage("Stopping countdown...");
        }
    }

    public void stopAnimatedTitle() {
        if (this.plugin.debug) {
            MessageUtil.sendDebugMessage("Stopping Animation...");
        }
        Bukkit.getScheduler().cancelTask(this.framesTask);
    }

    public String getBarKeyName() {
        return this.barKeyName;
    }

    public void setBarKeyName(String barKeyName) {
        this.barKeyName = barKeyName;
    }

    public List<String> getNameFrames() {
        return this.nameFrames;
    }

    public void setNameFrames(List<String> nameFrames) {
        this.nameFrames = nameFrames;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public int getNamePeriod() {
        return this.namePeriod;
    }

    public void setNamePeriod(int namePeriod) {
        this.namePeriod = namePeriod;
    }

    public String getCountdownTime() {
        return this.countdownTime;
    }

    public void setCountdownTime(String countdownTime) {
        this.countdownTime = countdownTime;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isAnnouncerEnabled() {
        return this.announcerEnabled;
    }

    public void setAnnouncerEnabled(boolean announcerEnabled) {
        this.announcerEnabled = announcerEnabled;
    }

    public String getAnnouncerTime() {
        return this.announcerTime;
    }

    public void setAnnouncerTime(String announcerTime) {
        this.announcerTime = announcerTime;
    }

    private long getInitialTime() {
        return this.initialTime;
    }

    public void setInitialTime(long initialTime) {
        this.initialTime = initialTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    public void createBar(String title, String color, String style) {
        this.bar = Bukkit.createBossBar((String)ChatColor.translateAlternateColorCodes((char)'&', (String)title), (BarColor)BarColor.valueOf((String)color.toUpperCase()), (BarStyle)BarStyle.valueOf((String)style.toUpperCase()), (BarFlag[])new BarFlag[0]);
    }

    public void addPlayer(Player player) {
        if (!this.bar.getPlayers().contains(player) && this.bar != null) {
            this.bar.addPlayer(player);
        }
    }

    public void setBarProgress(double progress, double initialTime) {
        double barProgress = initialTime / progress;
        this.bar.setProgress(1.0 / barProgress);
    }

    public boolean containsBar(Player player) {
        return this.bar.getPlayers().contains(player);
    }

    public void removeBar(Player player) {
        this.bar.removePlayer(player);
    }

    public String getBarColor() {
        return this.bar.getColor().name();
    }

    public void setBarColor(String color) {
        this.bar.setColor(BarColor.valueOf((String)color.toUpperCase()));
    }

    public String getBarStyle() {
        return this.bar.getStyle().name().replace("_", "");
    }

    public void setBarStyle(String style) {
        this.bar.setStyle(BarStyle.valueOf((String)style.toUpperCase()));
    }

    public String getBarName() {
        return this.bar.getTitle();
    }

    public void setBarName(String text) {
        this.bar.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
    }

    public boolean isUsePapi() {
        return this.usePapi;
    }

    public void setUsePapi(boolean usePapi) {
        this.usePapi = usePapi;
    }
}

