/*
 * Decompiled with CFR 0.152.
 */
package com.minestom.Commands;

import com.minestom.BossBarTimer;
import com.minestom.DataHandler.BossBarHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class BbtCompleter
implements TabCompleter {
    private static final String[] COMMANDS = new String[]{"start", "stop", "reload", "debug", "update"};
    private BossBarTimer plugin;

    public BbtCompleter(BossBarTimer plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String s, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partialCommand = args[0];
            ArrayList<String> commands = new ArrayList<String>(Arrays.asList(COMMANDS));
            StringUtil.copyPartialMatches((String)partialCommand, commands, completions);
        }
        if (args.length == 2) {
            String bars = args[1];
            ArrayList<String> barsName = new ArrayList<String>();
            if (args[0].equalsIgnoreCase("start")) {
                for (String names : this.plugin.getBarDataMap().keySet()) {
                    barsName.add(names);
                }
            }
            if (args[0].equalsIgnoreCase("stop")) {
                for (BossBarHandler bossBarHandler : this.plugin.getBarDataMap().values()) {
                    if (!bossBarHandler.isRunning()) continue;
                    barsName.add(bossBarHandler.getBarKeyName());
                }
            }
            StringUtil.copyPartialMatches((String)bars, barsName, completions);
        }
        Collections.sort(completions);
        return completions;
    }
}

