/*
 * Decompiled with CFR 0.152.
 */
package com.minestom;

import com.minestom.BarMenuCreator.BarListener.AvancedMenu;
import com.minestom.BarMenuCreator.BarListener.ColorsMenu;
import com.minestom.BarMenuCreator.BarListener.ConfirmMenu;
import com.minestom.BarMenuCreator.BarListener.EditCurrentBarsMenu;
import com.minestom.BarMenuCreator.BarListener.EditMenu;
import com.minestom.BarMenuCreator.BarListener.InChatEdition;
import com.minestom.BarMenuCreator.BarListener.MainMenu;
import com.minestom.BarMenuCreator.BarListener.StylesMenu;
import com.minestom.Commands.BbtCommand;
import com.minestom.Commands.BbtCompleter;
import com.minestom.DataHandler.BossBarHandler;
import com.minestom.JoinListener;
import com.minestom.Runnables.Announcer;
import com.minestom.Updater.Update;
import com.minestom.Utils.Utilities;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class BossBarTimer
extends JavaPlugin
implements Listener {
    private Map<String, Long> announcer = new HashMap<String, Long>();
    private Map<String, BossBarHandler> barDataMap = new HashMap<String, BossBarHandler>();
    public boolean debug = false;
    private Utilities utilities;
    private Update update;

    public void onEnable() {
        if (this.getServer().getVersion().contains("1.8")) {
            this.getLogger().info("Your server version is not compatible with the plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupConfig();
        this.init();
        this.registerListeners();
        this.registerCommands();
        this.loadBars();
        this.getLogger().info("Plugin made by " + this.getDescription().getAuthors().toString());
        this.update.sendUpdateMessage();
        this.getLogger().info("The plugin is now ready to use!");
    }

    public void onDisable() {
        this.getLogger().info("Thanks for using the plugin!");
        this.getLogger().info("Plugin successfully disabled");
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.saveBarData();
    }

    private void saveBarData() {
        for (BossBarHandler bossBarHandler : this.getBarDataMap().values()) {
            if (!bossBarHandler.isRunning()) continue;
            String barName = bossBarHandler.getBarKeyName();
            long timeLeft = bossBarHandler.getCurrentTime();
            if (timeLeft != 0L) {
                this.getConfig().set("Data." + barName, (Object)timeLeft);
                this.saveConfig();
            }
            Bukkit.getOnlinePlayers().forEach(bossBarHandler::removeBar);
        }
    }

    public void loadBars() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        new Announcer(this).runTaskTimer((Plugin)this, 0L, 20L);
        for (String barName : this.getConfig().getConfigurationSection("Bars").getKeys(false)) {
            if (this.barDataMap.containsKey(barName)) continue;
            this.barDataMap.put(barName, new BossBarHandler(this, barName, this.getConfig().getStringList("Bars." + barName + ".DisplayName.Frames"), this.getConfig().getStringList("Bars." + barName + ".Commands"), this.getConfig().getInt("Bars." + barName + ".DisplayName.Period"), this.getConfig().getString("Bars." + barName + ".Time"), this.getConfig().getString("Bars." + barName + ".Color"), this.getConfig().getString("Bars." + barName + ".Style"), this.getConfig().getBoolean("Bars." + barName + ".AnnouncerMode.Enabled"), this.getConfig().getString("Bars." + barName + ".AnnouncerMode.Time"), this.utilities.timeToSeconds(this.getConfig().getString("Bars." + barName + ".Time"))));
            this.barDataMap.get(barName).setUsePapi(this.getConfig().getBoolean("Use-PlaceholderAPI"));
            if (!this.barDataMap.get(barName).isAnnouncerEnabled()) continue;
            String timeFormat = this.getConfig().getString("Bars." + barName + ".AnnouncerMode.Time");
            this.announcer.put(barName, this.utilities.timeToSeconds(timeFormat));
        }
        this.loadBarsData();
    }

    private void loadBarsData() {
        ConfigurationSection data = this.getConfig().getConfigurationSection("Data");
        if (data != null) {
            for (String barName : data.getKeys(false)) {
                BossBarHandler bossBarHandler = this.barDataMap.get(barName);
                bossBarHandler.start();
                bossBarHandler.setCurrentTime(this.getConfig().getLong("Data." + barName));
            }
            this.getConfig().set("Data", null);
            this.saveConfig();
        }
    }

    private void init() {
        this.utilities = new Utilities(this);
        this.update = new Update(this, 53291);
    }

    private void setupConfig() {
        if (!new File(this.getDataFolder(), "config.yml").exists()) {
            this.saveDefaultConfig();
        }
    }

    private void registerCommands() {
        this.getCommand("bossbartimer").setExecutor((CommandExecutor)new BbtCommand(this));
        this.getCommand("bossbartimer").setTabCompleter((TabCompleter)new BbtCompleter(this));
    }

    private void registerListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new MainMenu(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new EditMenu(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ColorsMenu(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new StylesMenu(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ConfirmMenu(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new AvancedMenu(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new JoinListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new InChatEdition(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new EditCurrentBarsMenu(this), (Plugin)this);
    }

    public Utilities getUtilities() {
        return this.utilities;
    }

    public Map<String, Long> getAnnouncerTimer() {
        return this.announcer;
    }

    public Update getUpdate() {
        return this.update;
    }

    public Map<String, BossBarHandler> getBarDataMap() {
        return this.barDataMap;
    }
}

