/*
 * Decompiled with CFR 0.152.
 */
package me.MC_Hoxen.socialmediacommands;

import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    Logger myPluginLogger = this.getLogger();
    Inventory myInventory = Bukkit.createInventory(null, (int)27, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("GUI-Title")));
    ItemStack blank;
    ItemStack web;
    ItemStack discord;
    ItemStack teamspeak;
    ItemStack twitter;
    ItemStack youtube;
    ItemStack instagram;
    ItemStack snapchat;

    public void onEnable() {
        this.myPluginLogger.info("Social Media Commands has been successfully enabled!");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.constructInventory();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public boolean onCommand(CommandSender theSender, Command cmd, String commandLabel, String[] args) {
        if (!(theSender instanceof Player)) {
            return false;
        }
        Player player = (Player)theSender;
        String mediaType = null;
        if (cmd.getName().equalsIgnoreCase("website")) {
            mediaType = "Website";
        } else if (cmd.getName().equalsIgnoreCase("discord")) {
            mediaType = "Discord";
        } else if (cmd.getName().equalsIgnoreCase("teamspeak")) {
            mediaType = "TeamSpeak";
        } else if (cmd.getName().equalsIgnoreCase("twitter")) {
            mediaType = "Twitter";
        } else if (cmd.getName().equalsIgnoreCase("youtube")) {
            mediaType = "YouTube";
        } else if (cmd.getName().equalsIgnoreCase("instagram")) {
            mediaType = "Instagram";
        } else if (cmd.getName().equalsIgnoreCase("snapchat")) {
            mediaType = "SnapChat";
        }
        if (mediaType != null) {
            boolean mediaTypeEnabled = this.getConfig().getBoolean("Enable" + mediaType);
            if (!mediaTypeEnabled) {
                player.sendMessage("Unknown command. Type \"/help\" for help.");
                return true;
            }
            if (player.hasPermission("smc." + mediaType.toLowerCase() + ".use")) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.getConfig().getString("Prefix")) + this.getConfig().getString("Your-" + mediaType + "-Message"))));
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Permission-Denied")));
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("socialmedia")) {
            boolean guiEnabled = Boolean.parseBoolean(this.getConfig().getString("EnableSocialMediaGUI"));
            if (!guiEnabled) {
                player.sendMessage("Unknown command. Type \"/help\" for help.");
                return true;
            }
            if (player.hasPermission("smc.socialmedia.use")) {
                player.openInventory(this.myInventory);
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Permission-Denied")));
            }
        } else if (cmd.getName().equalsIgnoreCase("reloadconfig")) {
            this.saveConfig();
            this.reloadConfig();
            for (Player p : this.getServer().getOnlinePlayers()) {
                if (p.getOpenInventory() == null || !p.getOpenInventory().getTitle().equals(this.myInventory.getTitle())) continue;
                p.closeInventory();
                p.sendMessage("Your inventory has been closed to due a plugin data reload; you may now reopen the inventory.");
            }
            this.constructInventory();
            player.sendMessage(ChatColor.RED + "Social Media Commands has been reloaded!");
        }
        return false;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        Inventory inventory = event.getInventory();
        if (!inventory.getName().equals(this.myInventory.getName())) {
            return;
        }
        if (clicked == null) {
            return;
        }
        Material type = clicked.getType();
        if (type == this.blank.getType()) {
            event.setCancelled(true);
            return;
        }
        String command = null;
        if (event.getRawSlot() == this.getConfig().getInt("Website-Slot")) {
            command = "website";
        } else if (event.getRawSlot() == this.getConfig().getInt("Discord-Slot")) {
            command = "discord";
        } else if (event.getRawSlot() == this.getConfig().getInt("TeamSpeak-Slot")) {
            command = "teamspeak";
        } else if (event.getRawSlot() == this.getConfig().getInt("Twitter-Slot")) {
            command = "twitter";
        } else if (event.getRawSlot() == this.getConfig().getInt("YouTube-Slot")) {
            command = "youtube";
        } else if (event.getRawSlot() == this.getConfig().getInt("Instagram-Slot")) {
            command = "instagram";
        } else if (event.getRawSlot() == this.getConfig().getInt("Snapchat-Slot")) {
            command = "snapchat";
        }
        if (command != null) {
            event.setCancelled(true);
            player.closeInventory();
            Bukkit.dispatchCommand((CommandSender)player, (String)command);
        }
    }

    public ItemStack createItem(Material mat, String displayName) {
        ItemStack toReturn = new ItemStack(mat);
        ItemMeta itemMeta = toReturn.getItemMeta();
        itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)displayName));
        toReturn.setItemMeta(itemMeta);
        return toReturn;
    }

    public ItemStack createItem(String matName, String displayName) {
        Material m = Material.getMaterial((String)matName.toUpperCase().replace(" ", "_"));
        if (m == null) {
            return null;
        }
        return this.createItem(m, displayName);
    }

    public void constructInventory() {
        this.myInventory = Bukkit.createInventory(null, (int)this.getConfig().getInt("GUI-Size"), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("GUI-Title")));
        this.blank = new ItemStack(Material.valueOf((String)this.getConfig().getString("GUI-Blank-Item").toUpperCase()), 1, (short)DyeColor.valueOf((String)this.getConfig().getString("GUI-Blank-Item-Color").toUpperCase()).getData());
        ItemMeta blankMeta = this.blank.getItemMeta();
        blankMeta.setDisplayName(" ");
        this.blank.setItemMeta(blankMeta);
        int i = 0;
        while (i < this.myInventory.getSize()) {
            this.myInventory.setItem(i, this.blank);
            ++i;
        }
        this.web = new ItemStack((int)((byte)this.getConfig().getInt("WebsiteDisplayItem")), 1, (short)((byte)this.getConfig().getInt("WebsiteDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("Website-Slot"), this.web);
        ItemMeta webMeta = this.web.getItemMeta();
        webMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Website-Display-Name")));
        this.web.setItemMeta(webMeta);
        this.myInventory.getItem(this.getConfig().getInt("Website-Slot")).setItemMeta(webMeta);
        this.discord = new ItemStack((int)((byte)this.getConfig().getInt("DiscordDisplayItem")), 1, (short)((byte)this.getConfig().getInt("DiscordDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("Discord-Slot"), this.discord);
        ItemMeta discordMeta = this.discord.getItemMeta();
        discordMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Discord-Display-Name")));
        this.discord.setItemMeta(discordMeta);
        this.myInventory.getItem(this.getConfig().getInt("Discord-Slot")).setItemMeta(discordMeta);
        this.teamspeak = new ItemStack((int)((byte)this.getConfig().getInt("TeamSpeakDisplayItem")), 1, (short)((byte)this.getConfig().getInt("TeamSpeakDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("TeamSpeak-Slot"), this.teamspeak);
        ItemMeta teamspeakMeta = this.teamspeak.getItemMeta();
        teamspeakMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("TeamSpeak-Display-Name")));
        this.teamspeak.setItemMeta(teamspeakMeta);
        this.myInventory.getItem(this.getConfig().getInt("TeamSpeak-Slot")).setItemMeta(teamspeakMeta);
        this.twitter = new ItemStack((int)((byte)this.getConfig().getInt("TwitterDisplayItem")), 1, (short)((byte)this.getConfig().getInt("TwitterDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("Twitter-Slot"), this.twitter);
        ItemMeta twitterMeta = this.twitter.getItemMeta();
        twitterMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Twitter-Display-Name")));
        this.twitter.setItemMeta(twitterMeta);
        this.myInventory.getItem(this.getConfig().getInt("Twitter-Slot")).setItemMeta(twitterMeta);
        this.youtube = new ItemStack((int)((byte)this.getConfig().getInt("YouTubeDisplayItem")), 1, (short)((byte)this.getConfig().getInt("YouTubeDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("YouTube-Slot"), this.youtube);
        ItemMeta youtubeMeta = this.youtube.getItemMeta();
        youtubeMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("YouTube-Display-Name")));
        this.discord.setItemMeta(youtubeMeta);
        this.myInventory.getItem(this.getConfig().getInt("YouTube-Slot")).setItemMeta(youtubeMeta);
        this.instagram = new ItemStack((int)((byte)this.getConfig().getInt("InstagramDisplayItem")), 1, (short)((byte)this.getConfig().getInt("InstagramDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("Instagram-Slot"), this.instagram);
        ItemMeta instagramMeta = this.instagram.getItemMeta();
        instagramMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Instagram-Display-Name")));
        this.discord.setItemMeta(instagramMeta);
        this.myInventory.getItem(this.getConfig().getInt("Instagram-Slot")).setItemMeta(instagramMeta);
        this.snapchat = new ItemStack((int)((byte)this.getConfig().getInt("SnapchatDisplayItem")), 1, (short)((byte)this.getConfig().getInt("SnapchatDisplayItemSecondary")));
        this.myInventory.setItem(this.getConfig().getInt("Snapchat-Slot"), this.snapchat);
        ItemMeta snapchatMeta = this.snapchat.getItemMeta();
        snapchatMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("Snapchat-Display-Name")));
        this.snapchat.setItemMeta(snapchatMeta);
        this.myInventory.getItem(this.getConfig().getInt("Snapchat-Slot")).setItemMeta(snapchatMeta);
        if (!this.getConfig().getBoolean("EnableWebsite")) {
            this.myInventory.setItem(this.getConfig().getInt("Website-Slot"), this.blank);
        }
        if (!this.getConfig().getBoolean("EnableDiscord")) {
            this.myInventory.setItem(this.getConfig().getInt("Discord-Slot"), this.blank);
        }
        if (!this.getConfig().getBoolean("EnableTeamSpeak")) {
            this.myInventory.setItem(this.getConfig().getInt("TeamSpeak-Slot"), this.blank);
        }
        if (!this.getConfig().getBoolean("EnableTwitter")) {
            this.myInventory.setItem(this.getConfig().getInt("Twitter-Slot"), this.blank);
        }
        if (!this.getConfig().getBoolean("EnableYouTube")) {
            this.myInventory.setItem(this.getConfig().getInt("YouTube-Slot"), this.blank);
        }
        if (!this.getConfig().getBoolean("EnableInstagram")) {
            this.myInventory.setItem(this.getConfig().getInt("Instagram-Slot"), this.blank);
        }
        if (!this.getConfig().getBoolean("EnableSnapChat")) {
            this.myInventory.setItem(this.getConfig().getInt("Snapchat-Slot"), this.blank);
        }
    }

    public void onDisable() {
        this.myPluginLogger.info("Social Media Commands has been disabled!");
    }
}

