/*
 * Decompiled with CFR 0.152.
 */
package me.shir.combatentity.managers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.shir.combatentity.entity.CombatEntity;
import me.shir.combatentity.entity.CombatMob;
import me.shir.uhcp.player.PlayerManager;
import me.shir.uhcp.player.UHCPlayer;
import me.shir.uhcp.scenarios.ScenarioManager;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.v1_7_R4.Entity;
import net.minecraft.server.v1_7_R4.World;
import net.minecraft.server.v1_7_R4.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EntityManager {
    private final Map<String, CombatEntity> entity = new HashMap<String, CombatEntity>();
    private final Set<Chunk> protectedChunks = new HashSet<Chunk>();

    public void setCombatEntity(String name) {
        Player wplayer = Bukkit.getServer().getPlayer(name);
        WorldServer world = ((CraftWorld)wplayer.getWorld()).getHandle();
        CombatEntity combatEntity = new CombatEntity((World)world);
        combatEntity.setCustomName(String.valueOf(name) + " (Combat Entity)");
        CraftEntity entity = combatEntity.getBukkitEntity();
        this.protectedChunks.add(entity.getLocation().getChunk());
        ((LivingEntity)entity).setRemoveWhenFarAway(false);
        ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 999999999, 500));
        Location location = new Location(wplayer.getWorld(), (double)wplayer.getLocation().getBlockX() + 0.5, (double)wplayer.getLocation().getBlockY(), (double)wplayer.getLocation().getBlockZ() + 0.5);
        new CombatMob().spawnEntity((Entity)combatEntity, location);
        EntityEquipment ee = ((LivingEntity)entity).getEquipment();
        ee.setArmorContents(PlayerManager.getPlayerManager().getUHCPlayer(wplayer.getUniqueId()).lastArmour());
        ee.setItemInHand(wplayer.getInventory().getItemInHand());
        this.entity.put(name, combatEntity);
        this.entity.put(name, combatEntity);
        this.protectedChunks.add(combatEntity.getBukkitEntity().getLocation().getChunk());
    }

    public CombatEntity getCombatEntity(String name) {
        CombatEntity combatEntity = this.entity.get(name);
        return combatEntity;
    }

    public void killEntity(boolean b, String name, UUID uuid) {
        if (this.getCombatEntity(name) != null) {
            CraftEntity entity = this.getCombatEntity(name).getBukkitEntity();
            if (b) {
                ItemStack itemStack;
                UHCPlayer uhcPlayer = PlayerManager.getPlayerManager().getUHCPlayer(uuid);
                ((LivingEntity)entity).getEquipment().clear();
                ItemStack[] itemStackArray = uhcPlayer.lastArmour();
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    itemStack = itemStackArray[n2];
                    if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) {
                        entity.getWorld().dropItemNaturally(entity.getLocation(), itemStack);
                    }
                    ++n2;
                }
                itemStackArray = uhcPlayer.lastInventory();
                n = itemStackArray.length;
                n2 = 0;
                while (n2 < n) {
                    itemStack = itemStackArray[n2];
                    if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) {
                        entity.getWorld().dropItemNaturally(entity.getLocation(), itemStack);
                        if (!ScenarioManager.getInstance().getScenarioExact("TimeBomb").isEnabled()) {
                            entity.getWorld().dropItemNaturally(entity.getLocation(), new ItemStack(Material.SKULL_ITEM, 1, 3));
                        } else {
                            ItemStack gh = new ItemStack(Material.GOLDEN_APPLE, 1);
                            ItemMeta ghM = gh.getItemMeta();
                            ghM.setDisplayName(ChatColor.GOLD + "Golden Head");
                            gh.setItemMeta(ghM);
                            entity.getWorld().dropItemNaturally(entity.getLocation(), gh);
                        }
                    }
                    ++n2;
                }
            } else {
                ((LivingEntity)entity).getEquipment().clear();
            }
            CraftEntity entity1 = this.getCombatEntity(name).getBukkitEntity();
            this.getCombatEntity(name).setHealth(-10.0f);
            entity1.remove();
            if (this.protectedChunks.contains(entity1.getLocation().getChunk())) {
                this.protectedChunks.remove(entity1.getLocation().getChunk());
            }
            if (entity != null) {
                entity.remove();
            }
            if (this.protectedChunks.contains(entity.getLocation().getChunk())) {
                this.protectedChunks.remove(entity.getLocation().getChunk());
            }
            this.entity.remove(name);
        }
    }

    public Set<Chunk> getProtectedChunks() {
        return this.protectedChunks;
    }
}

