/*
 * Decompiled with CFR 0.152.
 */
package me.shir.combatentity.listeners;

import me.shir.combatentity.Main;
import me.shir.combatentity.managers.EntityManager;
import me.shir.uhcp.game.GameManager;
import me.shir.uhcp.player.PlayerManager;
import me.shir.uhcp.player.UHCPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerQuitListener
implements Listener {
    private Main plugin;
    private final EntityManager entityManager;

    public PlayerQuitListener(Main plugin) {
        this.plugin = plugin;
        this.entityManager = plugin.getEntityManager();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuitEvent(PlayerQuitEvent e) {
        if (GameManager.getGameManager().isGameRunning()) {
            final Player player = e.getPlayer();
            final UHCPlayer uhcPlayer = PlayerManager.getPlayerManager().getUHCPlayer(player.getUniqueId());
            if (uhcPlayer.isPlayerAlive() && player.getWorld() != GameManager.getGameManager().getSpawnWorld()) {
                this.entityManager.setCombatEntity(player.getName());
                new BukkitRunnable(){

                    public void run() {
                        if (PlayerQuitListener.this.entityManager.getCombatEntity(player.getName()) != null) {
                            PlayerQuitListener.this.entityManager.killEntity(true, player.getName(), player.getUniqueId());
                            uhcPlayer.setPlayerAlive(false);
                            uhcPlayer.setDied(true);
                            player.setWhitelisted(false);
                            Bukkit.getServer().broadcastMessage(String.valueOf(uhcPlayer.getName()) + " (Combat Entity) died");
                            if (player.hasPermission("uhc.spectate")) {
                                PlayerManager.getPlayerManager().setSpectating(true, player);
                            }
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 12000L);
            }
        }
    }
}

