/*
 * Decompiled with CFR 0.152.
 */
package me.shir.combatentity.listeners;

import me.shir.combatentity.Main;
import me.shir.combatentity.managers.EntityManager;
import me.shir.uhcp.game.GameManager;
import me.shir.uhcp.player.PlayerManager;
import me.shir.uhcp.player.UHCPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class Listeners
implements Listener {
    private final EntityManager entityManager;

    public Listeners(Main plugin) {
        this.entityManager = plugin.getEntityManager();
    }

    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent e) {
        Zombie zombie;
        if (GameManager.getGameManager().isGameRunning() && e.getEntity().getType().equals((Object)EntityType.ZOMBIE) && (zombie = (Zombie)e.getEntity()).getCustomName() != null) {
            e.getDrops().clear();
            Player playerKiller = e.getEntity().getKiller();
            UHCPlayer uhcPlayerKiller = PlayerManager.getPlayerManager().getUHCPlayer(playerKiller.getUniqueId());
            for (UHCPlayer uhcPlayers : PlayerManager.getPlayerManager().getUHCPlayers().values()) {
                if (!(String.valueOf(uhcPlayers.getName()) + " (Combat Entity)").equalsIgnoreCase(zombie.getCustomName()) || this.entityManager.getCombatEntity(uhcPlayers.getName()) == null) continue;
                this.entityManager.killEntity(true, uhcPlayers.getName(), uhcPlayers.getUuid());
                uhcPlayers.setPlayerAlive(false);
                uhcPlayers.setDied(true);
                uhcPlayers.addTotalDeath();
                uhcPlayerKiller.addKill();
                uhcPlayerKiller.addTotalKill();
                Bukkit.getServer().getOfflinePlayer(uhcPlayers.getUuid()).setWhitelisted(false);
                if (e.getEntity().getKiller() instanceof Player) {
                    Bukkit.getServer().broadcastMessage(String.valueOf(uhcPlayers.getName()) + " (Combat Entity) was killed by " + e.getEntity().getKiller().getName());
                    continue;
                }
                Bukkit.getServer().broadcastMessage(String.valueOf(uhcPlayers.getName()) + " (Combat Entity) died");
            }
        }
    }

    @EventHandler
    public void onChunkUnloadEvent(ChunkUnloadEvent e) {
        if (this.entityManager.getProtectedChunks().contains(e.getChunk())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageEvent(EntityDamageEvent e) {
        Zombie combatEntity;
        if (e.getEntity() instanceof Zombie && GameManager.getGameManager().isGameRunning() && (combatEntity = (Zombie)e.getEntity()).getCustomName() != null) {
            if (!GameManager.getGameManager().isPvpEnabled()) {
                e.setCancelled(true);
            }
            if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE) || e.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE_TICK)) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent e) {
        Zombie zombie;
        if (e.getDamager().getType().equals((Object)EntityType.ZOMBIE) && (zombie = (Zombie)e.getDamager()).getCustomName() != null) {
            e.setCancelled(true);
        }
    }
}

