/*
 * Decompiled with CFR 0.152.
 */
package me.insane9killz.Party;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.insane9killz.Party.Main;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class PlayerParty {
    private ProxiedPlayer leader;
    private List<ProxiedPlayer> players;
    private List<ProxiedPlayer> invitations;

    public PlayerParty(ProxiedPlayer leader) {
        this.leader = leader;
        this.players = new ArrayList<ProxiedPlayer>();
        this.invitations = new ArrayList<ProxiedPlayer>();
    }

    public boolean isLeader(ProxiedPlayer player) {
        return this.leader == player;
    }

    public List<ProxiedPlayer> getPlayers() {
        return this.players;
    }

    public ProxiedPlayer getLeader() {
        return this.leader;
    }

    public boolean isInParty(ProxiedPlayer player) {
        if (this.isLeader(player)) {
            return true;
        }
        return this.players.contains(player);
    }

    public boolean addPlayer(ProxiedPlayer player) {
        if (!this.players.contains(player) && this.invitations.contains(player)) {
            this.players.add(player);
            this.invitations.remove(player);
            return true;
        }
        return false;
    }

    public boolean removePlayer(ProxiedPlayer player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            return true;
        }
        return false;
    }

    public ServerInfo getServer() {
        return this.leader.getServer().getInfo();
    }

    public void invite(final ProxiedPlayer p) {
        this.invitations.add(p);
        p.sendMessage((BaseComponent)new TextComponent(String.valueOf(Main.prefix) + "\u00a77You are invited in \u00a76" + this.leader.getName() + "'s \u00a77party."));
        p.sendMessage((BaseComponent)new TextComponent(String.valueOf(Main.prefix) + "\u00a77Join \u00a77the \u00a77party \u00a77with \u00a77/\u00a77party \u00a77join \u00a76" + this.leader.getName()));
        BungeeCord.getInstance().getScheduler().schedule((Plugin)Main.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (PlayerParty.this.invitations.contains(p)) {
                    PlayerParty.this.invitations.remove(p);
                    p.sendMessage((BaseComponent)new TextComponent(String.valueOf(Main.prefix) + "\u00a77Your invitations has been expired."));
                    PlayerParty.this.leader.sendMessage((BaseComponent)new TextComponent(String.valueOf(Main.prefix) + "\u00a77The invitation to \u00a76" + p.getName() + " \u00a77has been expired."));
                }
            }
        }, 30L, TimeUnit.SECONDS);
    }
}

