/*
 * Decompiled with CFR 0.152.
 */
package com.spawnchunk.worldregen.modules;

import com.spawnchunk.worldregen.WorldRegen;
import com.spawnchunk.worldregen.config.Config;
import com.spawnchunk.worldregen.util.MessageUtil;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.entity.Player;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;

public class World {
    private static boolean regen = false;
    private static boolean autoSave = false;
    private static ChunkGenerator generator;

    public static void onWorldUnloadEvent(WorldUnloadEvent event) {
        org.bukkit.World world = event.getWorld();
        String worldName = world.getName();
        WorldCreator worldCreator = new WorldCreator(worldName).copy(world);
        if (regen) {
            regen = false;
            World.removeWorldFolder(world);
            World.createWorld(worldName, worldCreator);
        }
    }

    public static void regenWorld(String worldName) {
        Server server = WorldRegen.plugin.getServer();
        org.bukkit.World world = server.getWorld(worldName);
        if (world != null) {
            generator = world.getGenerator();
            autoSave = world.isAutoSave();
            world.setAutoSave(false);
            World.bumpPlayers(world);
            regen = true;
            World.unloadWorld(world);
        }
    }

    private static void bumpPlayers(org.bukkit.World world) {
        if (Config.debug) {
            WorldRegen.logger.info("Teleporting players to spawn location");
        }
        if (world != null) {
            List players = world.getPlayers();
            for (Player p : players) {
                p.sendMessage(MessageUtil.sectionSymbol("&cThe world you were in is regenerating"));
                p.teleport(p.getBedSpawnLocation() != null ? p.getBedSpawnLocation() : WorldRegen.plugin.getServer().getWorld(WorldRegen.levelname).getSpawnLocation());
            }
        }
    }

    private static void unloadWorld(org.bukkit.World world) {
        if (world != null) {
            String worldName = world.getName();
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)WorldRegen.plugin, () -> {
                boolean success = Bukkit.unloadWorld((String)worldName, (boolean)false);
                WorldRegen.logger.info(String.format("World '%s' %s", worldName, success ? "unloaded successfully" : "did not unload"));
            }, 40L);
        }
    }

    private static void removeWorldFolder(org.bukkit.World world) {
        if (world != null) {
            File folder = world.getWorldFolder();
            try {
                if (folder.exists()) {
                    FileUtils.cleanDirectory(folder);
                    if (folder.delete()) {
                        WorldRegen.logger.info(String.format("Deleted '%s' world folder", world.getName()));
                    } else {
                        WorldRegen.logger.warning("Couldn't delete world folder");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void createWorld(String worldName, WorldCreator worldCreator) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)WorldRegen.plugin, () -> {
            Bukkit.unloadWorld((String)worldName, (boolean)false);
            WorldCreator creator = new WorldCreator(worldName);
            World.Environment environment = worldCreator.environment();
            creator.environment(environment);
            WorldType type = worldCreator.type();
            creator.type(type);
            boolean generateStructures = worldCreator.generateStructures();
            if (environment == World.Environment.THE_END) {
                creator.generateStructures(true);
            } else {
                creator.generateStructures(generateStructures);
            }
            long seed = worldCreator.seed();
            if (Config.worldregen_random.booleanValue()) {
                creator.seed(seed + System.currentTimeMillis());
            } else {
                creator.seed(seed);
            }
            String generatorSettings = worldCreator.generatorSettings();
            if (generator != null) {
                creator.generator(generator);
                creator.generatorSettings(generatorSettings);
            }
            org.bukkit.World world = null;
            try {
                world = Bukkit.createWorld((WorldCreator)creator);
                WorldRegen.nms.rebuildDimension(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (world != null) {
                world.setAutoSave(autoSave);
                for (int i = -16; i < 16; ++i) {
                    for (int j = -16; j < 16; ++j) {
                        world.loadChunk(i, j);
                    }
                }
                WorldRegen.logger.info(String.format("Regenerated '%s' world", world.getName()));
            }
        }, 5L);
    }
}

