/*
 * Decompiled with CFR 0.152.
 */
package com.spawnchunk.worldregen.config;

import com.spawnchunk.worldregen.WorldRegen;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;

public class Config {
    private static FileConfiguration fc;
    private static final int config_version = 1;
    public static boolean debug;
    public static Boolean worldregen_random;
    public static List<String> worldregen_worlds;

    public Config() {
        fc = WorldRegen.plugin.getConfig();
        this.parseConfig();
    }

    private void parseConfig() {
        int version;
        int n = version = fc.contains("configVersion") ? fc.getInt("configVersion") : 0;
        if (version < 1) {
            this.upgradeConfig();
        }
        if (fc.contains("debug")) {
            debug = fc.getBoolean("debug");
        }
        if (fc.contains("random")) {
            worldregen_random = fc.getBoolean("random");
        }
        if (fc.contains("worlds")) {
            worldregen_worlds = fc.getStringList("worlds");
        }
    }

    private void upgradeConfig() {
        WorldRegen.logger.log(Level.WARNING, "Upgrading config file to the latest version");
        fc.options().copyDefaults(true);
        fc.set("configVersion", (Object)1);
        WorldRegen.plugin.saveConfig();
    }

    public void reloadConfig() {
        if (debug) {
            WorldRegen.logger.info("Reloading configuration");
        }
        WorldRegen.plugin.reloadConfig();
        fc = WorldRegen.plugin.getConfig();
        this.parseConfig();
    }

    static {
        debug = false;
        worldregen_random = false;
        worldregen_worlds = new ArrayList<String>();
    }
}

