/*
 * Decompiled with CFR 0.152.
 */
package com.spawnchunk.worldregen.commands;

import com.spawnchunk.worldregen.WorldRegen;
import com.spawnchunk.worldregen.config.Config;
import com.spawnchunk.worldregen.modules.World;
import com.spawnchunk.worldregen.util.MessageUtil;
import org.bukkit.Server;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldregenCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Server server = WorldRegen.plugin.getServer();
        if (sender instanceof Player || sender instanceof BlockCommandSender) {
            sender.sendMessage(MessageUtil.sectionSymbol("worldregen may only be run from the console"));
            return true;
        }
        if (args.length != 1) {
            return false;
        }
        String worldName = args[0].trim();
        if (worldName.equalsIgnoreCase("reload")) {
            WorldRegen.config.reloadConfig();
            sender.sendMessage("WorldRegen reloaded");
            return true;
        }
        if (server.getWorld(worldName) != null) {
            if (WorldRegen.levelname.equalsIgnoreCase(worldName)) {
                sender.sendMessage(String.format("Can not regenerate the main world [%s]", worldName));
                return true;
            }
            if (Config.worldregen_worlds.contains(worldName)) {
                sender.sendMessage(String.format("Regenerating '%s' world", worldName));
                World.regenWorld(worldName);
            } else {
                sender.sendMessage(String.format("Warning! Tried to regenerate world that is not whitelisted [%s]", worldName));
            }
        } else {
            sender.sendMessage(String.format("World '%s' is not loaded", worldName));
        }
        return true;
    }
}

