/*
 * Decompiled with CFR 0.152.
 */
package com.spawnchunk.worldregen;

import com.spawnchunk.worldregen.commands.WorldregenCommand;
import com.spawnchunk.worldregen.config.Config;
import com.spawnchunk.worldregen.listeners.WorldListener;
import com.spawnchunk.worldregen.nms.NMS;
import com.spawnchunk.worldregen.nms.v1_13_R2;
import com.spawnchunk.worldregen.nms.v1_14_R1;
import com.spawnchunk.worldregen.nms.v1_15_R1;
import com.spawnchunk.worldregen.util.FileUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class WorldRegen
extends JavaPlugin
implements Listener {
    public static WorldRegen plugin;
    public static NMS nms;
    public static Config config;
    public static Logger logger;
    public static String version;
    public static String levelname;

    public static void main(String[] args) {
    }

    public void onEnable() {
        plugin = this;
        logger = plugin.getLogger();
        File f = new File("server.properties");
        levelname = FileUtil.getProperty(f, "level-name");
        String packageName = plugin.getServer().getClass().getPackage().getName();
        version = packageName.substring(packageName.lastIndexOf(46) + 1);
        logger.info(String.format("Using NMS version %s", version));
        switch (version) {
            case "v1_13_R2": {
                nms = new v1_13_R2();
                break;
            }
            case "v1_14_R1": {
                nms = new v1_14_R1();
                break;
            }
            case "v1_15_R1": {
                nms = new v1_15_R1();
                break;
            }
            default: {
                logger.log(Level.SEVERE, "Error! This plugin only supports Spigot versions 1.13.2+!");
                logger.log(Level.SEVERE, "Plugin will be disabled!");
                this.getServer().getPluginManager().disablePlugin((Plugin)plugin);
                return;
            }
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            logger.log(Level.SEVERE, "Error! Required Vault plugin was not found!");
            logger.log(Level.SEVERE, "Plugin will be disabled!");
            this.getServer().getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        config = new Config();
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)plugin);
        plugin.getCommand("worldregen").setExecutor((CommandExecutor)new WorldregenCommand());
        plugin.getCommand("wr").setExecutor((CommandExecutor)new WorldregenCommand());
    }
}

