/*
 * Decompiled with CFR 0.152.
 */
package com.bear53.donatorjoin;

import com.bear53.donatorjoin.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Core
extends JavaPlugin
implements Listener {
    private UpdateChecker updater = null;

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getConfig().options().header("### DonatorJoin by Bear53! ###\n### This is the message if an DONATOR joins (Permission: donator.join) ###\n### Place Holders for Sound ###\n### Use this link to find all sound Place Holders ###\n### http://dev.bukkit.org/bukkit-plugins/justsound/pages/sound-list/ ###");
        this.getConfig().options().copyHeader(true);
        this.getConfig().addDefault("donormessage", (Object)"&8&l[&c&lYour Server Prefix Here&8&l] &7(&aDonator&7) &a%player% &7has joined the game!");
        this.getConfig().addDefault("staffmessage", (Object)"&8&l[&c&lYour Server Prefix Here&8&l] &7(&aStaff&7) &a%player% &7has joined the game!");
        this.getConfig().addDefault("opjoinmessage", (Object)"&8&l[&c&lYour Server Prefix Here&8&l] &7(&aOperator&7) &a%player% &7has joined the game!");
        this.getConfig().addDefault("opjoin", (Object)true);
        this.getConfig().addDefault("lightningstrike", (Object)true);
        this.getConfig().addDefault("enablesound", (Object)true);
        this.getConfig().addDefault("sound", (Object)"PORTAL_TRAVEL".toUpperCase());
        this.getConfig().addDefault("check_updates", (Object)true);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        if (this.checkUpdates()) {
            this.updater = new UpdateChecker(this);
            this.updater.checkUpdates();
            if (UpdateChecker.updateAvailable()) {
                System.out.println("----------------------------");
                System.out.println("     DonatorJoin Updater");
                System.out.println(" ");
                System.out.println("An update for DonatorJoin has been found!");
                System.out.println("DonatorJoin " + UpdateChecker.getHighest());
                System.out.println("You are running " + this.getDescription().getVersion());
                System.out.println(" ");
                System.out.println("Download at https://www.spigotmc.org/resources/donatorjoin-full-re-code.5075/");
                System.out.println("----------------------------");
            } else {
                System.out.println("----------------------------");
                System.out.println("     DonatorJoin Updater");
                System.out.println(" ");
                System.out.println("You are running " + this.getDescription().getVersion());
                System.out.println("The latest version");
                System.out.println("of DonatorJoin!");
                System.out.println(" ");
                System.out.println("----------------------------");
            }
        }
    }

    private void firework(Player p) {
        Firework fw = (Firework)p.getWorld().spawnEntity(p.getLocation(), EntityType.FIREWORK);
        FireworkMeta fwmeta = fw.getFireworkMeta();
        FireworkEffect.Builder builder = FireworkEffect.builder();
        builder.withTrail().withFlicker().withFade(Color.GREEN).withColor(Color.WHITE).withColor(Color.YELLOW).withColor(Color.BLUE).withColor(Color.FUCHSIA).withColor(Color.PURPLE).withColor(Color.MAROON).withColor(Color.LIME).withColor(Color.ORANGE).with(FireworkEffect.Type.BALL_LARGE);
        fwmeta.addEffect(builder.build());
        fwmeta.setPower(1);
        fw.setFireworkMeta(fwmeta);
    }

    @EventHandler
    public void onStaffJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.hasPermission("staff.join")) {
            Location location = p.getLocation();
            String staffMessage = this.getConfig().getString("staffmessage").replaceAll("&", "\u00a7").replace("%player%", p.getName());
            e.setJoinMessage(null);
            Bukkit.getServer().broadcastMessage(staffMessage);
            this.firework(p);
            if (!this.getConfig().getBoolean("lightningstrike")) {
                return;
            }
            p.getWorld().strikeLightning(p.getLocation());
            if (this.getConfig().getBoolean("enablesound")) {
                location.getWorld().playSound(location, Sound.valueOf((String)this.getConfig().getString("sound").toUpperCase()), 20.0f, -20.0f);
            } else {
                location.getWorld().playSound(location, Sound.PORTAL_TRAVEL, 20.0f, -20.0f);
            }
        } else if (p.hasPermission("donator.join")) {
            Location location = p.getLocation();
            String joinMessage = this.getConfig().getString("donormessage").replaceAll("&", "\u00a7").replace("%player%", p.getName());
            e.setJoinMessage(null);
            Bukkit.getServer().broadcastMessage(joinMessage);
            this.firework(p);
            if (!this.getConfig().getBoolean("lightningstrike")) {
                return;
            }
            p.getWorld().strikeLightning(p.getLocation());
            if (this.getConfig().getBoolean("enablesound")) {
                location.getWorld().playSound(location, Sound.valueOf((String)this.getConfig().getString("sound").toUpperCase()), 20.0f, -20.0f);
            } else {
                location.getWorld().playSound(location, Sound.PORTAL_TRAVEL, 20.0f, -20.0f);
            }
        } else if (p.isOp()) {
            Location location = p.getLocation();
            if (this.getConfig().getBoolean("opjoin")) {
                String opJoinMessage = this.getConfig().getString("opjoinmessage").replaceAll("&", "\u00a7").replace("%player%", p.getName());
                e.setJoinMessage(null);
                Bukkit.getServer().broadcastMessage(opJoinMessage);
                this.firework(p);
                if (!this.getConfig().getBoolean("lightningstrike")) {
                    return;
                }
                p.getWorld().strikeLightning(p.getLocation());
                if (this.getConfig().getBoolean("enablesound")) {
                    location.getWorld().playSound(location, Sound.valueOf((String)this.getConfig().getString("sound").toUpperCase()), 20.0f, -20.0f);
                } else {
                    location.getWorld().playSound(location, Sound.PORTAL_TRAVEL, 20.0f, -20.0f);
                }
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.LIGHTNING)) {
            event.setCancelled(true);
        }
    }

    public boolean checkUpdates() {
        return this.getConfig().getBoolean("check_updates");
    }
}

