/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util.particle;

import com.floodeer.bowspleef.util.particle.ParticleDisplay_12;
import com.floodeer.bowspleef.util.particle.ParticleDisplay_13;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class ParticleDisplay {
    public abstract void display(Particle var1, Location var2, float var3, float var4, float var5, float var6, int var7, float var8, Color var9, Material var10, byte var11, double var12, List<Player> var14);

    protected void display(Particle particle, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount, Object data, double range, List<Player> targetPlayers) {
        try {
            if (targetPlayers == null) {
                String worldName = center.getWorld().getName();
                double squared = range * range;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getWorld().getName().equals(worldName) || player.getLocation().distanceSquared(center) > squared) continue;
                    player.spawnParticle(particle, center, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, data);
                }
            } else {
                for (Player player : targetPlayers) {
                    player.spawnParticle(particle, center, amount, (double)offsetX, (double)offsetY, (double)offsetZ, (double)speed, data);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void displayItem(Particle particle, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount, Material material, byte materialData, double range, List<Player> targetPlayers) {
        if (material == null || material == Material.AIR) {
            return;
        }
        ItemStack item = new ItemStack(material);
        item.setDurability((short)materialData);
        this.display(particle, center, offsetX, offsetY, offsetZ, speed, amount, item, range, targetPlayers);
    }

    protected void displayLegacyColored(Particle particle, Location center, float speed, Color color, double range, List<Player> targetPlayers) {
        int amount = 0;
        if (speed == 0.0f) {
            speed = 1.0f;
        }
        float offsetX = (float)color.getRed() / 255.0f;
        float offsetY = (float)color.getGreen() / 255.0f;
        float offsetZ = (float)color.getBlue() / 255.0f;
        if (offsetX < Float.MIN_NORMAL) {
            offsetX = Float.MIN_NORMAL;
        }
        this.display(particle, center, offsetX, offsetY, offsetZ, speed, amount, null, range, targetPlayers);
    }

    public static ParticleDisplay newInstance() {
        ParticleDisplay display = null;
        try {
            Particle.valueOf((String)"SQUID_INK");
            display = new ParticleDisplay_13();
        }
        catch (Throwable not13) {
            display = new ParticleDisplay_12();
        }
        return display;
    }
}

