/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.BowSpleef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;

public class WorldUtils {
    public static void loadWorldTask(String name, LoadCallback callback) {
        BowSpleef.get().getServer().getScheduler().runTask((Plugin)BowSpleef.get(), () -> {
            WorldCreator worldCreator = new WorldCreator(name);
            worldCreator.generateStructures(false);
            World world = Bukkit.getServer().createWorld(worldCreator);
            world.setKeepSpawnInMemory(false);
            world.setAutoSave(false);
            callback.onLoad();
        });
    }

    public static World createEmptyWorld(String name) {
        WorldCreator worldCreator = new WorldCreator(name);
        worldCreator.environment(World.Environment.NORMAL);
        worldCreator.generateStructures(false);
        worldCreator.generator(new ChunkGenerator(){

            public List<BlockPopulator> getDefaultPopulators(World world) {
                return Arrays.asList(new BlockPopulator[0]);
            }

            public boolean canSpawn(World world, int x, int z) {
                return true;
            }

            public byte[] generate(World world, Random random, int x, int z) {
                return new byte[32768];
            }

            public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biome) {
                return this.createChunkData(world);
            }

            public Location getFixedSpawnLocation(World world, Random random) {
                return new Location(world, 0.0, 64.0, 0.0);
            }
        });
        World world = worldCreator.createWorld();
        world.setDifficulty(Difficulty.PEACEFUL);
        world.setSpawnFlags(false, false);
        world.setPVP(false);
        world.setStorm(false);
        world.setThundering(false);
        world.setWeatherDuration(Integer.MAX_VALUE);
        world.setAutoSave(false);
        world.setKeepSpawnInMemory(false);
        world.setTicksPerAnimalSpawns(1);
        world.setTicksPerMonsterSpawns(1);
        world.setTime(1000L);
        world.setGameRuleValue("doMobSpawning", "false");
        world.setGameRuleValue("mobGriefing", "false");
        world.setGameRuleValue("doDaylightCycle", "false");
        world.setGameRuleValue("doFireTick", "false");
        world.setGameRuleValue("showDeathMessages", "false");
        Block b = world.getBlockAt(0, 1, 0);
        b.setType(Material.GLASS);
        return world;
    }

    public static boolean loadWorld(String worldName) {
        WorldCreator worldCreator = new WorldCreator(worldName);
        worldCreator.generateStructures(false);
        worldCreator.generator(new ChunkGenerator(){

            public List<BlockPopulator> getDefaultPopulators(World world) {
                return Arrays.asList(new BlockPopulator[0]);
            }

            public boolean canSpawn(World world, int x, int z) {
                return true;
            }

            public byte[] generate(World world, Random random, int x, int z) {
                return new byte[32768];
            }

            public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biome) {
                return this.createChunkData(world);
            }

            public Location getFixedSpawnLocation(World world, Random random) {
                return new Location(world, 0.0, 64.0, 0.0);
            }
        });
        World world = worldCreator.createWorld();
        world.setDifficulty(Difficulty.PEACEFUL);
        world.setSpawnFlags(false, false);
        world.setPVP(false);
        world.setStorm(false);
        world.setThundering(false);
        world.setPVP(true);
        world.setWeatherDuration(Integer.MAX_VALUE);
        world.setAutoSave(false);
        world.setKeepSpawnInMemory(false);
        world.setTicksPerAnimalSpawns(1);
        world.setTicksPerMonsterSpawns(1);
        world.setTime(1000L);
        world.setGameRuleValue("doMobSpawning", "false");
        world.setGameRuleValue("mobGriefing", "false");
        world.setGameRuleValue("doFireTick", "false");
        world.setGameRuleValue("showDeathMessages", "false");
        world.setGameRuleValue("doDaylightCycle", "false");
        boolean loaded = false;
        for (World w : BowSpleef.get().getServer().getWorlds()) {
            if (!w.getName().equals(world.getName())) continue;
            loaded = true;
            break;
        }
        return loaded;
    }

    public static void unloadWorld(String w) {
        World world = BowSpleef.get().getServer().getWorld(w);
        if (world != null) {
            BowSpleef.get().getServer().unloadWorld(world, true);
        }
    }

    public static void copyWorld(File source, File target) {
        try {
            ArrayList<String> ignore = new ArrayList<String>(Arrays.asList("uid.dat", "session.dat", "session.lock"));
            if (!ignore.contains(source.getName())) {
                if (source.isDirectory()) {
                    String[] files;
                    if (!target.exists() && target.mkdirs() && (files = source.list()) != null) {
                        for (String file : files) {
                            File srcFile = new File(source, file);
                            File destFile = new File(target, file);
                            WorldUtils.copyWorld(srcFile, destFile);
                        }
                    }
                } else {
                    int length;
                    FileInputStream in = new FileInputStream(source);
                    FileOutputStream out = new FileOutputStream(target);
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)in).read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, length);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
            }
        }
        catch (IOException e) {
            BowSpleef.get().getLogger().info("Failed to copy world!");
        }
    }

    public static boolean deleteWorld(String name) {
        WorldUtils.unloadWorld(name);
        File target = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath(), name);
        return WorldUtils.deleteWorld(target);
    }

    public static boolean deleteWorld(File path) {
        File[] files;
        if (path.exists() && (files = path.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    WorldUtils.deleteWorld(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    public static void deleteWorldGuard(String name) {
        File f = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath());
        f = new File(f, "/plugins");
        for (File file : f.listFiles()) {
            if (file.getName().equalsIgnoreCase("WorldGuard")) continue;
            return;
        }
        if ((f = new File(f, "/plugins/WorldGuard/worlds/")) != null) {
            File[] c;
            for (File file : c = f.listFiles()) {
                if (!file.isDirectory() || !file.getName().matches(name)) continue;
                WorldUtils.deleteWorld(file);
            }
        }
    }

    public static interface LoadCallback {
        public void onLoad();
    }
}

