/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.util.LocationUtils;
import com.floodeer.bowspleef.util.MathUtils;
import com.floodeer.bowspleef.util.ParticleEffect;
import com.floodeer.bowspleef.util.ReflectionUtils;
import com.floodeer.bowspleef.util.XSound;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Util {
    private static final Pattern HEX_PATTERN = Pattern.compile("&(#\\w{6})");

    public static Player find(String name) {
        return Bukkit.getOnlinePlayers().stream().filter(player -> player.getName().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    public static List<String> replaceAll(List<String> list, String oldChar, String newChar) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String str : list) {
            strings.add(str.replace(oldChar, newChar));
        }
        return strings;
    }

    public static String setPlaceholders(Player player, String text) {
        if (player == null) {
            return text;
        }
        if (BowSpleef.get().getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    public static void sendToSpawn(Player ps) {
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)new JSONParser().parse(BowSpleef.get().getOptions().spawn);
        }
        catch (ParseException e) {
            ps.sendMessage(Util.colorString("&c&lNo spawn found! Set global spawn using &6/bowspleef setgspawn&c&l.", new Player[0]));
        }
        if (!BowSpleef.get().getOptions().isBungeeCord) {
            try {
                ps.teleport(LocationUtils.getLocation(jsonObject, true));
            }
            catch (Exception ex) {
                ps.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
            }
        } else {
            Util.connect(ps, BowSpleef.get().getOptions().bungeeLobby);
        }
    }

    public static void connect(Player player, String server) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        player.sendPluginMessage((Plugin)BowSpleef.get(), "BungeeCord", stream.toByteArray());
    }

    public static <T> Stream<T> supply(Stream<T> stream, Supplier<T> supplier) {
        Iterator iterator = stream.iterator();
        if (iterator.hasNext()) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        return Stream.of(supplier.get());
    }

    public static String createSpacer() {
        String build = "";
        for (int i = 0; i < 15; ++i) {
            build = Util.add(build);
        }
        return build;
    }

    private static String add(String build) {
        int r = MathUtils.random.nextInt(7) + 1;
        build = build + org.bukkit.ChatColor.values()[r];
        return build;
    }

    public static String colorize(String message) {
        Matcher matcher = HEX_PATTERN.matcher(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, ChatColor.of((String)matcher.group(1)).toString());
        }
        return matcher.appendTail(buffer).toString();
    }

    public static String colorString(String message, Player ... player) {
        if (player != null && player.length > 0) {
            message = Util.setPlaceholders(player[0], message);
        }
        if (BowSpleef.getServerVersion().hasHexSupport()) {
            return Util.colorize(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static List<String> colorList(List<String> list) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String str : list) {
            strings.add(Util.colorString(str, new Player[0]));
        }
        return strings;
    }

    public static void toggleCollisions(Player player, boolean collideWithEntities) {
        if (Package.getPackage("org.spigotmc") != null) {
            player.spigot().setCollidesWithEntities(collideWithEntities);
        }
    }

    public static String getDirection(Float f) {
        f = Float.valueOf(f.floatValue() / 90.0f);
        if ((f = Float.valueOf(Math.round(f.floatValue()))).floatValue() == -4.0f || f.floatValue() == 0.0f || f.floatValue() == 4.0f) {
            return "SOUTH";
        }
        if (f.floatValue() == -1.0f || f.floatValue() == 3.0f) {
            return "EAST";
        }
        if (f.floatValue() == -2.0f || f.floatValue() == 2.0f) {
            return "NORTH";
        }
        if (f.floatValue() == -3.0f || f.floatValue() == 1.0f) {
            return "WEST";
        }
        return "";
    }

    public static void sendTitle(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String title, String subtitle) {
        if (BowSpleef.getServerVersion() == BowSpleef.ServerVersion.VERSION_17 || BowSpleef.getServerVersion() == BowSpleef.ServerVersion.VERSION_118 || BowSpleef.getServerVersion() == BowSpleef.ServerVersion.VERSION_19) {
            player.sendTitle(Util.colorString(title, player), Util.colorString(subtitle, player), fadeIn.intValue(), stay.intValue(), fadeOut.intValue());
        } else {
            try {
                Constructor<?> subtitleConstructor;
                Object e;
                if (title != null) {
                    title = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)title);
                    title = title.replaceAll("%player%", player.getDisplayName());
                    e = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("TIMES").get(null);
                    Object chatTitle = ReflectionUtils.getMinecraftClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + title + "\"}");
                    subtitleConstructor = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getConstructor(ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0], ReflectionUtils.getMinecraftClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    Object titlePacket = subtitleConstructor.newInstance(e, chatTitle, fadeIn, stay, fadeOut);
                    Util.sendPacket(player, titlePacket);
                    e = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("TITLE").get(null);
                    chatTitle = ReflectionUtils.getMinecraftClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + title + "\"}");
                    subtitleConstructor = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getConstructor(ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0], ReflectionUtils.getMinecraftClass("IChatBaseComponent"));
                    titlePacket = subtitleConstructor.newInstance(e, chatTitle);
                    Util.sendPacket(player, titlePacket);
                }
                if (subtitle != null) {
                    subtitle = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
                    subtitle = subtitle.replaceAll("%player%", player.getDisplayName());
                    e = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("TIMES").get(null);
                    Object chatSubtitle = ReflectionUtils.getMinecraftClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + title + "\"}");
                    subtitleConstructor = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getConstructor(ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0], ReflectionUtils.getMinecraftClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    Object subtitlePacket = subtitleConstructor.newInstance(e, chatSubtitle, fadeIn, stay, fadeOut);
                    Util.sendPacket(player, subtitlePacket);
                    e = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0].getField("SUBTITLE").get(null);
                    chatSubtitle = ReflectionUtils.getMinecraftClass("IChatBaseComponent").getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + subtitle + "\"}");
                    subtitleConstructor = ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getConstructor(ReflectionUtils.getMinecraftClass("PacketPlayOutTitle").getDeclaredClasses()[0], ReflectionUtils.getMinecraftClass("IChatBaseComponent"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    subtitlePacket = subtitleConstructor.newInstance(e, chatSubtitle, fadeIn, stay, fadeOut);
                    Util.sendPacket(player, subtitlePacket);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void sendPacket(Player player, Object packet) {
        try {
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object playerConnection = handle.getClass().getField("playerConnection").get(handle);
            playerConnection.getClass().getMethod("sendPacket", ReflectionUtils.getMinecraftClass("Packet")).invoke(playerConnection, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearTitle(Player player) {
        Util.sendTitle(player, 0, 0, 0, "", "");
    }

    public static void sendFormatted(Player p, String title, String sub) {
        Util.sendTitle(p, BowSpleef.get().getOptions().fadeIn, BowSpleef.get().getOptions().stay, BowSpleef.get().getOptions().fadeOut, title, sub);
    }

    public static boolean isWallSign(Block block) {
        if (block.getType().toString().contains("SIGN")) {
            return true;
        }
        return block.getState() instanceof Sign;
    }

    public static boolean isValidParticle(String name) {
        if (BowSpleef.nmsver.startsWith("v1_8")) {
            ArrayList particles = Lists.newArrayList(Arrays.asList(ParticleEffect.values()));
            for (ParticleEffect particle : particles) {
                if (!particle.toString().equalsIgnoreCase(name)) continue;
                return true;
            }
        } else {
            ArrayList particles = Lists.newArrayList(Arrays.asList(Particle.values()));
            for (Particle particle : particles) {
                if (!particle.toString().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Particle matchesParticle(String name) {
        ArrayList particles = Lists.newArrayList(Arrays.asList(Particle.values()));
        LinkedList matchList = Lists.newLinkedList();
        for (Particle particle : particles) {
            if (particle.toString().equalsIgnoreCase(name)) {
                return particle;
            }
            if (!particle.toString().toLowerCase().contains(name.toLowerCase())) continue;
            matchList.add(particle);
        }
        return (Particle)matchList.get(0);
    }

    public static ParticleEffect matchesParticleEffect(String name) {
        ArrayList particles = Lists.newArrayList(Arrays.asList(ParticleEffect.values()));
        LinkedList matchList = Lists.newLinkedList();
        for (ParticleEffect particle : particles) {
            if (particle.toString().equalsIgnoreCase(name)) {
                return particle;
            }
            if (!particle.toString().toLowerCase().contains(name.toLowerCase())) continue;
            matchList.add(particle);
        }
        return (ParticleEffect)((Object)matchList.get(0));
    }

    public static void displayParticles(Player player, String name, float offsetX, float offsetY, float offsetZ, float speed, int amount, Location center, int range) {
        if (BowSpleef.nmsver.startsWith("v1_8")) {
            if (player == null) {
                Util.matchesParticleEffect(name).display(offsetX, offsetY, offsetZ, speed, amount, center, range);
            } else {
                Util.matchesParticleEffect(name).display(offsetX, offsetY, offsetZ, speed, amount, center, player);
            }
        } else if (player == null) {
            BowSpleef.get().getParticleManager().display(Util.matchesParticle(name), center, offsetX, offsetY, offsetZ, speed, amount, range);
        } else {
            BowSpleef.get().getParticleManager().display(Util.matchesParticle(name), center, offsetX, offsetY, offsetZ, speed, amount, player);
        }
    }

    public static void setDamage(ItemStack stack, int damage) {
        try {
            Method m = Class.forName("org.bukkit.inventory.meta.Damageable").getMethod("setDamage", Integer.TYPE);
            m.invoke((Object)stack, (short)damage);
        }
        catch (Exception localException) {
            stack.setDurability((short)damage);
        }
    }

    public static void playSound(Game game, String configSection) {
        String sound = Util.getBefore(configSection, ":");
        String i = Util.getAfter(configSection, ":");
        game.getPlayers().forEach(gp -> gp.getPlayer().playSound(gp.getPlayer().getLocation(), XSound.matchXSound(sound).orElse(XSound.UI_BUTTON_CLICK).parseSound(), 1.0f, Float.parseFloat(i)));
    }

    public static void playSound(Location start, float volume, String configSection) {
        String sound = Util.getBefore(configSection, ":");
        String i = Util.getAfter(configSection, ":");
        start.getWorld().playSound(start, XSound.matchXSound(sound).orElse(XSound.UI_BUTTON_CLICK).parseSound(), volume, Float.parseFloat(i));
    }

    public static void playSound(GamePlayer gp, String configSection) {
        String sound = Util.getBefore(configSection, ":");
        String i = Util.getAfter(configSection, ":");
        gp.getPlayer().playSound(gp.getPlayer().getLocation(), XSound.matchXSound(sound).orElse(XSound.UI_BUTTON_CLICK).parseSound(), 1.0f, Float.parseFloat(i));
    }

    public static String getAfter(String str, String separator) {
        if (str.isEmpty()) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String getBefore(String str, String separator) {
        if (str.isEmpty() || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }
}

