/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.util.MathUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimeUtils {
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DAY = "yyyy-MM-dd";

    public static String now() {
        Calendar localCalendar = Calendar.getInstance();
        SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
        return localSimpleDateFormat.format(localCalendar.getTime());
    }

    public static String time() {
        Calendar localCalendar = Calendar.getInstance();
        SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        return localSimpleDateFormat.format(localCalendar.getTime());
    }

    public static String when(long paramLong) {
        SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat(DATE_FORMAT_NOW);
        return localSimpleDateFormat.format(paramLong);
    }

    public static String date() {
        Calendar localCalendar = Calendar.getInstance();
        SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat(DATE_FORMAT_DAY);
        return localSimpleDateFormat.format(localCalendar.getTime());
    }

    public static String since(long paramLong) {
        return "Took " + TimeUtils.convertString(System.currentTimeMillis() - paramLong, 1, TimeUnit.FIT) + ".";
    }

    public static double convert(long paramLong, int paramInt, TimeUnit paramTimeUnit) {
        if (paramTimeUnit == TimeUnit.FIT) {
            paramTimeUnit = paramLong < 60000L ? TimeUnit.SECONDS : (paramLong < 3600000L ? TimeUnit.MINUTES : (paramLong < 86400000L ? TimeUnit.HOURS : TimeUnit.DAYS));
        }
        if (paramTimeUnit == TimeUnit.DAYS) {
            return MathUtils.trim(paramInt, (double)paramLong / 8.64E7);
        }
        if (paramTimeUnit == TimeUnit.HOURS) {
            return MathUtils.trim(paramInt, (double)paramLong / 3600000.0);
        }
        if (paramTimeUnit == TimeUnit.MINUTES) {
            return MathUtils.trim(paramInt, (double)paramLong / 60000.0);
        }
        if (paramTimeUnit == TimeUnit.SECONDS) {
            return MathUtils.trim(paramInt, (double)paramLong / 1000.0);
        }
        return MathUtils.trim(paramInt, paramLong);
    }

    public static String MakeStr(long paramLong) {
        return TimeUtils.convertString(paramLong, 1, TimeUnit.FIT);
    }

    public static String MakeStr(long paramLong, int paramInt) {
        return TimeUtils.convertString(paramLong, paramInt, TimeUnit.FIT);
    }

    public static String convertString(long paramLong, int paramInt, TimeUnit paramTimeUnit) {
        if (paramLong == -1L) {
            return "Permanent";
        }
        if (paramTimeUnit == TimeUnit.FIT) {
            paramTimeUnit = paramLong < 60000L ? TimeUnit.SECONDS : (paramLong < 3600000L ? TimeUnit.MINUTES : (paramLong < 86400000L ? TimeUnit.HOURS : TimeUnit.DAYS));
        }
        if (paramTimeUnit == TimeUnit.DAYS) {
            return MathUtils.trim(paramInt, (double)paramLong / 8.64E7) + " Days";
        }
        if (paramTimeUnit == TimeUnit.HOURS) {
            return MathUtils.trim(paramInt, (double)paramLong / 3600000.0) + " Hours";
        }
        if (paramTimeUnit == TimeUnit.MINUTES) {
            return MathUtils.trim(paramInt, (double)paramLong / 60000.0) + " Minutes";
        }
        if (paramTimeUnit == TimeUnit.SECONDS) {
            return MathUtils.trim(paramInt, (double)paramLong / 1000.0) + " Seconds";
        }
        return MathUtils.trim(paramInt, paramLong) + " Milliseconds";
    }

    public static boolean elapsed(long paramLong1, long paramLong2) {
        return System.currentTimeMillis() - paramLong1 > paramLong2;
    }

    public static enum TimeUnit {
        FIT,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        MILLISECONDS;

    }
}

