/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Runner {
    private int delay = 1;
    private int period = 1;
    private JavaPlugin main;
    private Runnable run;
    private Boolean cancelable;
    private int cycles = 1;
    private int cycled = 0;

    public Runner(JavaPlugin main, int delay, int period, int cycles) {
        this.main = main;
        this.delay = delay;
        this.period = period;
        this.cycled = cycles;
    }

    public Runner(JavaPlugin main) {
        this.main = main;
    }

    public static Runner make(JavaPlugin main) {
        return new Runner(main);
    }

    public Runner delay(int ticks) {
        if (ticks < 1) {
            ticks = 1;
        }
        this.delay = ticks;
        return this;
    }

    public Runner interval(int ticks) {
        if (ticks < 1) {
            ticks = 1;
        }
        this.period = ticks;
        return this;
    }

    public Runner limit(int cycles) {
        this.cycles = cycles;
        return this;
    }

    public Runner unlim() {
        this.cycles = 0;
        return this;
    }

    public BukkitTask run(Runnable run) {
        this.run = run;
        if (this.cycles < 1) {
            return this.buildUnlimTimer();
        }
        if (this.cycles > 1) {
            return this.buildLimitedTimer();
        }
        return this.buildDelayedTask();
    }

    public BukkitTask cancelable(Boolean run) {
        this.cancelable = run;
        if (this.cycles < 1) {
            return this.buildUnlimCancelableTimer();
        }
        if (this.cycles > 1) {
            return this.buildLimCancelableTimer();
        }
        return this.buildDelayedCancelableTask();
    }

    private BukkitTask buildLimitedTimer() {
        return new BukkitRunnable(){

            public void run() {
                if (Runner.this.cycles <= Runner.this.cycled) {
                    this.cancel();
                    return;
                }
                Runner.this.cycled++;
                Runner.this.run.run();
            }
        }.runTaskTimer((Plugin)this.main, (long)this.delay, (long)this.period);
    }

    private BukkitTask buildUnlimTimer() {
        return new BukkitRunnable(){

            public void run() {
                Runner.this.run.run();
            }
        }.runTaskTimer((Plugin)this.main, (long)this.delay, (long)this.period);
    }

    private BukkitTask buildDelayedTask() {
        return new BukkitRunnable(){

            public void run() {
                Runner.this.run.run();
            }
        }.runTaskLater((Plugin)this.main, (long)this.delay);
    }

    private BukkitTask buildLimCancelableTimer() {
        return new BukkitRunnable(){

            public void run() {
                if (Runner.this.cycles <= Runner.this.cycled) {
                    this.cancel();
                    return;
                }
                Runner.this.cycled++;
                if (!Runner.this.cancelable.booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.main, (long)this.delay, (long)this.period);
    }

    private BukkitTask buildUnlimCancelableTimer() {
        return new BukkitRunnable(){

            public void run() {
                if (!Runner.this.cancelable.booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.main, (long)this.delay, (long)this.period);
    }

    private BukkitTask buildDelayedCancelableTask() {
        return new BukkitRunnable(){

            public void run() {
                if (!Runner.this.cancelable.booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskLater((Plugin)this.main, (long)this.delay);
    }
}

