/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collector;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MathUtils {
    public static final float nanoToSec = 1.0E-9f;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    public static final float SQRT_3 = 1.7320508f;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float radDeg = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float degRad = (float)Math.PI / 180;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;
    private static final int ATAN2_BITS = 7;
    private static final int ATAN2_BITS2 = 14;
    private static final int ATAN2_MASK = 16383;
    private static final int ATAN2_COUNT = 16384;
    static final int ATAN2_DIM = (int)Math.sqrt(16384.0);
    private static final float INV_ATAN2_DIM_MINUS_1 = 1.0f / (float)(ATAN2_DIM - 1);
    public static Random random = new Random();

    public static int floor(double d1) {
        int i = (int)d1;
        return d1 >= (double)i ? i : i - 1;
    }

    public static int d(float f1) {
        int i = (int)f1;
        return f1 >= (float)i ? i : i - 1;
    }

    public static byte toPackedByte(float f) {
        return (byte)(f * 256.0f / 360.0f);
    }

    public static final byte rotationToByte(float f) {
        return (byte)(f * 256.0f / 360.0f);
    }

    public static double trim(int degree, double d) {
        String format = "#.#";
        for (int i = 1; i < degree; ++i) {
            format = format + "#";
        }
        DecimalFormatSymbols symb = new DecimalFormatSymbols(Locale.US);
        DecimalFormat twoDForm = new DecimalFormat(format, symb);
        return Double.valueOf(twoDForm.format(d));
    }

    public static double randomRange(double paramDouble1, double paramDouble2) {
        return Math.random() < 0.5 ? (1.0 - Math.random()) * (paramDouble2 - paramDouble1) + paramDouble1 : Math.random() * (paramDouble2 - paramDouble1) + paramDouble1;
    }

    public static <T> Collector<T, List<T>, T> streamRandom() {
        Random RANDOM = new Random();
        return Collector.of(() -> new ArrayList(), (acc, elem) -> acc.add(elem), (list1, list2) -> MathUtils.union(list1, list2), list -> list.isEmpty() ? null : list.get(RANDOM.nextInt(list.size())), new Collector.Characteristics[0]);
    }

    public static <T> T random(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(MathUtils.r(list.size()));
    }

    public static <E> List<E> union(List<? extends E> list1, List<? extends E> list2) {
        ArrayList<? extends E> result = new ArrayList<E>(list1);
        result.addAll(list2);
        return result;
    }

    public static int r(int paramInt) {
        return random.nextInt(paramInt);
    }

    public static double offset2d(Entity paramEntity1, Entity paramEntity2) {
        return MathUtils.offset2d(paramEntity1.getLocation().toVector(), paramEntity2.getLocation().toVector());
    }

    public static double offset2d(Location paramLocation1, Location paramLocation2) {
        return MathUtils.offset2d(paramLocation1.toVector(), paramLocation2.toVector());
    }

    public static double offset2d(Vector paramVector1, Vector paramVector2) {
        paramVector1.setY(0);
        paramVector2.setY(0);
        return paramVector1.subtract(paramVector2).length();
    }

    public static final float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static final float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static final float sinDeg(float degrees) {
        return Sin.table[(int)(degrees * 45.511112f) & 0x3FFF];
    }

    public static final float cosDeg(float degrees) {
        return Sin.table[(int)((degrees + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static boolean isInteger(Object object) {
        try {
            Integer.parseInt(object.toString());
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean isBoolean(Object object) {
        try {
            Boolean.parseBoolean(object.toString());
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean isDouble(Object object) {
        try {
            Double.parseDouble(object.toString());
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean isFloat(Object object) {
        try {
            Float.parseFloat(object.toString());
            return true;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static final float atan2(float y, float x) {
        float add;
        float mul;
        if (x < 0.0f) {
            if (y < 0.0f) {
                y = -y;
                mul = 1.0f;
            } else {
                mul = -1.0f;
            }
            x = -x;
            add = (float)(-Math.PI);
        } else {
            if (y < 0.0f) {
                y = -y;
                mul = -1.0f;
            } else {
                mul = 1.0f;
            }
            add = 0.0f;
        }
        float invDiv = 1.0f / ((x < y ? y : x) * INV_ATAN2_DIM_MINUS_1);
        if (invDiv == Float.POSITIVE_INFINITY) {
            return ((float)Math.atan2(y, x) + add) * mul;
        }
        int xi = (int)(x * invDiv);
        int yi = (int)(y * invDiv);
        return (Atan2.table[yi * ATAN2_DIM + xi] + add) * mul;
    }

    public static final int random(int range) {
        return random.nextInt(range + 1);
    }

    public static final int random(int start, int end) {
        return start + random.nextInt(end - start + 1);
    }

    public static final boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static final boolean randomBoolean(float chance) {
        return (float)MathUtils.random(100) < chance;
    }

    public static final float random() {
        return random.nextFloat();
    }

    public static final float random(float range) {
        return random.nextFloat() * range;
    }

    public static final float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static short clamp(short value, short min, short max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int floor(float x) {
        return (int)((double)x + 16384.0) - 16384;
    }

    public static int floorPositive(float x) {
        return (int)x;
    }

    public static int ceil(float x) {
        return (int)((double)x + 16384.999999999996) - 16384;
    }

    public static int ceilPositive(float x) {
        return (int)((double)x + 0.9999999);
    }

    public static int round(float x) {
        return (int)((double)x + 16384.5) - 16384;
    }

    public static int roundPositive(float x) {
        return (int)(x + 0.5f);
    }

    public static boolean isZero(float value) {
        return Math.abs(value) <= 1.0E-6f;
    }

    public static boolean isZero(float value, float tolerance) {
        return Math.abs(value) <= tolerance;
    }

    public static boolean isEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    public boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    public static Location locMerge(Location a, Location b) {
        a.setX(b.getX());
        a.setY(b.getY());
        a.setZ(b.getZ());
        return a;
    }

    public static final Vector rotateAroundAxisX(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.getY() * cos - v.getZ() * sin;
        double z = v.getY() * sin + v.getZ() * cos;
        return v.setY(y).setZ(z);
    }

    public static final Vector rotateAroundAxisY(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos + v.getZ() * sin;
        double z = v.getX() * -sin + v.getZ() * cos;
        return v.setX(x).setZ(z);
    }

    public static final Vector rotateAroundAxisZ(Vector v, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.getX() * cos - v.getY() * sin;
        double y = v.getX() * sin + v.getY() * cos;
        return v.setX(x).setY(y);
    }

    public static final Vector rotateVector(Vector v, double angleX, double angleY, double angleZ) {
        MathUtils.rotateAroundAxisX(v, angleX);
        MathUtils.rotateAroundAxisY(v, angleY);
        MathUtils.rotateAroundAxisZ(v, angleZ);
        return v;
    }

    public static final double angleToXAxis(Vector vector) {
        return Math.atan2(vector.getX(), vector.getY());
    }

    public static Vector getRandomVector() {
        double x = random.nextDouble() * 2.0 - 1.0;
        double y = random.nextDouble() * 2.0 - 1.0;
        double z = random.nextDouble() * 2.0 - 1.0;
        return new Vector(x, y, z).normalize();
    }

    public static Vector getRandomCircleVector() {
        double rnd = random.nextDouble() * 2.0 * Math.PI;
        double x = Math.cos(rnd);
        double z = Math.sin(rnd);
        return new Vector(x, 0.0, z);
    }

    public static Material material(Material[] materials) {
        return materials[random.nextInt(materials.length)];
    }

    public static <T> T getRandomT(T[] t) {
        return t[random.nextInt(t.length)];
    }

    public static double getRandomAngle() {
        return random.nextDouble() * 2.0 * Math.PI;
    }

    public static double randomDouble(double min, double max) {
        return Math.random() < 0.5 ? (1.0 - Math.random()) * (max - min) + min : Math.random() * (max - min) + min;
    }

    public static float randomRangeFloat(float min, float max) {
        return (float)(Math.random() < 0.5 ? (1.0 - Math.random()) * (double)(max - min) + (double)min : Math.random() * (double)(max - min) + (double)min);
    }

    public static byte randomByte(int max) {
        return (byte)random.nextInt(max + 1);
    }

    public static int randomRangeInt(int min, int max) {
        return (int)(Math.random() < 0.5 ? (1.0 - Math.random()) * (double)(max - min) + (double)min : Math.random() * (double)(max - min) + (double)min);
    }

    public static double offset(Entity a, Entity b) {
        return MathUtils.offset(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset(Location a, Location b) {
        return MathUtils.offset(a.toVector(), b.toVector());
    }

    public static double offset(Vector a, Vector b) {
        return a.subtract(b).length();
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public static float getLookAtYaw(Vector v) {
        double x = v.getX();
        double z = v.getZ();
        double r = 0.0;
        if (x != 0.0) {
            r = x < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            r -= Math.atan(z / x);
        } else if (z < 0.0) {
            r = Math.PI;
        }
        return (float)(-r * 180.0 / Math.PI - 90.0);
    }

    public static double arrondi(double paramDouble, int paramInt) {
        return (double)((int)(paramDouble * Math.pow(10.0, paramInt) + 0.5)) / Math.pow(10.0, paramInt);
    }

    public static Range<Double, Double> getLargestArcRange(Double[] angles) {
        Set<Set<Double>> combinations = MathUtils.getCombinationsFor(Arrays.asList(angles), 2);
        Range<Double, Double> largestRange = null;
        Double largest = null;
        for (Set<Double> combo : combinations) {
            Double[] array = combo.toArray(new Double[2]);
            double arc = MathUtils.distance(array[0], array[1]);
            if (largest != null && !(arc > largest)) continue;
            largest = arc;
            largestRange = new Range<Double, Double>(array[0], array[1]);
        }
        if (largestRange != null && (Double)largestRange.getLowest() > (Double)largestRange.getHighest()) {
            largestRange = new Range<Double, Double>((Double)largestRange.getHighest(), (Double)largestRange.getLowest());
        }
        return largestRange;
    }

    public static <T> Set<Set<T>> getCombinationsFor(List<T> group, int k) {
        HashSet<Set<T>> allCombos = new HashSet<Set<T>>();
        if (k == 0) {
            allCombos.add(new HashSet());
            return allCombos;
        }
        if (k > group.size()) {
            return allCombos;
        }
        ArrayList<T> groupWithoutX = new ArrayList<T>(group);
        Object x = groupWithoutX.remove(groupWithoutX.size() - 1);
        Set<Set<T>> combosWithoutX = MathUtils.getCombinationsFor(groupWithoutX, k);
        Set<Set<T>> combosWithX = MathUtils.getCombinationsFor(groupWithoutX, k - 1);
        for (Set<T> combo : combosWithX) {
            combo.add(x);
        }
        allCombos.addAll(combosWithoutX);
        allCombos.addAll(combosWithX);
        return allCombos;
    }

    private static double distance(double r1, double r2) {
        double d = Math.abs(r2 - r1);
        if (d <= Math.PI) {
            return d;
        }
        return Math.PI * 2 - d;
    }

    public static double toPolar(double x, double y) {
        double theta = Math.atan2(y, x);
        if (theta < 0.0) {
            return Math.PI * 2 + theta;
        }
        return theta;
    }

    public static boolean inside(double theta, double small, double large) {
        if (large - small > Math.PI) {
            return theta > large || theta < small;
        }
        return theta < large && theta > small;
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int i;
            table = new float[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            }
        }
    }

    private static class Atan2 {
        static final float[] table = new float[16384];

        private Atan2() {
        }

        static {
            for (int i = 0; i < ATAN2_DIM; ++i) {
                for (int j = 0; j < ATAN2_DIM; ++j) {
                    float x0 = (float)i / (float)ATAN2_DIM;
                    float y0 = (float)j / (float)ATAN2_DIM;
                    Atan2.table[j * MathUtils.ATAN2_DIM + i] = (float)Math.atan2(y0, x0);
                }
            }
        }
    }

    public static class Range<L extends Number, H extends Number> {
        L lowest;
        H highest;

        Range(L lowest, H highest) {
            this.lowest = lowest;
            this.highest = highest;
        }

        public L getLowest() {
            return this.lowest;
        }

        public H getHighest() {
            return this.highest;
        }

        public void setKey(L lowest) {
            this.lowest = lowest;
        }

        public void setValue(H highest) {
            this.highest = highest;
        }
    }
}

