/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;

public class LocationUtils {
    public static Location getFixedLocation(Location var0, BlockFace var1) {
        for (int var2 = 0; var2 < 250 && var0.getBlock().isEmpty(); ++var2) {
            var0.add(0.0, var1 == BlockFace.UP ? 1.0 : -1.0, 0.0);
        }
        return var0.add(0.0, var1 == BlockFace.UP ? -1.0 : 1.0, 0.0);
    }

    public static ArrayList<Location> getCircleAt(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < amount; ++i) {
            double angle = (double)i * increment;
            double x = center.getX() + radius * Math.cos(angle);
            double z = center.getZ() + radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
        }
        return locations;
    }

    public static ArrayList<Location> getCircleReverse(Location center, double radius, int amount) {
        World world = center.getWorld();
        double increment = Math.PI * 2 / (double)amount;
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int i = 0; i < amount; ++i) {
            double angle = (double)i * increment;
            double x = center.getX() - radius * Math.cos(angle);
            double z = center.getZ() - radius * Math.sin(angle);
            locations.add(new Location(world, x, center.getY(), z));
        }
        return locations;
    }

    public static Location get(Location paramLocation, double paramDouble1, double paramDouble2, double paramDouble3) {
        return new Location(paramLocation.getWorld(), paramLocation.getX() + paramDouble1, paramLocation.getY() + paramDouble2, paramLocation.getZ() + paramDouble3);
    }

    public static List<Block> getCube(Location paramLocation, int paramInt) {
        ArrayList<Block> localArrayList = new ArrayList<Block>();
        int i = paramLocation.getBlockX() - paramInt / 2;
        int j = paramLocation.getBlockY() - paramInt / 2;
        int k = paramLocation.getBlockZ() - paramInt / 2;
        for (int m = i; m < i + paramInt; ++m) {
            for (int n = j; n < j + paramInt; ++n) {
                for (int i1 = k; i1 < k + paramInt; ++i1) {
                    localArrayList.add(paramLocation.getWorld().getBlockAt(m, n, i1));
                }
            }
        }
        return localArrayList;
    }

    public static Entity[] getNearbyEntities(Location l, int radius) {
        int chunkRadius = radius < 16 ? 1 : (radius - radius % 16) / 16;
        HashSet<Entity> radiusEntities = new HashSet<Entity>();
        for (int chX = 0 - chunkRadius; chX <= chunkRadius; ++chX) {
            for (int chZ = 0 - chunkRadius; chZ <= chunkRadius; ++chZ) {
                int x = (int)l.getX();
                int y = (int)l.getY();
                int z = (int)l.getZ();
                for (Entity e : new Location(l.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                    if (!(e.getLocation().distance(l) <= (double)radius) || e.getLocation().getBlock() == l.getBlock()) continue;
                    radiusEntities.add(e);
                }
            }
        }
        return radiusEntities.toArray(new Entity[radiusEntities.size()]);
    }

    public static Location getLocation(Location paramLocation, double paramDouble1, double paramDouble2, double paramDouble3) {
        return new Location(paramLocation.getWorld(), paramLocation.getX() + paramDouble1, paramLocation.getY() + paramDouble2, paramLocation.getZ() + paramDouble3);
    }

    public static List<Location> getCircleBlocks(Location paramLocation, int paramInt) {
        ArrayList<Location> localArrayList = new ArrayList<Location>();
        int i = paramLocation.getBlockX() - paramInt / 2;
        int j = paramLocation.getBlockY() - paramInt / 2;
        int k = paramLocation.getBlockZ() - paramInt / 2;
        for (int m = i; m < i + paramInt; ++m) {
            for (int n = j; n < j + paramInt; ++n) {
                for (int i1 = k; i1 < k + paramInt; ++i1) {
                    localArrayList.add(paramLocation.getWorld().getBlockAt(m, n, i1).getLocation());
                }
            }
        }
        return localArrayList;
    }

    public static Map<LivingEntity, Double> getLivingInRadius(Location loc, double dR) {
        HashMap<LivingEntity, Double> ents = new HashMap<LivingEntity, Double>();
        for (Entity cur : loc.getWorld().getEntities()) {
            LivingEntity ent;
            double offset;
            if (!(cur instanceof LivingEntity) || !((offset = MathUtils.offset(loc, (ent = (LivingEntity)cur).getLocation())) < dR)) continue;
            ents.put(ent, 1.0 - offset / dR);
        }
        return ents;
    }

    public static List<Player> getNearbyPlayers(Location paramLocation, double paramDouble) {
        ArrayList<Player> localArrayList = new ArrayList<Player>();
        for (Player localPlayer : Bukkit.getOnlinePlayers()) {
            if (localPlayer.getWorld() != paramLocation.getWorld() || !(localPlayer.getLocation().distance(paramLocation) <= paramDouble)) continue;
            localArrayList.add(localPlayer);
        }
        return localArrayList;
    }

    public static List<LivingEntity> getNearbyLivingEntities(Location paramLocation, double paramDouble) {
        ArrayList<LivingEntity> localArrayList = new ArrayList<LivingEntity>();
        for (LivingEntity entities : paramLocation.getWorld().getLivingEntities()) {
            if (entities.getWorld() != paramLocation.getWorld() || !(entities.getLocation().distance(paramLocation) <= paramDouble)) continue;
            localArrayList.add(entities);
        }
        return localArrayList;
    }

    public static List<Location> getCircle(Location paramLocation, double paramDouble, int paramInt) {
        ArrayList<Location> localArrayList = new ArrayList<Location>();
        double d1 = Math.PI * 2 / (double)paramInt;
        for (int i = 0; i < paramInt; ++i) {
            double d2 = (double)i * d1;
            double d3 = paramLocation.getX() + paramDouble * Math.cos(d2);
            double d4 = paramLocation.getZ() + paramDouble * Math.sin(d2);
            localArrayList.add(new Location(paramLocation.getWorld(), d3, paramLocation.getY(), d4));
        }
        return localArrayList;
    }

    public static List<Location> getSphere(Location loc, int r, int h, boolean hollow, boolean sphere, int plus_y) {
        ArrayList<Location> circleblocks = new ArrayList<Location>();
        int cx = loc.getBlockX();
        int cy = loc.getBlockY();
        int cz = loc.getBlockZ();
        for (int x = cx - r; x <= cx + r; ++x) {
            for (int z = cz - r; z <= cz + r; ++z) {
                for (int y = sphere ? cy - r : cy; y < (sphere ? cy + r : cy + h); ++y) {
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (sphere ? (cy - y) * (cy - y) : 0);
                    if (!(dist < (double)(r * r)) || hollow && !(dist >= (double)((r - 1) * (r - 1)))) continue;
                    Location l = new Location(loc.getWorld(), (double)x, (double)(y + plus_y), (double)z);
                    circleblocks.add(l);
                }
            }
        }
        return circleblocks;
    }

    public static Location getTargetBlock(Player paramPlayer, int paramInt) {
        Location localLocation = paramPlayer.getEyeLocation();
        Vector localVector = localLocation.getDirection().normalize();
        Block localBlock = null;
        for (int i = 0; i <= paramInt; ++i) {
            localLocation.add(localVector);
            localBlock = localLocation.getBlock();
            if (localBlock.getType() == Material.AIR) continue;
            return localLocation;
        }
        return localLocation;
    }

    public static Player getTarget(Player player, int distanceX, int distanceY, int distanceZ, int finalDistance) {
        List n = player.getNearbyEntities((double)distanceX, (double)distanceY, (double)distanceZ);
        ArrayList<Player> nearPlayers = new ArrayList<Player>();
        for (Entity e : n) {
            if (!(e instanceof Player)) continue;
            nearPlayers.add((Player)e);
        }
        Player target = null;
        BlockIterator bItr = new BlockIterator((LivingEntity)player, finalDistance);
        block1: while (bItr.hasNext()) {
            Block block = bItr.next();
            int bx = block.getX();
            int by = block.getY();
            int bz = block.getZ();
            for (Player e : nearPlayers) {
                Location loc = e.getLocation();
                double ex = loc.getX();
                double ey = loc.getY();
                double ez = loc.getZ();
                if (!((double)bx - 0.75 <= ex) || !(ex <= (double)bx + 1.75) || !((double)bz - 0.75 <= ez) || !(ez <= (double)bz + 1.75) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                target = e;
                continue block1;
            }
        }
        if (target != null && target.getGameMode() == GameMode.SPECTATOR) {
            target = null;
        }
        return target;
    }

    public static LivingEntity getTarget(Player player) {
        List<LivingEntity> n = LocationUtils.getNearbyLivingEntities(player.getLocation(), 12.0);
        ArrayList<LivingEntity> nearPlayers = new ArrayList<LivingEntity>();
        for (Entity entity : n) {
            if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
            nearPlayers.add((LivingEntity)entity);
        }
        LivingEntity target = null;
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, 30);
        block1: while (blockIterator.hasNext()) {
            Block block = blockIterator.next();
            int bx = block.getX();
            int by = block.getY();
            int bz = block.getZ();
            for (LivingEntity e : nearPlayers) {
                Location loc = e.getLocation();
                double ex = loc.getX();
                double ey = loc.getY();
                double ez = loc.getZ();
                if (!((double)bx - 0.75 <= ex) || !(ex <= (double)bx + 1.75) || !((double)bz - 0.75 <= ez) || !(ez <= (double)bz + 1.75) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                target = e;
                continue block1;
            }
        }
        return target;
    }

    public static Player getPlayerTarget(Player player) {
        List<Player> n = LocationUtils.getNearbyPlayers(player.getLocation(), 12.0);
        ArrayList<Player> nearPlayers = new ArrayList<Player>();
        for (Entity entity : n) {
            if (entity instanceof Player) continue;
            nearPlayers.add((Player)entity);
        }
        Player target = null;
        BlockIterator blockIterator = new BlockIterator((LivingEntity)player, 30);
        block1: while (blockIterator.hasNext()) {
            Block block = blockIterator.next();
            int bx = block.getX();
            int by = block.getY();
            int bz = block.getZ();
            for (Player e : nearPlayers) {
                Location loc = e.getLocation();
                double ex = loc.getX();
                double ey = loc.getY();
                double ez = loc.getZ();
                if (!((double)bx - 0.75 <= ex) || !(ex <= (double)bx + 1.75) || !((double)bz - 0.75 <= ez) || !(ez <= (double)bz + 1.75) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                target = e;
                continue block1;
            }
        }
        return target;
    }

    public static List<Block> getBlocksInRadius(Location location, int radius, boolean hollow) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int bX = location.getBlockX();
        int bY = location.getBlockY();
        int bZ = location.getBlockZ();
        for (int x = bX - radius; x <= bX + radius; ++x) {
            for (int y = bY - radius; y <= bY + radius; ++y) {
                for (int z = bZ - radius; z <= bZ + radius; ++z) {
                    double distance = (bX - x) * (bX - x) + (bY - y) * (bY - y) + (bZ - z) * (bZ - z);
                    if (!(distance < (double)(radius * radius)) || hollow && !(distance >= (double)((radius - 1) * (radius - 1)))) continue;
                    Location l = new Location(location.getWorld(), (double)x, (double)y, (double)z);
                    blocks.add(l.getBlock());
                }
            }
        }
        return blocks;
    }

    public static HashMap<Block, Double> getInRadius(Location loc, double dR) {
        return LocationUtils.getInRadius(loc, dR, 9999.0);
    }

    public static HashMap<Block, Double> getInRadius(Location loc, double dR, double maxHeight) {
        HashMap<Block, Double> blockList = new HashMap<Block, Double>();
        int iR = (int)dR + 1;
        for (int x = -iR; x <= iR; ++x) {
            for (int z = -iR; z <= iR; ++z) {
                for (int y = -iR; y <= iR; ++y) {
                    Block curBlock;
                    double offset;
                    if ((double)Math.abs(y) > maxHeight || !((offset = MathUtils.offset(loc, (curBlock = loc.getWorld().getBlockAt((int)(loc.getX() + (double)x), (int)(loc.getY() + (double)y), (int)(loc.getZ() + (double)z))).getLocation().add(0.5, 0.5, 0.5))) <= dR)) continue;
                    blockList.put(curBlock, 1.0 - offset / dR);
                }
            }
        }
        return blockList;
    }

    public static List<Block> getNearbyBlocks(Location location, int radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int x = location.getBlockX() - radius; x <= location.getBlockX() + radius; ++x) {
            for (int y = location.getBlockY() - radius; y <= location.getBlockY() + radius; ++y) {
                for (int z = location.getBlockZ() - radius; z <= location.getBlockZ() + radius; ++z) {
                    blocks.add(location.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static Location getGround(Location l) {
        Location locBelow = l.clone().subtract(0.0, 1.0, 0.0);
        while (locBelow.getBlock().getType() == Material.AIR) {
            locBelow.subtract(0.0, 1.0, 0.0);
        }
        return locBelow;
    }

    public static boolean checkEmptyArea(Location corner1, Location corner2) {
        if (corner1.getWorld() != corner2.getWorld()) {
            return false;
        }
        World world = corner1.getWorld();
        for (int x = corner1.getBlockX(); x <= corner2.getBlockX(); ++x) {
            for (int y = corner1.getBlockY(); y <= corner2.getBlockY(); ++y) {
                for (int z = corner1.getBlockZ(); z <= corner2.getBlockZ(); ++z) {
                    Location location = new Location(world, (double)x, (double)y, (double)z);
                    Block block = location.getBlock();
                    if (block.getType() != Material.AIR) {
                        return false;
                    }
                    for (Entity entity : LocationUtils.getNearbyEntities(location, 2)) {
                        if (!(entity instanceof ItemFrame) && !(entity instanceof Painting)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static boolean isInArea(Player p, Location l, double distance) {
        return p.getLocation().distance(l) <= distance;
    }

    public static String saveLocation(Location location, boolean yawPitch) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"world", (Object)location.getWorld().getName());
        jsonObject.put((Object)"x", (Object)location.getX());
        jsonObject.put((Object)"y", (Object)location.getY());
        jsonObject.put((Object)"z", (Object)location.getZ());
        if (yawPitch) {
            jsonObject.put((Object)"yaw", (Object)Float.valueOf(location.getYaw()));
            jsonObject.put((Object)"pitch", (Object)Float.valueOf(location.getPitch()));
        }
        return jsonObject.toJSONString();
    }

    public static Location getLocation(JSONObject fromJson, boolean yawpitch) {
        double x = (Double)fromJson.get((Object)"x");
        double y = (Double)fromJson.get((Object)"y");
        double z = (Double)fromJson.get((Object)"z");
        String world = (String)fromJson.get((Object)"world");
        if (yawpitch) {
            double pitch = (Double)fromJson.get((Object)"pitch");
            double yaw = (Double)fromJson.get((Object)"yaw");
            return new Location(Bukkit.getWorld((String)world), Math.floor(x), Math.floor(y), Math.floor(z), (float)yaw, (float)pitch);
        }
        return new Location(Bukkit.getWorld((String)world), Math.floor(x), Math.floor(y), Math.floor(z));
    }

    public static Location getLocationExact(JSONObject fromJson, boolean yawpitch) {
        double x = (Double)fromJson.get((Object)"x");
        double y = (Double)fromJson.get((Object)"y");
        double z = (Double)fromJson.get((Object)"z");
        String world = (String)fromJson.get((Object)"world");
        if (yawpitch) {
            double pitch = (Double)fromJson.get((Object)"pitch");
            double yaw = (Double)fromJson.get((Object)"yaw");
            return new Location(Bukkit.getWorld((String)world), x, y, z, (float)yaw, (float)pitch);
        }
        return new Location(Bukkit.getWorld((String)world), x, y, z);
    }

    public static ArrayList<Location> getLinesDistancedPoints(Location startingPoint, Location endingPoint, double distanceBetweenParticles) {
        return LocationUtils.getLinesLimitedPoints(startingPoint, endingPoint, (int)Math.ceil(startingPoint.distance(endingPoint) / distanceBetweenParticles));
    }

    public static ArrayList<Location> getLinesLimitedPoints(Location startingPoint, Location endingPoint, int amountOfPoints) {
        startingPoint = startingPoint.clone();
        Vector vector = endingPoint.toVector().subtract(startingPoint.toVector());
        vector.normalize();
        vector.multiply(startingPoint.distance(endingPoint) / ((double)amountOfPoints + 1.0));
        ArrayList<Location> locs = new ArrayList<Location>();
        for (int i = 0; i < amountOfPoints; ++i) {
            locs.add(startingPoint.add(vector).clone());
        }
        return locs;
    }
}

