/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.util.NBTEditor;
import com.floodeer.bowspleef.util.Util;
import com.floodeer.bowspleef.util.XMaterial;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemFactory {
    private static final Set<Material> axeSet = Sets.newHashSet();
    private static final Set<Material> swordSet = Sets.newHashSet();
    private static final Set<Material> shovelSet = Sets.newHashSet();
    public static HashSet<Material> scytheSet = new HashSet();

    public static boolean isAxe(ItemStack paramItemStack) {
        if (paramItemStack == null) {
            return false;
        }
        if (axeSet.isEmpty()) {
            axeSet.add(XMaterial.WOODEN_AXE.parseMaterial());
            axeSet.add(XMaterial.STONE_AXE.parseMaterial());
            axeSet.add(XMaterial.IRON_AXE.parseMaterial());
            axeSet.add(XMaterial.GOLDEN_AXE.parseMaterial());
            axeSet.add(XMaterial.DIAMOND_AXE.parseMaterial());
        }
        return axeSet.contains(paramItemStack.getType());
    }

    public static boolean isSword(ItemStack paramItemStack) {
        if (paramItemStack == null) {
            return false;
        }
        if (swordSet.isEmpty()) {
            swordSet.add(XMaterial.WOODEN_SWORD.parseMaterial());
            swordSet.add(XMaterial.STONE_SWORD.parseMaterial());
            swordSet.add(XMaterial.IRON_SWORD.parseMaterial());
            swordSet.add(XMaterial.GOLDEN_SWORD.parseMaterial());
            swordSet.add(XMaterial.DIAMOND_SWORD.parseMaterial());
        }
        return swordSet.contains(paramItemStack.getType());
    }

    public static boolean isShovel(ItemStack paramItemStack) {
        if (paramItemStack == null) {
            return false;
        }
        if (shovelSet.isEmpty()) {
            shovelSet.add(XMaterial.WOODEN_SHOVEL.parseMaterial());
            shovelSet.add(XMaterial.STONE_SHOVEL.parseMaterial());
            shovelSet.add(XMaterial.IRON_SHOVEL.parseMaterial());
            shovelSet.add(XMaterial.GOLDEN_SHOVEL.parseMaterial());
            shovelSet.add(XMaterial.DIAMOND_SHOVEL.parseMaterial());
        }
        return shovelSet.contains(paramItemStack.getType());
    }

    public static boolean isHoe(ItemStack paramItemStack) {
        if (paramItemStack == null) {
            return false;
        }
        if (scytheSet.isEmpty()) {
            scytheSet.add(XMaterial.WOODEN_HOE.parseMaterial());
            scytheSet.add(XMaterial.STONE_HOE.parseMaterial());
            scytheSet.add(XMaterial.IRON_HOE.parseMaterial());
            scytheSet.add(XMaterial.GOLDEN_HOE.parseMaterial());
            scytheSet.add(XMaterial.DIAMOND_HOE.parseMaterial());
        }
        return scytheSet.contains(paramItemStack.getType());
    }

    public static ItemStack create(Material material, String name, List<String> lore, int amount, byte data) {
        ItemStack item = new ItemStack(material, amount, 0, Byte.valueOf(data));
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name, int amount, byte data) {
        ItemStack item = new ItemStack(material, amount, 0, Byte.valueOf(data));
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name, List<String> lore, int amount) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name, int amount) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name, List<String> lore, byte data) {
        ItemStack item = XMaterial.matchXMaterial(new ItemStack(material, 1, 0, Byte.valueOf(data))).parseItem();
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name, byte data) {
        ItemStack item = new ItemStack(material, 1, 0, Byte.valueOf(data));
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack create(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createParsing(String material, String name, List<String> lore) {
        String[] parts = material.split(" : ");
        ItemStack item = ItemFactory.create(parts[0].contains(":") ? XMaterial.matchXMaterial(parts[0].split(":")[0]).get().parseMaterial() : XMaterial.matchXMaterial(parts[0]).get().parseMaterial());
        item.setAmount(Integer.parseInt(parts[1]));
        ItemMeta meta = item.getItemMeta();
        meta.setLore(lore);
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createArmor(Material stack, Color color) {
        ItemStack item = ItemFactory.create(stack);
        return ItemFactory.color(item, color);
    }

    public static ItemStack create(Material type) {
        return new ItemStack(type);
    }

    public static ItemStack unbreakable(ItemStack stack) {
        if (stack != null && stack.getType() != Material.AIR) {
            ItemMeta meta = stack.getItemMeta();
            if (BowSpleef.getServerVersion() == BowSpleef.ServerVersion.VERSION_18) {
                return ItemFactory.setUnbreakable(stack);
            }
            if (meta != null) {
                meta.setUnbreakable(true);
            }
            stack.setItemMeta(meta);
        }
        return stack;
    }

    public static ItemStack setUnbreakable(ItemStack item) {
        return NBTEditor.set(item, (byte)1, "Unbreakable");
    }

    public static ItemStack createBowSpleefBow() {
        ItemStack item = ItemFactory.setUnbreakable(ItemFactory.create(Material.BOW, Util.colorize(BowSpleef.get().getLanguage().bow)));
        ItemFactory.enchant(item, 10, Enchantment.ARROW_INFINITE, true);
        ItemFactory.enchant(item, 10, Enchantment.ARROW_FIRE, true);
        return item;
    }

    public static ItemStack create(Material type, int count) {
        return new ItemStack(type, count);
    }

    public static ItemStack create(Material type, int count, byte id) {
        return new ItemStack(type, count, 0, Byte.valueOf(id));
    }

    public static ItemStack create(Material type, int count, short durability) {
        return new ItemStack(type, count, durability);
    }

    public static ItemStack parse(String config) {
        ItemStack stack = null;
        ArrayList lore = Lists.newArrayList();
        try {
            String[] parts = config.split(" : ");
            String name = parts[0].split(":")[0];
            int amount = Integer.parseInt(parts[1]);
            boolean weapon = false;
            if (name.isEmpty()) {
                return ItemFactory.create(Material.AIR);
            }
            XMaterial material = XMaterial.matchXMaterial(name).orElse(XMaterial.AIR);
            stack = ItemFactory.create(material.parseMaterial());
            stack.setAmount(amount);
            if (parts[0].contains(":")) {
                if ((name.equalsIgnoreCase("POTION") || name.equalsIgnoreCase("SPLASH_POTION") || name.equalsIgnoreCase("LINGERING_POTION")) && parts[0].split(":").length == 4) {
                    ItemFactory.setPotionEffect(stack, PotionType.valueOf((String)parts[0].split(":")[1]), Boolean.parseBoolean(parts[0].split(":")[2]), Boolean.parseBoolean(parts[0].split(":")[3]));
                } else {
                    Util.setDamage(stack, Integer.parseInt(parts[0].split(":")[1]));
                }
            }
            for (int i = 2; i < parts.length; ++i) {
                String in = parts[i].split(":")[0].toLowerCase();
                if (in.equals("name")) {
                    ItemFactory.name(stack, Util.colorString(parts[i].split(":")[1], new Player[0]), new String[0]);
                    continue;
                }
                if (in.equals("lore")) {
                    lore.add(Util.colorString(parts[i].split(":")[1], new Player[0]));
                    continue;
                }
                if (in.equals("enchant")) {
                    ItemFactory.enchant(stack, Integer.parseInt(parts[i].split(":")[2]), Enchantment.getByName((String)parts[i].split(":")[1].toUpperCase()), true);
                    continue;
                }
                if (in.equals("dye")) {
                    ItemFactory.color(stack, ItemFactory.getColor(parts[i].split(":")[1]));
                    continue;
                }
                if (!in.equalsIgnoreCase("HideItemInfo")) continue;
                ItemFactory.addItemFlag(stack, ItemFlag.HIDE_ATTRIBUTES);
                ItemFactory.addItemFlag(stack, ItemFlag.HIDE_UNBREAKABLE);
                ItemFactory.addItemFlag(stack, ItemFlag.HIDE_ENCHANTS);
                if (!BowSpleef.ServerVersion.isLegacy()) {
                    ItemFactory.addItemFlag(stack, ItemFlag.HIDE_DYE);
                }
                ItemFactory.addItemFlag(stack, ItemFlag.HIDE_POTION_EFFECTS);
            }
            ItemFactory.lore(stack, lore);
        }
        catch (NullPointerException ex) {
            stack = ItemFactory.create(Material.STONE);
            ItemFactory.name(stack, "Error", "Something is wrong.");
            return stack;
        }
        return stack;
    }

    public static void addItemFlag(ItemStack item, ItemFlag flag) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{flag});
        item.setItemMeta(meta);
    }

    public static PotionEffect parseEffect(List<String> effect) {
        if (effect.size() < 2) {
            return null;
        }
        PotionEffect potionEffect = null;
        try {
            PotionEffectType pType = ItemFactory.getPotionType(effect.get(0));
            int length = Integer.parseInt(effect.get(1)) == -1 ? Integer.MAX_VALUE : 20 * Integer.parseInt(effect.get(1));
            int level = Integer.parseInt(effect.get(2));
            potionEffect = new PotionEffect(pType, length, level);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return potionEffect;
    }

    private static PotionEffectType getPotionType(String type) {
        for (PotionEffectType types : PotionEffectType.values()) {
            if (!types.toString().equalsIgnoreCase(type)) continue;
            return types;
        }
        return null;
    }

    public static boolean isEnchanted(ItemStack itemStack) {
        return !itemStack.getEnchantments().isEmpty();
    }

    public static String getItemColor(Color paramColor) {
        String str = "BLACK";
        if (paramColor.equals((Object)Color.BLACK)) {
            return str;
        }
        if (paramColor.equals((Object)Color.AQUA)) {
            str = "AQUA";
        } else if (paramColor.equals((Object)Color.BLUE)) {
            str = "BLUE";
        } else if (paramColor.equals((Object)Color.FUCHSIA)) {
            str = "FUCHSIA";
        } else if (paramColor.equals((Object)Color.GRAY)) {
            str = "GRAY";
        } else if (paramColor.equals((Object)Color.GREEN)) {
            str = "GREEN";
        } else if (paramColor.equals((Object)Color.LIME)) {
            str = "LIME";
        } else if (paramColor.equals((Object)Color.MAROON)) {
            str = "MAROON";
        } else if (paramColor.equals((Object)Color.NAVY)) {
            str = "NAVY";
        } else if (paramColor.equals((Object)Color.OLIVE)) {
            str = "OLIVE";
        } else if (paramColor.equals((Object)Color.ORANGE)) {
            str = "ORANGE";
        } else if (paramColor.equals((Object)Color.PURPLE)) {
            str = "PURPLE";
        } else if (paramColor.equals((Object)Color.RED)) {
            str = "RED";
        } else if (paramColor.equals((Object)Color.SILVER)) {
            str = "SILVER";
        } else if (paramColor.equals((Object)Color.TEAL)) {
            str = "TEAL";
        } else if (paramColor.equals((Object)Color.WHITE)) {
            str = "WHITE";
        } else if (paramColor.equals((Object)Color.YELLOW)) {
            str = "YELLOW";
        }
        return str;
    }

    public static Color getColor(String c) {
        switch (c) {
            case "aqua": {
                return Color.AQUA;
            }
            case "black": {
                return Color.BLACK;
            }
            case "blue": {
                return Color.BLUE;
            }
            case "fuschia": {
                return Color.FUCHSIA;
            }
            case "gray": {
                return Color.GRAY;
            }
            case "green": {
                return Color.GREEN;
            }
            case "lime": {
                return Color.LIME;
            }
            case "maroon": {
                return Color.MAROON;
            }
            case "navy": {
                return Color.NAVY;
            }
            case "olvie": {
                return Color.OLIVE;
            }
            case "orange": {
                return Color.ORANGE;
            }
            case "purple": {
                return Color.PURPLE;
            }
            case "red": {
                return Color.RED;
            }
            case "silver": {
                return Color.SILVER;
            }
            case "teal": {
                return Color.TEAL;
            }
            case "white": {
                return Color.WHITE;
            }
            case "yellow": {
                return Color.YELLOW;
            }
        }
        return Color.NAVY;
    }

    public static List<String> applyLorePlaceholder(Game game, List<String> other, Player viewer) {
        ArrayList strings = Lists.newArrayList();
        for (String str : other) {
            str = str.replaceAll("%minplayers%", Integer.toString(game.getMinPlayers())).replaceAll("%name%", game.getName()).replaceAll("%state%", game.getState().toString()).replaceAll("%maxplayers%", Integer.toString(game.getMaxPlayers())).replaceAll("%players%", Integer.toString(game.getPlayers().size())).replaceAll("%players%", Integer.toString(game.getPlayers().size()));
            if (BowSpleef.get().getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                str = PlaceholderAPI.setPlaceholders((Player)viewer, (String)str);
            }
            strings.add(str);
        }
        return strings;
    }

    public static ItemStack name(ItemStack itemStack, String name, List<String> lore) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!name.isEmpty()) {
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        itemMeta.setLore(Util.colorList(lore));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack lore(ItemStack itemStack, List<String> lore) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(Util.colorList(lore));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack name(ItemStack itemStack, String name, String ... lores) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!name.isEmpty()) {
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        if (lores.length > 0) {
            ArrayList<String> loreList = new ArrayList<String>(lores.length);
            for (String lore : lores) {
                loreList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)lore));
            }
            itemMeta.setLore(loreList);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static void enchant(ItemStack item, int level, Enchantment enchant, boolean ignore) {
        ItemMeta meta = item.getItemMeta();
        meta.addEnchant(enchant, level, ignore);
        item.setItemMeta(meta);
    }

    public static ItemStack color(ItemStack stack, Color c) {
        if (!stack.getType().toString().startsWith("LEATHER")) {
            return null;
        }
        LeatherArmorMeta meta = (LeatherArmorMeta)stack.getItemMeta();
        meta.setColor(c);
        stack.setItemMeta((ItemMeta)meta);
        return stack;
    }

    public static byte separateData(String config) {
        String id = StringUtils.substringAfter((String)config, (String)":");
        if (id != "") {
            if (Integer.parseInt(id) == 0) {
                return 0;
            }
            return Byte.parseByte(id);
        }
        return 0;
    }

    public static ItemStack glow(ItemStack item) {
        if (BowSpleef.getServerVersion() == BowSpleef.ServerVersion.PRE_13) {
            item.addUnsafeEnchantment(Enchantment.LUCK, 1);
            ItemMeta meta = item.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        } else {
            ItemMeta meta = item.getItemMeta();
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
            item.addUnsafeEnchantment(Enchantment.LUCK, 1);
        }
        return item;
    }

    public static String separateName(String config) {
        String id = StringUtils.substringBefore((String)config, (String)":");
        return id;
    }

    public static boolean hasName(ItemStack is, String prefix) {
        try {
            if (!is.hasItemMeta()) {
                return false;
            }
            if (!is.getItemMeta().hasDisplayName()) {
                return false;
            }
            return is.getItemMeta().getDisplayName().equalsIgnoreCase(prefix);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isMat(ItemStack paramItemStack, Material paramMaterial) {
        if (paramItemStack == null) {
            return false;
        }
        return paramItemStack.getType() == paramMaterial;
    }

    public static ItemStack setPotionEffect(ItemStack stack, PotionType paramPotionType, boolean extended, boolean upgraded) {
        PotionMeta localPotionMeta = (PotionMeta)stack.getItemMeta();
        try {
            PotionMeta.class.getMethod("setBasePotionData", Class.forName("org.bukkit.potion.PotionData")).invoke((Object)localPotionMeta, Class.forName("org.bukkit.potion.PotionData").getConstructor(PotionType.class, Boolean.TYPE, Boolean.TYPE).newInstance(paramPotionType, extended, upgraded));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
        stack.setItemMeta((ItemMeta)localPotionMeta);
        return stack;
    }

    public static ItemStack createPotion(PotionType potionType, boolean splash, PotionEffectType effectType, String nome, int time, int level, int amount) {
        ItemStack stack = new Potion(potionType, 1, splash).toItemStack(amount);
        PotionMeta meta = (PotionMeta)stack.getItemMeta();
        meta.setDisplayName(nome);
        meta.addCustomEffect(new PotionEffect(effectType, time, level), true);
        stack.setItemMeta((ItemMeta)meta);
        return stack;
    }

    public static String potionToString(ItemStack item) {
        if (item.getItemMeta() instanceof PotionMeta) {
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            String type = "POTION";
            if (item.getType().toString().contains("SPLASH_POTION")) {
                type = "SPLASH_POTION";
            } else if (item.getType().toString().contains("LINGERING_POTION")) {
                type = "LINGERING_POTION";
            }
            return type + ":" + meta.getBasePotionData().getType() + ":" + meta.getBasePotionData().isExtended() + ":" + meta.getBasePotionData().isUpgraded() + " : " + item.getAmount();
        }
        return "";
    }
}

