/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.util.ItemFactory;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class IconMenu {
    private final String name;
    private final int size;
    private OptionClickEventHandler handler;
    private String[] optionNames;
    private ItemStack[] optionIcons;

    public IconMenu(String name, int size, OptionClickEventHandler handler) {
        this.name = name;
        this.size = size;
        this.handler = handler;
        this.optionNames = new String[size];
        this.optionIcons = new ItemStack[size];
    }

    public IconMenu setOption(int position, ItemStack icon, String name, String[] info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = ItemFactory.name(icon, name, info);
        return this;
    }

    public IconMenu setOption(int position, ItemStack icon, String name, List<String> info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = ItemFactory.name(icon, name, info);
        return this;
    }

    public void open(Player player) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        for (int iii = 0; iii < this.optionIcons.length; ++iii) {
            if (this.optionIcons[iii] == null) continue;
            inventory.setItem(iii, this.optionIcons[iii]);
        }
        player.openInventory(inventory);
    }

    public void update(Player player) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        if (this.getOptions() != null) {
            for (int iii = 0; iii < this.optionIcons.length; ++iii) {
                if (this.optionIcons[iii] == null) continue;
                inventory.setItem(iii, this.optionIcons[iii]);
            }
        }
        player.openInventory(inventory);
    }

    public void destroy() {
        this.handler = null;
        this.optionNames = null;
        this.optionIcons = null;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.name)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        try {
            if (slot < 0 || slot >= this.size || this.optionNames[slot] == null) {
                return;
            }
        }
        catch (NullPointerException e) {
            return;
        }
        OptionClickEvent clickEvent = new OptionClickEvent((Player)event.getWhoClicked(), slot, this.optionNames[slot], event.getInventory().getItem(event.getRawSlot()));
        this.handler.onOptionClick(clickEvent);
        if (event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR && clickEvent.willUpdate()) {
            this.update((Player)event.getWhoClicked());
        }
        if (clickEvent.willClose()) {
            Player player = (Player)event.getWhoClicked();
            Bukkit.getScheduler().runTaskLater((Plugin)BowSpleef.get(), () -> ((Player)player).closeInventory(), 1L);
        }
        if (clickEvent.willDestroy()) {
            this.destroy();
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getOptions() {
        return this.optionNames;
    }

    public static interface OptionClickEventHandler {
        public void onOptionClick(OptionClickEvent var1);
    }

    public static class OptionClickEvent {
        private final Player player;
        private final int position;
        private final String name;
        private boolean update;
        private boolean close;
        private boolean destroy;
        private final ItemStack item;

        public OptionClickEvent(Player player, int position, String name, ItemStack item) {
            this.player = player;
            this.position = position;
            this.name = name;
            this.close = false;
            this.destroy = false;
            this.update = false;
            this.item = item;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public boolean willClose() {
            return this.close;
        }

        public boolean willDestroy() {
            return this.destroy;
        }

        public void setWillClose(boolean close) {
            this.close = close;
        }

        public void setWillDestroy(boolean destroy) {
            this.destroy = destroy;
        }

        public void setUpdate(boolean b) {
            this.update = b;
        }

        public boolean willUpdate() {
            return this.update;
        }

        public ItemStack getClickedItem() {
            return this.item;
        }
    }
}

