/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.util;

import com.floodeer.bowspleef.util.IconMenu;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

public class IconCore
implements Listener {
    private final Map<Player, IconMenu> menu = Maps.newHashMap();

    public void create(Player player, String name, int size, IconMenu.OptionClickEventHandler handler) {
        if (player != null) {
            this.destroy(player);
            this.menu.put(player, new IconMenu(name, size, handler));
        }
    }

    public IconMenu getMenu(Player player) {
        return this.menu.get(player);
    }

    public void show(Player player) {
        if (this.menu.containsKey(player)) {
            this.menu.get(player).open(player);
        }
    }

    public void update(Player player) {
        if (this.menu.containsKey(player)) {
            this.menu.get(player).update(player);
        }
    }

    public void setOption(Player player, int position, ItemStack icon, String name, String ... info) {
        if (this.menu.containsKey(player)) {
            this.menu.get(player).setOption(position, icon, name, info);
        }
    }

    public void setOption(Player player, int position, ItemStack icon) {
        if (this.menu.containsKey(player)) {
            this.menu.get(player).setOption(position, icon, icon.getItemMeta().getDisplayName(), icon.getItemMeta().getLore());
        }
    }

    public void setOption(Player player, int position, ItemStack icon, String name, List<String> info) {
        if (this.menu.containsKey(player)) {
            this.menu.get(player).setOption(position, icon, name, info);
        }
    }

    public String[] getOptions(Player player) {
        if (this.menu.containsKey(player)) {
            return this.menu.get(player).getOptions();
        }
        return null;
    }

    public void destroy(Player player) {
        if (this.menu.containsKey(player)) {
            this.menu.remove(player).destroy();
            player.getOpenInventory().close();
        }
    }

    public void destroyAll() {
        for (Player player : new HashSet<Player>(this.menu.keySet())) {
            this.destroy(player);
        }
    }

    public boolean has(Player player) {
        return this.menu.containsKey(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=false)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player && this.menu.containsKey(event.getWhoClicked())) {
            this.menu.get(event.getWhoClicked()).onInventoryClick(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player && this.menu.containsKey(event.getPlayer())) {
            this.destroy((Player)event.getPlayer());
        }
    }
}

