/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.storage;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.storage.enums.Database;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class SQLite
implements Database {
    private AtomicReference<Connection> connection;
    private ExecutorService pool;

    public SQLite() throws ClassNotFoundException, SQLException {
        try {
            this.pool = Executors.newCachedThreadPool();
            this.connection = new AtomicReference();
            Class.forName("org.sqlite.JDBC");
            this.connect();
        }
        catch (SQLException ex) {
            this.close();
            ex.printStackTrace();
        }
    }

    @Override
    public void connect() throws SQLException {
        block6: {
            if (this.connection.get() != null) {
                try {
                    this.connection.get().createStatement().execute("SELECT 1;");
                }
                catch (SQLException sqlException) {
                    if (!sqlException.getSQLState().equals("08S01")) break block6;
                    try {
                        this.connection.get().close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.connection.get() == null || this.connection.get().isClosed()) {
            this.connection.set(DriverManager.getConnection("jdbc:sqlite:" + BowSpleef.get().getDataFolder() + "/players.db"));
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection.get() != null && !this.connection.get().isClosed()) {
                this.connection.get().close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection.set(null);
    }

    @Override
    public AtomicReference<Connection> getConnection() {
        return this.connection;
    }

    @Override
    public Executor getExecutor() {
        return this.pool;
    }

    @Override
    public boolean checkConnection() {
        try {
            this.connect();
        }
        catch (SQLException ex) {
            this.close();
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTables() throws SQLException {
        try (Statement statement = this.getConnection().get().createStatement();){
            String query = "CREATE TABLE IF NOT EXISTS `bowspleef_player` ( `player_id` integer PRIMARY KEY AUTOINCREMENT, `uuid` VARCHAR(255) NOT NULL UNIQUE, `playername` VARCHAR(60) NOT NULL, `games_played` INT NOT NULL DEFAULT 0, `wins` INT NOT NULL DEFAULT 0, `losses` INT NOT NULL DEFAULT 0, `trail` INT NOT NULL DEFAULT 0, `effect` INT NOT NULL DEFAULT 0, `shots` INT NOT NULL DEFAULT 0, `balance` INT NOT NULL DEFAULT 0);";
            statement.execute(query);
        }
        finally {
            this.connection.get().setAutoCommit(true);
        }
    }

    @Override
    public boolean columnExists(String column) {
        Connection conn = this.getConnection().get();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            ResultSet resultSet = metadata.getTables(null, null, "wizards_player", null);
            if (resultSet.next() && !(resultSet = metadata.getColumns(null, null, "wizards_player", column)).next()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String value) throws SQLException {
        Statement statement = null;
        Connection connection = this.getConnection().get();
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            String query = "ALTER TABLE wizards_player ADD " + value + " AFTER uuid";
            statement.execute(query);
            connection.commit();
        }
        finally {
            connection.setAutoCommit(true);
            if (statement != null) {
                statement.close();
            }
        }
    }
}

