/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.storage;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.storage.enums.Database;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class MySQL
implements Database {
    private final String connectionUri;
    private final String username;
    private final String password;
    private AtomicReference<Connection> connection;
    private ExecutorService pool;

    public MySQL(String hostname, String database, String username, String password, int port) throws ClassNotFoundException, SQLException {
        this.connectionUri = String.format("jdbc:mysql://%s:%d/%s", hostname, port, database);
        this.username = username;
        this.password = password;
        try {
            this.pool = Executors.newCachedThreadPool();
            this.connection = new AtomicReference();
            Class.forName("com.mysql.jdbc.Driver");
            this.connect();
        }
        catch (SQLException sqlException) {
            this.close();
        }
    }

    @Override
    public void connect() throws SQLException {
        block6: {
            if (this.connection.get() != null) {
                try {
                    this.connection.get().createStatement().execute("SELECT 1;");
                }
                catch (SQLException sqlException) {
                    if (!sqlException.getSQLState().equals("08S01")) break block6;
                    try {
                        this.connection.get().close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.connection.get() == null || this.connection.get().isClosed()) {
            this.connection.set(DriverManager.getConnection(this.connectionUri, this.username, this.password));
        }
    }

    @Override
    public void close() {
        try {
            if (this.connection.get() != null && !this.connection.get().isClosed()) {
                this.connection.get().close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.connection.set(null);
    }

    @Override
    public AtomicReference<Connection> getConnection() {
        return this.connection;
    }

    @Override
    public Executor getExecutor() {
        return this.pool;
    }

    @Override
    public boolean checkConnection() {
        try {
            this.connect();
        }
        catch (SQLException ex) {
            this.close();
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTables() throws IOException, SQLException {
        URL resource = Resources.getResource(BowSpleef.class, (String)"/tables.sql");
        String[] databaseStructure = Resources.toString((URL)resource, (Charset)Charsets.UTF_8).split(";");
        if (databaseStructure.length == 0) {
            return;
        }
        Statement statement = null;
        try {
            this.connection.get().setAutoCommit(false);
            statement = this.connection.get().createStatement();
            for (String query : databaseStructure) {
                if ((query = query.trim()).isEmpty()) continue;
                statement.execute(query);
            }
            this.connection.get().commit();
        }
        finally {
            this.connection.get().setAutoCommit(true);
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
    }

    @Override
    public boolean columnExists(String column) {
        Connection conn = this.getConnection().get();
        try {
            DatabaseMetaData metadata = conn.getMetaData();
            ResultSet resultSet = metadata.getTables(null, null, "bowspleef_player", null);
            if (resultSet.next() && !(resultSet = metadata.getColumns(null, null, "bowspleef_player", column)).next()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String value) throws IOException, SQLException {
        Statement statement = null;
        Connection connection = this.connection.get();
        try {
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            String query = "ALTER TABLE bowspleef_player ADD " + value + " AFTER uuid";
            statement.execute(query);
            connection.commit();
        }
        finally {
            connection.setAutoCommit(true);
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
    }
}

