/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.storage;

import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DataWriter {
    private static final int NUM_OF_ATTEMPTS = 5;

    public abstract void onWrite() throws SQLException;

    public void writeOperation(Executor executor, Logger logger, String exceptionMessage) {
        executor.execute(() -> this.attemptWrites(logger, exceptionMessage));
    }

    protected void attemptWrites(Logger logger, String exceptionMessage) {
        for (int attempt = 1; attempt <= 5; ++attempt) {
            try {
                this.onWrite();
                return;
            }
            catch (SQLException e) {
                if (attempt == 5) {
                    logger.log(Level.SEVERE, exceptionMessage, e);
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
    }
}

