/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.storage;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.storage.DataWriter;
import com.floodeer.bowspleef.storage.enums.Callback;
import com.floodeer.bowspleef.storage.enums.Database;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class DataStorage {
    private final Database db;

    public DataStorage(Database db) {
        this.db = db;
    }

    public void savePlayer(GamePlayer gp) {
        if (!this.db.checkConnection()) {
            return;
        }
        if (!gp.isFullyLoaded()) {
            return;
        }
        Connection connection = this.db.getConnection().get();
        String query = "UPDATE `bowspleef_player` SET `playername` = ?, `games_played` = ?, `trail` = ?, `effect` = ?, `wins` = ?, `losses` = ?, `balance` = ?, `shots` = ? WHERE `uuid` = ?;";
        try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.setString(1, gp.getName());
            preparedStatement.setInt(2, gp.getGamesPlayed());
            preparedStatement.setInt(3, gp.getTrail());
            preparedStatement.setInt(4, gp.getEffect());
            preparedStatement.setInt(5, gp.getWins());
            preparedStatement.setInt(6, gp.getLosses());
            preparedStatement.setInt(7, gp.getBalance());
            preparedStatement.setInt(8, gp.getArrowsShot());
            preparedStatement.setString(9, gp.getUUID().toString());
            preparedStatement.executeUpdate();
        }
        catch (SQLException ex) {
            BowSpleef.get().getLogger().severe("An internal error occurred while saving " + gp.getName() + "'s data.");
            ex.printStackTrace();
        }
    }

    public void savePlayerAsync(final GamePlayer gp) {
        if (!this.db.checkConnection()) {
            return;
        }
        if (!gp.isFullyLoaded()) {
            return;
        }
        new DataWriter(){

            @Override
            public void onWrite() throws SQLException {
                Connection connection = DataStorage.this.db.getConnection().get();
                String query = "UPDATE `bowspleef_player` SET `playername` = ?, `games_played` = ?, `trail` = ?, `effect` = ?, `wins` = ?, `losses` = ?, `balance` = ?, `shots` = ? WHERE `uuid` = ?;";
                try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                    preparedStatement.setString(1, gp.getName());
                    preparedStatement.setInt(2, gp.getGamesPlayed());
                    preparedStatement.setInt(3, gp.getTrail());
                    preparedStatement.setInt(4, gp.getEffect());
                    preparedStatement.setInt(5, gp.getWins());
                    preparedStatement.setInt(6, gp.getLosses());
                    preparedStatement.setInt(7, gp.getBalance());
                    preparedStatement.setInt(8, gp.getArrowsShot());
                    preparedStatement.setString(9, gp.getUUID().toString());
                    preparedStatement.executeUpdate();
                }
            }
        }.writeOperation(this.db.getExecutor(), BowSpleef.get().getLogger(), "An internal error occurred while saving " + gp.getName() + "'s data.");
    }

    public void loadPlayer(final String uuid, final GamePlayer gp) {
        if (!this.db.checkConnection()) {
            return;
        }
        new DataWriter(){
            final Connection connection;
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            {
                this.connection = DataStorage.this.db.getConnection().get();
                this.preparedStatement = null;
                this.resultSet = null;
            }

            @Override
            public void onWrite() throws SQLException {
                if (!DataStorage.this.checkPlayer(uuid)) {
                    DataStorage.this.insertPlayer(uuid);
                }
                String query = "SELECT `games_played`, `wins`, `losses`, `balance`, `shots`, `trail`, `effect` FROM `bowspleef_player` WHERE `uuid` = ? LIMIT 1;";
                this.preparedStatement = this.connection.prepareStatement(query);
                this.preparedStatement.setString(1, uuid);
                this.resultSet = this.preparedStatement.executeQuery();
                try {
                    if (this.resultSet != null && this.resultSet.next()) {
                        gp.setArrowsShot(this.resultSet.getInt("shots"));
                        gp.setWins(this.resultSet.getInt("wins"));
                        gp.setLosses(this.resultSet.getInt("losses"));
                        gp.setBalance(this.resultSet.getInt("balance"));
                        gp.setGamesPlayed(this.resultSet.getInt("games_played"));
                        gp.setTrail(this.resultSet.getInt("trail"));
                        gp.setEffect(this.resultSet.getInt("effect"));
                        gp.setFullyLoaded(true);
                    }
                }
                finally {
                    if (this.preparedStatement != null) {
                        this.preparedStatement.close();
                    }
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                }
            }
        }.writeOperation(this.db.getExecutor(), BowSpleef.get().getLogger(), "An internal error occurred while loading " + uuid + "'s data.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPlayer(String uuid) {
        if (!this.db.checkConnection()) {
            return false;
        }
        int count = 0;
        Statement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String query = "SELECT Count(`player_id`) FROM `bowspleef_player` WHERE `uuid` = ? LIMIT 1;";
            preparedStatement = this.db.getConnection().get().prepareStatement(query);
            preparedStatement.setString(1, uuid);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPlayer(String uid) {
        if (!this.db.checkConnection()) {
            return;
        }
        UUID uuid = UUID.fromString(uid);
        Statement preparedStatement = null;
        try {
            String query = "INSERT INTO `bowspleef_player` (`player_id`, `uuid`, `playername`) VALUES (NULL, ?, ?);";
            preparedStatement = this.db.getConnection().get().prepareStatement(query);
            preparedStatement.setString(1, uid);
            preparedStatement.setString(2, BowSpleef.get().getServer().getPlayer(uuid).getName());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void doesPlayerExists(final String name, final Callback<Boolean> result) {
        if (!this.db.checkConnection()) {
            return;
        }
        this.db.getExecutor().execute(new Runnable(){
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;

            @Override
            public void run() {
                String query = "SELECT Count(`player_id`) FROM `bowspleef_player` WHERE `playername` = ? LIMIT 1;";
                try {
                    this.preparedStatement = DataStorage.this.db.getConnection().get().prepareStatement(query);
                    this.preparedStatement.setString(1, name);
                    this.resultSet = this.preparedStatement.executeQuery();
                    if (this.resultSet.next()) {
                        if (this.resultSet.getInt(1) > 0) {
                            result.onCall(true);
                        } else {
                            result.onCall(false);
                        }
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (this.preparedStatement != null) {
                            this.preparedStatement.close();
                        }
                        if (this.resultSet != null) {
                            this.resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    public void setCoins(final String name, final int amount, Callback<Boolean> result) {
        if (!this.db.checkConnection()) {
            return;
        }
        this.doesPlayerExists(name, result);
        this.db.getExecutor().execute(new Runnable(){
            PreparedStatement preparedStatement = null;

            @Override
            public void run() {
                String query = "UPDATE `bowspleef_player` SET `balance` = ? WHERE `playername` = ?;";
                try {
                    this.preparedStatement = DataStorage.this.db.getConnection().get().prepareStatement(query);
                    this.preparedStatement.setInt(1, amount);
                    this.preparedStatement.setString(2, name);
                    this.preparedStatement.executeUpdate();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (this.preparedStatement != null) {
                            this.preparedStatement.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    public void getCoins(final String name, final Callback<Integer> result) {
        if (!this.db.checkConnection()) {
            return;
        }
        this.db.getExecutor().execute(new Runnable(){
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;

            @Override
            public void run() {
                String query = "SELECT `balance` FROM `bowspleef_player` WHERE `playername` = ? LIMIT 1;";
                try {
                    this.preparedStatement = DataStorage.this.db.getConnection().get().prepareStatement(query);
                    this.preparedStatement.setString(1, name);
                    this.resultSet = this.preparedStatement.executeQuery();
                    result.onCall(this.resultSet.getInt("balance"));
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        if (this.preparedStatement != null) {
                            this.preparedStatement.close();
                        }
                        if (this.resultSet != null) {
                            this.resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
        });
    }

    public static enum StorageType {
        MYSQL("MYSQL"),
        SQLITE("SQLITE");

        String type;

        private StorageType(String type) {
            this.type = type;
        }

        public static StorageType fromString(String t) {
            for (StorageType type : StorageType.values()) {
                if (!t.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
            return null;
        }
    }
}

