/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.manager;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerManager {
    private final Map<UUID, GamePlayer> onlinePlayers = Maps.newHashMap();

    public PlayerManager() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.addPlayer(player.getUniqueId());
        }
    }

    public void addPlayer(UUID uuid) {
        if (!this.onlinePlayers.containsKey(uuid)) {
            GamePlayer gamePlayer = new GamePlayer(uuid);
            this.onlinePlayers.put(uuid, gamePlayer);
        }
    }

    public void addPlayer(Player player) {
        boolean present = this.getAll().stream().map(GamePlayer::getPlayer).anyMatch(cur -> cur.equals(player));
        if (!present) {
            GamePlayer gamePlayer = new GamePlayer(player);
            this.onlinePlayers.put(gamePlayer.getUUID(), gamePlayer);
        }
    }

    public void removePlayer(UUID uuid) {
        if (this.onlinePlayers.containsKey(uuid)) {
            this.updateAsync(this.getPlayer(uuid));
            this.onlinePlayers.remove(uuid);
        }
    }

    public GamePlayer getPlayer(UUID uuid) {
        return this.onlinePlayers.get(uuid);
    }

    public GamePlayer getPlayer(String name) {
        for (GamePlayer gPlayer : this.onlinePlayers.values()) {
            if (!gPlayer.getName().equals(name)) continue;
            return gPlayer;
        }
        return null;
    }

    public Collection<GamePlayer> getAll() {
        return this.onlinePlayers.values();
    }

    public void shutdown() {
        this.updateAll();
        this.onlinePlayers.clear();
    }

    public void restart() {
        BowSpleef.get().getLogger().warning("Reloading the server can cause data corruption. Please restart next time.");
        this.shutdown();
        Bukkit.getOnlinePlayers().forEach(cur -> this.addPlayer(cur.getUniqueId()));
    }

    public void updateAll() {
        this.onlinePlayers.values().forEach(this::update);
    }

    public void updateAllAsync() {
        this.onlinePlayers.values().forEach(this::updateAsync);
    }

    public void update(GamePlayer gp) {
        BowSpleef.get().getStorage().savePlayer(gp);
    }

    public void updateAsync(GamePlayer gp) {
        BowSpleef.get().getStorage().savePlayerAsync(gp);
    }
}

