/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.manager;

import java.util.Collection;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class PlayerInventory {
    private final ItemStack[] content;
    private final ItemStack[] armor;
    private final float exp;
    private final GameMode gameMode;
    private final int level;
    private final int foodLevel;
    private final Collection<PotionEffect> effects;
    private final Player p;

    public PlayerInventory(Player p) {
        this.p = p;
        this.content = p.getInventory().getContents();
        this.armor = p.getInventory().getArmorContents();
        this.level = p.getLevel();
        this.exp = p.getExp();
        this.gameMode = p.getGameMode();
        this.foodLevel = p.getFoodLevel();
        this.effects = p.getActivePotionEffects();
    }

    public ItemStack[] getContent() {
        return this.content;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public int getLevel() {
        return this.level;
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public float getExp() {
        return this.exp;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public Collection<PotionEffect> getPotionEffects() {
        return this.effects;
    }

    public void restore() {
        this.p.getInventory().clear();
        this.p.setGameMode(this.gameMode);
        this.p.setLevel(this.level);
        this.p.setExp(this.exp);
        this.p.setFoodLevel(this.foodLevel);
        this.p.getInventory().setArmorContents(this.armor);
        this.p.getInventory().setContents(this.content);
        this.p.updateInventory();
        for (PotionEffect pf : this.getPotionEffects()) {
            this.p.addPotionEffect(pf);
        }
    }
}

