/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.manager;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.storage.DataWriter;
import com.floodeer.bowspleef.storage.enums.Database;
import com.floodeer.bowspleef.storage.leaderboard.OfflineGamePlayer;
import com.floodeer.bowspleef.util.Runner;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LeaderboardManager {
    private final Map<String, OfflineGamePlayer> data;
    private final Database db;
    private int dataLimit;

    public LeaderboardManager(Database db) {
        this.db = db;
        this.data = Maps.newHashMap();
        this.setDataLimit(BowSpleef.get().getOptions().dataLimit);
        new BukkitRunnable(){

            public void run() {
                LeaderboardManager.this.sendUpdate();
                Runner.make(BowSpleef.get()).delay(200).run(() -> LeaderboardManager.this.receiveUpdate());
            }
        }.runTaskTimer((Plugin)BowSpleef.get(), 0L, (long)BowSpleef.get().getOptions().updateDelay * 20L);
    }

    public List<Map.Entry<String, Integer>> getTopWins() {
        HashMap wins = Maps.newHashMap();
        this.data.values().forEach(d -> wins.put(d.getPlayer(), d.getWins()));
        return wins.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(BowSpleef.get().getOptions().dataLimit).collect(Collectors.toList());
    }

    public List<Map.Entry<String, Integer>> getTopShots() {
        HashMap shots = Maps.newHashMap();
        this.data.values().forEach(d -> shots.put(d.getPlayer(), d.getShots()));
        return shots.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(BowSpleef.get().getOptions().dataLimit).collect(Collectors.toList());
    }

    public void receiveUpdate() {
        new DataWriter(){
            PreparedStatement statement = null;
            ResultSet rs = null;

            @Override
            public void onWrite() throws SQLException {
                try {
                    this.statement = LeaderboardManager.this.db.getConnection().get().prepareStatement("SELECT * FROM `bowspleef_player`");
                    this.rs = this.statement.executeQuery();
                    while (this.rs.next()) {
                        String name = this.rs.getString("playername");
                        OfflineGamePlayer ogp = new OfflineGamePlayer(this.rs.getString("playername"));
                        ogp.setWins(this.rs.getInt("wins"));
                        ogp.setShots(this.rs.getInt("shots"));
                        ogp.setGamesPlayed(this.rs.getInt("games_played"));
                        LeaderboardManager.this.data.put(name, ogp);
                    }
                }
                finally {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                    if (this.rs != null) {
                        this.rs.close();
                    }
                }
            }
        }.writeOperation(this.db.getExecutor(), Logger.getLogger("Minecraft"), "Error while getting data from Database.");
    }

    public void sendUpdate() {
        BowSpleef.get().getPM().getAll().forEach(this::update);
    }

    private void update(final GamePlayer player) {
        final String uuid = player.getPlayer().getUniqueId().toString();
        if (!player.isFullyLoaded()) {
            return;
        }
        new DataWriter(){
            PreparedStatement preparedStatement = null;

            @Override
            public void onWrite() throws SQLException {
                StringBuilder query = new StringBuilder();
                query.append("UPDATE `bowspleef_player` SET ");
                query.append("`shots` = ?, `wins` = ?, `games_played` = ? ");
                query.append("WHERE `uuid` = ?;");
                try {
                    this.preparedStatement = LeaderboardManager.this.db.getConnection().get().prepareStatement(query.toString());
                    this.preparedStatement.setInt(1, player.getArrowsShot());
                    this.preparedStatement.setInt(2, player.getWins());
                    this.preparedStatement.setInt(3, player.getGamesPlayed());
                    this.preparedStatement.setString(4, uuid);
                    this.preparedStatement.executeUpdate();
                }
                finally {
                    if (this.preparedStatement != null) {
                        this.preparedStatement.close();
                    }
                }
            }
        }.writeOperation(this.db.getExecutor(), Logger.getLogger("Minecraft"), "Failed while saving " + player.getPlayer().getName() + "'s data.");
    }

    public int getDataLimit() {
        return this.dataLimit;
    }

    public void setDataLimit(int dataLimit) {
        this.dataLimit = dataLimit;
    }

    public OfflineGamePlayer get(String name) {
        return this.data.get(name);
    }
}

