/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.manager;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.util.FileUtils;
import com.floodeer.bowspleef.util.Runner;
import com.floodeer.bowspleef.util.WorldUtils;
import com.floodeer.bowspleef.util.update.VoidGenerator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.BlockState;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameManager {
    private final List<Game> games;
    private final Queue<GamePlayer> queue;
    private final Map<String, LinkedList<BlockState>> blockCache = Maps.newHashMap();

    public GameManager() {
        this.games = Lists.newArrayList();
        this.queue = Lists.newLinkedList();
        File mapsFolder = new File(BowSpleef.get().getDataFolder() + File.separator + "maps");
        Runner.make(BowSpleef.get()).delay(20).run(() -> {
            if (mapsFolder.listFiles() != null) {
                for (File files : Objects.requireNonNull(mapsFolder.listFiles())) {
                    try {
                        this.createGame(files.getName().replaceAll(".yml", ""), true);
                        BowSpleef.get().getLogger().info("Game " + files.getName().replaceAll(".yml", "") + " was been created.");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)BowSpleef.get(), () -> this.getGames().stream().filter(Game::canStart).forEach(Game::checkForStart), 60L, 25L);
    }

    public List<Game> getGames() {
        return this.games;
    }

    public Game createGame(String gameName, boolean load) {
        AtomicReference<Game> game = new AtomicReference<Game>();
        if (BowSpleef.get().getOptions().advancedRestore) {
            if (!load) {
                game.set(new Game(gameName, false));
                this.games.add((Game)game.get());
                return (Game)game.get();
            }
            BowSpleef.get().getServer().getScheduler().runTaskAsynchronously((Plugin)BowSpleef.get(), () -> {
                File target = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath(), gameName);
                if (target.exists()) {
                    WorldUtils.deleteWorld(target);
                }
                File source = new File(BowSpleef.get().getDataFolder() + File.separator + "maps" + File.separator + gameName + File.separator + gameName);
                WorldUtils.copyWorld(source, target);
                WorldUtils.loadWorldTask(gameName, () -> {
                    game.set(new Game(gameName, load));
                    this.games.add((Game)game.get());
                    if (!this.queue.isEmpty()) {
                        while (this.canJoin((Game)game.get()) && !this.queue.isEmpty()) {
                            ((Game)game.get()).addPlayer(Objects.requireNonNull(this.queue.poll()));
                        }
                    }
                });
            });
        } else {
            game.set(new Game(gameName, load));
            this.games.add((Game)game.get());
        }
        return (Game)game.get();
    }

    public void finish(String gameName) {
        if (BowSpleef.get().getOptions().advancedRestore) {
            WorldUtils.unloadWorld(gameName);
            File target = new File(BowSpleef.get().getDataFolder() + File.separator + "maps" + File.separator + gameName + File.separator + gameName);
            WorldUtils.deleteWorld(target);
            File source = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath(), gameName);
            WorldUtils.copyWorld(source, target);
            WorldUtils.deleteWorld(source);
            Runner.make(BowSpleef.get()).delay(60).run(() -> this.createGame(gameName, true));
        } else {
            this.games.removeIf(cur -> cur.getName().equalsIgnoreCase(gameName));
            Game game = new Game(gameName, true);
            this.games.add(game);
        }
    }

    public void deleteGame(String name) throws IOException {
        File target;
        File dataDirectory;
        Game game = this.getGameFromName(name);
        if (game.getState() == Game.GameState.IN_GAME) {
            game.shutdown(false);
        }
        if (BowSpleef.get().getOptions().advancedRestore) {
            WorldUtils.deleteWorld(name);
            WorldUtils.deleteWorldGuard(name);
            dataDirectory = new File(BowSpleef.get().getDataFolder(), "maps");
            target = new File(dataDirectory, name);
            FileUtils.deleteDirectory(target);
        }
        game.getGameArena().deleteArena();
        dataDirectory = new File(BowSpleef.get().getDataFolder(), "maps");
        target = new File(dataDirectory, name);
        FileUtils.deleteDirectory(target);
        this.games.remove(game);
    }

    public boolean doesMapExists(String name) {
        File mapsFolder = new File(BowSpleef.get().getDataFolder() + File.separator + "maps");
        for (File files : mapsFolder.listFiles()) {
            if (!files.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Game getGameFromName(String name) {
        return this.games.stream().filter(game -> game.getName().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    public Game recreateGame(Game game) {
        this.games.remove(game);
        if (!BowSpleef.get().getOptions().advancedRestore) {
            return this.createGame(game.getName(), true);
        }
        final String worldName = game.getName();
        BowSpleef.get().getServer().unloadWorld(worldName, false);
        new BukkitRunnable(){

            public void run() {
                WorldUtils.deleteWorldGuard(worldName);
                File target = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath(), worldName);
                if (target.exists()) {
                    WorldUtils.deleteWorld(target);
                }
                File source = new File(BowSpleef.get().getDataFolder() + File.separator + "maps" + File.separator + worldName + File.separator + worldName);
                WorldUtils.copyWorld(source, target);
                new BukkitRunnable(){

                    public void run() {
                        WorldCreator wc = new WorldCreator(worldName);
                        wc.generateStructures(false);
                        wc.generator((ChunkGenerator)new VoidGenerator());
                        World w = Bukkit.createWorld((WorldCreator)wc);
                        if (w == null) {
                            throw new IllegalStateException("World should be null");
                        }
                        w.setKeepSpawnInMemory(false);
                        w.setAutoSave(false);
                        Game newGame = new Game(worldName, true);
                        GameManager.this.games.add(newGame);
                        if (!GameManager.this.queue.isEmpty()) {
                            while (GameManager.this.canJoin(newGame) && !GameManager.this.queue.isEmpty()) {
                                newGame.addPlayer((GamePlayer)GameManager.this.queue.poll());
                            }
                        }
                    }
                }.runTaskLater((Plugin)BowSpleef.get(), 45L);
            }
        }.runTaskAsynchronously((Plugin)BowSpleef.get());
        return null;
    }

    public void shutdownGames() {
        this.getGames().forEach(game -> game.shutdown(false));
    }

    public Game findGameFor(GamePlayer gp) {
        Game result = null;
        List<Game> games = this.getGames();
        Collections.shuffle(games);
        for (Game g : games) {
            if (g.getPlayers().size() > 0 && this.canJoin(g)) {
                result = g;
                break;
            }
            if (!this.canJoin(g)) continue;
            result = g;
        }
        if (result == null) {
            this.queue.add(gp);
            return null;
        }
        return result;
    }

    public Game getNextGame(GamePlayer optionalPlayer) {
        for (Game game : this.games) {
            if (game.getState() != Game.GameState.PRE_GAME && (!BowSpleef.get().getOptions().joinWhileStarting || game.getState() != Game.GameState.STARTING)) continue;
            if (game.getPlayers().size() <= game.getGameArena().getMaxPlayers()) {
                return game;
            }
            if (optionalPlayer == null || game.getPlayers().size() < game.getGameArena().getMaxPlayers() || !optionalPlayer.getPlayer().hasPermission("bowspleef.joinfull")) continue;
            return game;
        }
        return null;
    }

    private boolean canJoin(Game g) {
        if (!BowSpleef.get().getOptions().joinWhileStarting) {
            return (g.getState() == Game.GameState.PRE_GAME || g.getState() == Game.GameState.STARTING) && g.getPlayers().size() < g.getMaxPlayers();
        }
        return g.getState() == Game.GameState.PRE_GAME && g.getPlayers().size() < g.getMaxPlayers();
    }

    public Map<String, LinkedList<BlockState>> getBlockCache() {
        return this.blockCache;
    }

    public LinkedList<BlockState> getBlocks(String game) {
        return this.getBlockCache().get(game);
    }

    public boolean isCached(String gameName) {
        return this.blockCache.get(gameName) != null;
    }
}

