/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.hook;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.storage.leaderboard.OfflineGamePlayer;
import com.floodeer.bowspleef.util.MathUtils;
import com.floodeer.bowspleef.util.Util;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlaceholderAPIHook
extends PlaceholderExpansion {
    private final Plugin plugin;

    public PlaceholderAPIHook(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getIdentifier() {
        return "bowspleef";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String onRequest(OfflinePlayer player, String identifier) {
        if (identifier.startsWith("all_players")) {
            return Integer.toString((int)BowSpleef.get().getPM().getAll().stream().filter(GamePlayer::isInGame).count());
        }
        if (identifier.startsWith("arena_players_")) {
            Game game = BowSpleef.get().getGM().getGameFromName(identifier.substring(14).replaceAll("%", ""));
            if (game != null) {
                return Integer.toString(game.getPlayers().size());
            }
        } else if (identifier.startsWith("arena_max_players_")) {
            Game game = BowSpleef.get().getGM().getGameFromName(identifier.substring(18).replaceAll("%", ""));
            if (game != null) {
                return Integer.toString(game.getGameArena().getMaxPlayers());
            }
        } else if (identifier.startsWith("arena_min_players_")) {
            Game game = BowSpleef.get().getGM().getGameFromName(identifier.substring(18).replaceAll("%", ""));
            if (game != null) {
                return Integer.toString(game.getGameArena().getMinPlayers());
            }
        } else if (identifier.startsWith("arena_status_")) {
            Game game = BowSpleef.get().getGM().getGameFromName(identifier.substring(13).replaceAll("%", ""));
            if (game != null) {
                return game.getState().toString();
            }
        } else {
            String posS;
            if (player.getPlayer() == null || GamePlayer.get(player.getPlayer()) == null) {
                OfflineGamePlayer ogp = BowSpleef.get().getLeaderboardManager().get(player.getName());
                if (ogp == null) {
                    return "";
                }
                if (identifier.equalsIgnoreCase("wins")) {
                    return Integer.toString(ogp.getWins());
                }
                if (identifier.equalsIgnoreCase("shots")) {
                    return Integer.toString(ogp.getShots());
                }
                if (identifier.equalsIgnoreCase("gamesplayed")) {
                    return Integer.toString(ogp.getGamesPlayed());
                }
            } else {
                GamePlayer gp = GamePlayer.get(player.getPlayer());
                if (identifier.equalsIgnoreCase("wins")) {
                    return Integer.toString(gp.getWins());
                }
                if (identifier.equalsIgnoreCase("gamesplayed")) {
                    return Integer.toString(gp.getGamesPlayed());
                }
                if (identifier.equalsIgnoreCase("losses")) {
                    return Integer.toString(gp.getLosses());
                }
                if (identifier.equalsIgnoreCase("shots")) {
                    return Integer.toString(gp.getArrowsShot());
                }
            }
            if (identifier.startsWith("leaderboard_shots")) {
                try {
                    posS = identifier.replaceAll("[^0-9]", "");
                    if (!MathUtils.isInteger(posS)) {
                        return Util.colorString(BowSpleef.get().getLanguage().noData, new Player[0]);
                    }
                    int p = Integer.parseInt(posS) - 1;
                    if (BowSpleef.get().getLeaderboardManager().getTopShots().get(p) != null || BowSpleef.get().getLeaderboardManager().getTopShots().get(p).getKey() == null) {
                        int shots = BowSpleef.get().getLeaderboardManager().getTopShots().get(p).getValue();
                        String name = BowSpleef.get().getLeaderboardManager().getTopShots().get(p).getKey();
                        return Util.colorString(BowSpleef.get().getLanguage().shotsLBFormat.replaceAll("%position%", Integer.toString(p)).replaceAll("%player%", name).replaceAll("%shots%", Integer.toString(shots)), new Player[0]);
                    }
                    return Util.colorString(BowSpleef.get().getLanguage().noData, new Player[0]);
                }
                catch (Exception ex) {
                    return Util.colorString(BowSpleef.get().getLanguage().noData, new Player[0]);
                }
            }
            if (identifier.startsWith("leaderboard_wins")) {
                try {
                    posS = identifier.replaceAll("[^0-9]", "");
                    if (!MathUtils.isInteger(posS)) {
                        return Util.colorString(BowSpleef.get().getLanguage().noData, new Player[0]);
                    }
                    int p = Integer.parseInt(posS) - 1;
                    if (BowSpleef.get().getLeaderboardManager().getTopWins().get(p) != null) {
                        int shots = BowSpleef.get().getLeaderboardManager().getTopWins().get(p).getValue();
                        String name = BowSpleef.get().getLeaderboardManager().getTopWins().get(p).getKey();
                        return Util.colorString(BowSpleef.get().getLanguage().winsLBFormat.replaceAll("%position%", Integer.toString(p)).replaceAll("%player%", name).replaceAll("%wins%", Integer.toString(shots)), new Player[0]);
                    }
                }
                catch (Exception ex) {
                    return Util.colorString(BowSpleef.get().getLanguage().noData, new Player[0]);
                }
            }
        }
        return "";
    }
}

