/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game.structure;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.structure.ArenaCuboid;
import com.floodeer.bowspleef.game.structure.ArenaRestore;
import com.floodeer.bowspleef.util.GameDataFile;
import com.floodeer.bowspleef.util.GameDataYaml;
import com.floodeer.bowspleef.util.LocationUtils;
import com.floodeer.bowspleef.util.Util;
import com.floodeer.bowspleef.util.WorldUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GameArena {
    private final String map;
    private GameDataFile gameFile;
    private File gameFolder;
    private final Map<String, List<Location>> powerups = Maps.newHashMap();
    private ArenaCuboid cuboid;
    private ArenaRestore restore;

    public GameArena(String name) {
        this.map = name;
        if (this.doesMapExists()) {
            this.gameFolder = new File(BowSpleef.get().getDataFolder() + File.separator + "maps" + File.separator + name);
            this.gameFile = GameDataYaml.getMap(name);
        }
    }

    public void load(Game game) {
        if (!this.powerups.isEmpty()) {
            this.powerups.clear();
        }
        if (this.getLocation(LocationType.LOW) != null && this.getLocation(LocationType.HIGH) != null) {
            this.cuboid = new ArenaCuboid(game, this.getLocation(LocationType.LOW), this.getLocation(LocationType.HIGH));
        }
        if (BowSpleef.get().getOptions().advancedRestore) {
            this.loadMap();
        } else {
            this.restore = new ArenaRestore(game);
        }
    }

    private List<Location> loadPowerups(String type) {
        ArrayList<Location> locations = new ArrayList<Location>();
        List<String> spawns = this.gameFile.getStringList("Locations.powerups." + type);
        Iterator<String> iter = spawns.iterator();
        while (iter.hasNext()) {
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)new JSONParser().parse(iter.next());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            locations.add(LocationUtils.getLocation(jsonObject, true));
        }
        return locations;
    }

    public void addPowerup(Location l, String type) {
        if (!this.gameFile.contains("Locations.powerups." + type)) {
            this.gameFile.createNewStringList("Locations.powerups." + type, new ArrayList<String>());
        }
        List<String> spawns = this.gameFile.getStringList("Locations.powerups." + type);
        spawns.add(LocationUtils.saveLocation(l, true));
        this.gameFile.set("Locations.powerups." + type, spawns);
        this.gameFile.save();
    }

    public void registerPowerup(String name) {
        this.powerups.put(name, Lists.newArrayList());
        this.powerups.get(name).addAll(this.loadPowerups(name));
    }

    public Map<String, List<Location>> getPowerups() {
        return this.powerups;
    }

    public String getName() {
        return this.map;
    }

    public boolean doesMapExists() {
        File mapsFolder = new File(BowSpleef.get().getDataFolder() + File.separator + "maps");
        for (File files : mapsFolder.listFiles()) {
            if (!files.getName().equalsIgnoreCase(this.map)) continue;
            return true;
        }
        return false;
    }

    public void create() {
        this.gameFile = GameDataYaml.getMap(this.map);
        this.gameFile.add("Name", this.map);
        this.gameFile.add("Map.Sign.Name", this.map);
        this.gameFile.add("Map.isSignSet", false);
        this.gameFile.add("Map.MinPlayers", 8);
        this.gameFile.add("Map.MaxPlayers", 16);
        this.gameFile.save();
    }

    public void setSignLines(Sign sign) {
        if (BowSpleef.get().getOptions().isBungeeCord) {
            return;
        }
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline1);
        String line2 = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline2);
        String line3 = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline3);
        String line4 = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline4);
        if (line2.contains("%state%")) {
            if (this.getGame().getState() == Game.GameState.PRE_GAME) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().waitingSign);
            } else if (this.getGame().getState() == Game.GameState.STARTING) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().startingSign);
            } else if (this.getGame().getState() == Game.GameState.IN_GAME) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().ingameSign);
            } else if (this.getGame().getState() == Game.GameState.ENDING) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().endingSign);
            } else if (this.getGame().getState() == Game.GameState.RESTORING) {
                line2 = line2.replaceAll("%restoring%", BowSpleef.get().getLanguage().endingSign);
            }
        }
        if (line3.contains("%state%")) {
            if (this.getGame().getState() == Game.GameState.PRE_GAME) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().waitingSign);
            } else if (this.getGame().getState() == Game.GameState.STARTING) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().startingSign);
            } else if (this.getGame().getState() == Game.GameState.IN_GAME) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().ingameSign);
            } else if (this.getGame().getState() == Game.GameState.ENDING) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().endingSign);
            } else if (this.getGame().getState() == Game.GameState.RESTORING) {
                line2 = line2.replaceAll("%restoring%", BowSpleef.get().getLanguage().endingSign);
            }
        }
        if (line4.contains("%state%")) {
            if (this.getGame().getState() == Game.GameState.PRE_GAME) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().waitingSign);
            } else if (this.getGame().getState() == Game.GameState.STARTING) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().startingSign);
            } else if (this.getGame().getState() == Game.GameState.IN_GAME) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().ingameSign);
            } else if (this.getGame().getState() == Game.GameState.ENDING) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().endingSign);
            } else if (this.getGame().getState() == Game.GameState.RESTORING) {
                line2 = line2.replaceAll("%restoring%", BowSpleef.get().getLanguage().endingSign);
            }
        }
        if (line3.contains("%players%")) {
            line3 = line3.replace("%players%", String.valueOf(this.getGame().getPlayers().size()));
        }
        if (line3.contains("%minplayers%")) {
            line3 = line3.replace("%minplayers%", String.valueOf(this.getGame().getMinPlayers()));
        }
        if (line3.contains("%maxplayers%")) {
            line3 = line3.replace("%maxplayers%", String.valueOf(this.getGame().getMaxPlayers()));
        }
        if (line3.contains("%mapname%")) {
            line3 = line3.replace("%mapname%", String.valueOf(this.getGame().getName()));
        }
        if (line4.contains("%players%")) {
            line4 = line4.replace("%players%", String.valueOf(this.getGame().getPlayers().size()));
        }
        if (line4.contains("%minplayers%")) {
            line4 = line4.replace("%minplayers%", String.valueOf(this.getGame().getMinPlayers()));
        }
        if (line4.contains("%maxplayers%")) {
            line4 = line4.replace("%maxplayers%", String.valueOf(this.getGame().getMaxPlayers()));
        }
        if (line4.contains("%mapname%")) {
            line4 = line4.replace("%mapname%", String.valueOf(this.getGame().getName()));
        }
        if (line2.contains("%mapname%")) {
            line2 = line2.replace("%mapname%", String.valueOf(this.getGame().getName()));
        }
        sign.setLine(0, Util.colorString(prefix, new Player[0]));
        sign.setLine(1, ChatColor.translateAlternateColorCodes((char)'&', (String)line2));
        sign.setLine(2, ChatColor.translateAlternateColorCodes((char)'&', (String)line3));
        sign.setLine(3, ChatColor.translateAlternateColorCodes((char)'&', (String)line4));
        sign.update(true);
    }

    public void addSign(Sign sign, Location loc) {
        this.gameFile.set("Map.Sign.world", loc.getWorld().getName());
        this.gameFile.set("Map.Sign.x", loc.getX());
        this.gameFile.set("Map.Sign.y", loc.getY());
        this.gameFile.set("Map.Sign.z", loc.getZ());
        this.gameFile.set("Map.isSignSet", true);
        this.gameFile.save();
        this.updateSign();
    }

    public void breakSign(Sign sign) {
        this.gameFile.set("Map.Sign.world", null);
        this.gameFile.set("Map.Sign.x", null);
        this.gameFile.set("Map.Sign.y", null);
        this.gameFile.set("Map.Sign.z", null);
        this.gameFile.set("Map.isSignSet", false);
        this.gameFile.save();
    }

    public Location getSign() {
        if (!this.isSignSet()) {
            return null;
        }
        Location l = new Location(Bukkit.getWorld((String)this.gameFile.getString("Map.Sign.world")), this.gameFile.getDouble("Map.Sign.x"), this.gameFile.getDouble("Map.Sign.y"), this.gameFile.getDouble("Map.Sign.z"));
        return l;
    }

    public void updateSign() {
        if (BowSpleef.get().getOptions().isBungeeCord) {
            return;
        }
        if (this.getSign() == null) {
            return;
        }
        if (!Util.isWallSign(this.getSign().getBlock())) {
            return;
        }
        Sign sign = (Sign)this.getSign().getBlock().getState();
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline1);
        String line2 = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline2);
        String line3 = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline3);
        String line4 = ChatColor.translateAlternateColorCodes((char)'&', (String)BowSpleef.get().getLanguage().signline4);
        if (line2.contains("%state%")) {
            if (this.getGame().getState() == Game.GameState.PRE_GAME) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().waitingSign);
            } else if (this.getGame().getState() == Game.GameState.STARTING) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().startingSign);
            } else if (this.getGame().getState() == Game.GameState.IN_GAME) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().ingameSign);
            } else if (this.getGame().getState() == Game.GameState.ENDING) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().endingSign);
            } else if (this.getGame().getState() == Game.GameState.RESTORING) {
                line2 = line2.replaceAll("%state%", BowSpleef.get().getLanguage().resettingSign);
            }
        }
        if (line3.contains("%state%")) {
            if (this.getGame().getState() == Game.GameState.PRE_GAME) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().waitingSign);
            } else if (this.getGame().getState() == Game.GameState.STARTING) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().startingSign);
            } else if (this.getGame().getState() == Game.GameState.IN_GAME) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().ingameSign);
            } else if (this.getGame().getState() == Game.GameState.ENDING) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().endingSign);
            } else if (this.getGame().getState() == Game.GameState.RESTORING) {
                line3 = line3.replaceAll("%state%", BowSpleef.get().getLanguage().resettingSign);
            }
        }
        if (line4.contains("%state%")) {
            if (this.getGame().getState() == Game.GameState.PRE_GAME) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().waitingSign);
            } else if (this.getGame().getState() == Game.GameState.STARTING) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().startingSign);
            } else if (this.getGame().getState() == Game.GameState.IN_GAME) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().ingameSign);
            } else if (this.getGame().getState() == Game.GameState.ENDING) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().endingSign);
            } else if (this.getGame().getState() == Game.GameState.RESTORING) {
                line4 = line4.replaceAll("%state%", BowSpleef.get().getLanguage().resettingSign);
            }
        }
        if (line3.contains("%players%")) {
            line3 = line3.replace("%players%", String.valueOf(this.getGame().getPlayers().size()));
        }
        if (line3.contains("%minplayers%")) {
            line3 = line3.replace("%minplayers%", String.valueOf(this.getGame().getMinPlayers()));
        }
        if (line3.contains("%maxplayers%")) {
            line3 = line3.replace("%maxplayers%", String.valueOf(this.getGame().getMaxPlayers()));
        }
        if (line3.contains("%mapname%")) {
            line3 = line3.replace("%mapname%", String.valueOf(this.getGame().getName()));
        }
        if (line4.contains("%players%")) {
            line4 = line4.replace("%players%", this.getGame().getPlayers() == null ? "0" : String.valueOf(this.getGame().getPlayers().size()));
        }
        if (line4.contains("%minplayers%")) {
            line4 = line4.replace("%minplayers%", String.valueOf(this.getGame().getMinPlayers()));
        }
        if (line4.contains("%maxplayers%")) {
            line4 = line4.replace("%maxplayers%", String.valueOf(this.getGame().getMaxPlayers()));
        }
        if (line4.contains("%mapname%")) {
            line4 = line4.replace("%mapname%", String.valueOf(this.getGame().getName()));
        }
        if (line2.contains("%mapname%")) {
            line2 = line2.replace("%mapname%", String.valueOf(this.getGame().getName()));
        }
        sign.setLine(0, Util.colorString(ChatColor.translateAlternateColorCodes((char)'&', (String)prefix), new Player[0]));
        sign.setLine(1, ChatColor.translateAlternateColorCodes((char)'&', (String)line2));
        sign.setLine(2, ChatColor.translateAlternateColorCodes((char)'&', (String)line3));
        sign.setLine(3, ChatColor.translateAlternateColorCodes((char)'&', (String)line4));
        sign.update(true);
    }

    public void setMinPlayers(int x) {
        this.gameFile.set("Map.MinPlayers", x);
        this.gameFile.save();
    }

    public void setMaxPlayers(int x) {
        this.gameFile.set("Map.MaxPlayers", x);
        this.gameFile.save();
    }

    public int getMinPlayers() {
        return this.gameFile.getInteger("Map.MinPlayers");
    }

    public int getMaxPlayers() {
        return this.gameFile.getInteger("Map.MaxPlayers");
    }

    public void setLocation(LocationType type, Location loc) {
        this.gameFile.set("Locations." + LocationType.toString(type) + ".world", loc.getWorld().getName());
        this.gameFile.set("Locations." + LocationType.toString(type) + ".x", loc.getX());
        this.gameFile.set("Locations." + LocationType.toString(type) + ".y", loc.getY());
        this.gameFile.set("Locations." + LocationType.toString(type) + ".z", loc.getZ());
        this.gameFile.set("Locations." + LocationType.toString(type) + ".pitch", Float.valueOf(loc.getPitch()));
        this.gameFile.set("Locations." + LocationType.toString(type) + ".yaw", Float.valueOf(loc.getYaw()));
        this.gameFile.save();
    }

    public Location getLocation(LocationType type) {
        String world = this.gameFile.getString("Locations." + LocationType.toString(type) + ".world");
        double x = this.gameFile.getDouble("Locations." + LocationType.toString(type) + ".x");
        double y = this.gameFile.getDouble("Locations." + LocationType.toString(type) + ".y");
        double z = this.gameFile.getDouble("Locations." + LocationType.toString(type) + ".z");
        float yaw = (float)this.gameFile.getDouble("Locations." + LocationType.toString(type) + ".yaw");
        float pitch = (float)this.gameFile.getDouble("Locations." + LocationType.toString(type) + ".pitch");
        if (world == null || world.isEmpty() || Bukkit.getWorld((String)world) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
    }

    public Game getGame() {
        return BowSpleef.get().getGM().getGameFromName(this.map);
    }

    public void deleteArena() {
        if (BowSpleef.get().getOptions().advancedRestore) {
            boolean mapExists = false;
            File target = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath(), this.map);
            if (target.isDirectory() && target.list().length > 0) {
                mapExists = true;
            }
            if (mapExists) {
                WorldUtils.deleteWorld(this.map);
            }
        } else {
            this.gameFile.delete();
        }
    }

    public boolean isSignSet() {
        return this.gameFile.getBoolean("Map.isSignSet");
    }

    public void loadMap() {
        boolean mapExists = false;
        File target = new File(BowSpleef.get().getServer().getWorldContainer().getAbsolutePath(), this.map);
        if (target.isDirectory() && target.list().length > 0) {
            mapExists = true;
        }
        if (mapExists) {
            WorldUtils.deleteWorld(this.map);
        }
        WorldUtils.copyWorld(new File(BowSpleef.get().getDataFolder() + File.separator + "maps" + File.separator + this.map + File.separator + this.map), target);
        WorldUtils.loadWorld(this.map);
    }

    public boolean hasCacheFile() {
        return new File(BowSpleef.get().getDataFolder().getAbsolutePath() + File.separator + "maps" + File.separator + this.getName() + File.separator + this.getName() + ".cache").exists();
    }

    public File getGameFolder() {
        return this.gameFolder;
    }

    public ArenaCuboid getCuboid() {
        return this.cuboid;
    }

    public ArenaRestore getRestore() {
        return this.restore;
    }

    public static enum LocationType {
        SPEC_SPAWN("SPEC_SPAWN"),
        PLAYER_SPAWN("PLAYER_SPAWN"),
        LOBBY("LOBBY"),
        LOW("LOW"),
        HIGH("HIGH");

        String type;

        private LocationType(String str) {
            this.type = str;
        }

        public String toString() {
            return this.type;
        }

        public static String toString(LocationType type) {
            return type.toString();
        }
    }
}

