/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game.structure;

import com.floodeer.bowspleef.BowSpleef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bukkit.Location;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class CachedArenaBlock
implements Serializable {
    private static final transient long serialVersionUID = -7502198689757408214L;
    private final Set<Location> blockLocations;

    public CachedArenaBlock(Set<Location> blockLocations) {
        this.blockLocations = blockLocations;
    }

    public CachedArenaBlock(CachedArenaBlock cachedArenaBlock) {
        this.blockLocations = cachedArenaBlock.getBlockLocations();
    }

    public boolean save(String file) {
        try {
            BukkitObjectOutputStream out = new BukkitObjectOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(file)));
            out.writeObject((Object)this);
            out.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void storeToCache(String name, Set<Location> blocks) {
        new CachedArenaBlock(blocks).save(BowSpleef.get().getDataFolder().getAbsolutePath() + File.separator + "maps" + File.separator + name + File.separator + name + ".cache");
    }

    public static Set<Location> loadFromCache(String name) {
        CachedArenaBlock cachedArenaBlock = new CachedArenaBlock(Objects.requireNonNull(CachedArenaBlock.load(BowSpleef.get().getDataFolder().getAbsolutePath() + File.separator + "maps" + File.separator + name + File.separator + name + ".cache")));
        return cachedArenaBlock.getBlockLocations();
    }

    public static CachedArenaBlock load(String file) {
        try {
            BukkitObjectInputStream in = new BukkitObjectInputStream((InputStream)new GZIPInputStream(new FileInputStream(file)));
            CachedArenaBlock data = (CachedArenaBlock)in.readObject();
            in.close();
            return data;
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<Location> getBlockLocations() {
        return this.blockLocations;
    }
}

