/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game.structure;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.structure.CachedArenaBlock;
import com.google.common.collect.Lists;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArenaRestore {
    private final Game game;
    private final boolean debug;
    private AtomicInteger total;

    public ArenaRestore(Game g) {
        this.debug = BowSpleef.get().getOptions().debug;
        this.game = g;
    }

    public void regenRaw() {
        BowSpleef.get().getLogger().info("BowSpleef detected a server shutdown, the restore system will force to regen the arena, this may freeze the thread for a few seconds.");
        LinkedList blocks = Lists.newLinkedList(BowSpleef.get().getOptions().cacheInMemory ? BowSpleef.get().getGM().getBlocks(this.game.getName()) : (Iterable)CachedArenaBlock.loadFromCache(this.game.getName()).stream().map(cur -> cur.getBlock().getState()).collect(Collectors.toList()));
        if (BowSpleef.get().getOptions().cacheInMemory) {
            blocks.forEach(cur -> cur.update(true));
        } else {
            blocks.forEach(cur -> cur.getLocation().getBlock().setType(Material.TNT));
        }
        this.game.setState(Game.GameState.PRE_GAME);
    }

    public void restoreMap() {
        boolean isCached = BowSpleef.get().getOptions().cacheInMemory ? BowSpleef.get().getGM().isCached(this.game.getName()) : this.game.getGameArena().hasCacheFile();
        this.game.setState(Game.GameState.RESTORING);
        this.game.getGameArena().updateSign();
        this.total = new AtomicInteger(0);
        if (this.debug) {
            BowSpleef.get().getLogger().info("Restoring arena " + this.game.getName());
        }
        final LinkedList blocks = Lists.newLinkedList(BowSpleef.get().getOptions().cacheInMemory ? BowSpleef.get().getGM().getBlocks(this.game.getName()) : (Iterable)CachedArenaBlock.loadFromCache(this.game.getName()).stream().map(cur -> cur.getBlock().getState()).collect(Collectors.toList()));
        final long MS = System.currentTimeMillis();
        blocks.removeIf(cur -> cur.getLocation().getBlock().getType() != Material.AIR);
        if (this.debug && isCached) {
            BowSpleef.get().getLogger().info("Found " + blocks.size() + " missing blocks.");
        }
        final Iterator bsit = blocks.iterator();
        new BukkitRunnable(){

            public void run() {
                for (int i = BowSpleef.get().getOptions().blocksInterval; i >= 0; --i) {
                    if (bsit.hasNext()) {
                        try {
                            BlockState bs = (BlockState)bsit.next();
                            if (BowSpleef.get().getOptions().cacheInMemory) {
                                bs.update(true);
                            } else {
                                bs.getLocation().getBlock().setType(Material.TNT);
                            }
                            bsit.remove();
                            ArenaRestore.this.total.incrementAndGet();
                        }
                        catch (ConcurrentModificationException bs) {}
                        continue;
                    }
                    long time = System.currentTimeMillis() - MS;
                    Game g = BowSpleef.get().getGM().recreateGame(ArenaRestore.this.game);
                    g.setState(Game.GameState.PRE_GAME);
                    if (ArenaRestore.this.debug) {
                        BowSpleef.get().getLogger().info(g.getName() + " was been recreated in " + time + "ms (" + time / 1000L + "s) with " + ArenaRestore.this.total.get() + " blocks!");
                    }
                    blocks.clear();
                    this.cancel();
                    break;
                }
            }
        }.runTaskTimer((Plugin)BowSpleef.get(), 5L, (long)BowSpleef.get().getOptions().iterDelay);
    }
}

