/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game.structure;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.structure.CachedArenaBlock;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;

public class ArenaCuboid {
    private final Location highPoints;
    private final Location lowPoints;
    private final Game game;

    public ArenaCuboid(Game game, Location startLoc, Location endLoc) {
        this.game = game;
        if (startLoc != null && endLoc != null) {
            boolean isCached;
            int lowx = Math.min(startLoc.getBlockX(), endLoc.getBlockX());
            int lowy = Math.min(startLoc.getBlockY(), endLoc.getBlockY());
            int lowz = Math.min(startLoc.getBlockZ(), endLoc.getBlockZ());
            int highx = Math.max(startLoc.getBlockX(), endLoc.getBlockX());
            int highy = Math.max(startLoc.getBlockY(), endLoc.getBlockY());
            int highz = Math.max(startLoc.getBlockZ(), endLoc.getBlockZ());
            this.highPoints = new Location(startLoc.getWorld(), (double)highx, (double)highy, (double)highz);
            this.lowPoints = new Location(startLoc.getWorld(), (double)lowx, (double)lowy, (double)lowz);
            boolean cacheInMemory = BowSpleef.get().getOptions().cacheInMemory;
            boolean bl = isCached = cacheInMemory ? BowSpleef.get().getGM().isCached(game.getName()) : game.getGameArena().hasCacheFile();
            if (!isCached) {
                if (BowSpleef.get().getOptions().debug) {
                    BowSpleef.get().getLogger().info("Arena " + game.getName() + " is not on cache. Calculating arena boundaries...");
                }
                LinkedList blocks = Lists.newLinkedList();
                int total = 0;
                int minx = this.lowPoints.getBlockX();
                int miny = this.lowPoints.getBlockY();
                int minz = this.lowPoints.getBlockZ();
                int maxx = this.highPoints.getBlockX();
                int maxy = this.highPoints.getBlockY();
                int maxz = this.highPoints.getBlockZ();
                for (int x = minx; x <= maxx; ++x) {
                    for (int y = miny; y <= maxy; ++y) {
                        for (int z = minz; z <= maxz; ++z) {
                            Block block = startLoc.getWorld().getBlockAt(x, y, z);
                            if (!block.getType().equals((Object)Material.TNT)) continue;
                            blocks.add(block.getState());
                            ++total;
                        }
                    }
                }
                if (cacheInMemory) {
                    BowSpleef.get().getGM().getBlockCache().put(game.getName(), blocks);
                } else {
                    CachedArenaBlock.storeToCache(game.getName(), (Set<Location>)ImmutableSet.copyOf((Collection)blocks.stream().map(BlockState::getLocation).collect(Collectors.toList())));
                }
                if (BowSpleef.get().getOptions().debug) {
                    BowSpleef.get().getLogger().info("Added " + game.getName() + " to the cache with a total of " + total + " blocks.");
                }
            }
        } else {
            this.highPoints = null;
            this.lowPoints = null;
        }
    }

    public boolean isAreaWithinArea(ArenaCuboid area) {
        return this.containsLoc(area.highPoints) && this.containsLoc(area.lowPoints);
    }

    public boolean containsLoc(Location loc) {
        if (loc == null || !loc.getWorld().equals(this.highPoints.getWorld())) {
            return false;
        }
        return this.lowPoints.getBlockX() <= loc.getBlockX() && this.highPoints.getBlockX() >= loc.getBlockX() && this.lowPoints.getBlockZ() <= loc.getBlockZ() && this.highPoints.getBlockZ() >= loc.getBlockZ() && this.lowPoints.getBlockY() <= loc.getBlockY() && this.highPoints.getBlockY() >= loc.getBlockY();
    }

    public boolean containsLocWithoutY(Location loc) {
        if (this.highPoints == null || this.lowPoints == null) {
            return false;
        }
        if (loc == null || !loc.getWorld().equals(this.highPoints.getWorld())) {
            return false;
        }
        return this.lowPoints.getBlockX() <= loc.getBlockX() && this.highPoints.getBlockX() >= loc.getBlockX() && this.lowPoints.getBlockZ() <= loc.getBlockZ() && this.highPoints.getBlockZ() >= loc.getBlockZ();
    }

    public boolean containsLocWithoutYD(Location loc) {
        if (this.highPoints == null || this.lowPoints == null) {
            return false;
        }
        if (loc == null || !loc.getWorld().equals(this.highPoints.getWorld())) {
            return false;
        }
        return this.lowPoints.getBlockX() <= loc.getBlockX() + 2 && this.highPoints.getBlockX() >= loc.getBlockX() - 2 && this.lowPoints.getBlockZ() <= loc.getBlockZ() + 2 && this.highPoints.getBlockZ() >= loc.getBlockZ() - 2;
    }

    public long getSize() {
        return Math.abs(this.getXSize() * this.getYSize() * this.getZSize());
    }

    public Location getRandomLocation() {
        World world = this.getWorld();
        Random randomGenerator = new Random();
        Location result = new Location(world, (double)this.highPoints.getBlockX(), (double)this.highPoints.getBlockY(), this.highPoints.getZ());
        if (this.getSize() > 1L) {
            double randomX = this.lowPoints.getBlockX() + randomGenerator.nextInt(this.getXSize());
            double randomY = this.lowPoints.getBlockY() + randomGenerator.nextInt(this.getYSize());
            double randomZ = this.lowPoints.getBlockZ() + randomGenerator.nextInt(this.getZSize());
            result = new Location(world, randomX, randomY, randomZ);
        }
        return result;
    }

    public Location getRandomLocationForMobs() {
        Location temp = this.getRandomLocation();
        return new Location(temp.getWorld(), (double)temp.getBlockX() + 0.5, (double)temp.getBlockY() + 0.5, (double)temp.getBlockZ() + 0.5);
    }

    public int getXSize() {
        return this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
    }

    public int getYSize() {
        return this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
    }

    public int getZSize() {
        return this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
    }

    public Location getHighLoc() {
        return this.highPoints;
    }

    public Location getLowLoc() {
        return this.lowPoints;
    }

    public World getWorld() {
        return this.highPoints.getWorld();
    }

    public String toString() {
        return "(" + this.lowPoints.getBlockX() + ", " + this.lowPoints.getBlockY() + ", " + this.lowPoints.getBlockZ() + ") to (" + this.highPoints.getBlockX() + ", " + this.highPoints.getBlockY() + ", " + this.highPoints.getBlockZ() + ")";
    }

    public LinkedList<BlockState> getBlocks() {
        return BowSpleef.get().getGM().getBlocks(this.game.getName());
    }
}

