/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game.player;

import com.floodeer.bowspleef.BowSpleef;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class GameScoreboard {
    private static final int MAX_SIZE = BowSpleef.ServerVersion.isLegacy() ? 16 : 64;
    private static final HashMap<UUID, GameScoreboard> players = new HashMap();
    private final Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    private final Objective sidebar = this.scoreboard.registerNewObjective("sidebar", "dummy");

    private GameScoreboard(Player player) {
        this.sidebar.setDisplaySlot(DisplaySlot.SIDEBAR);
        for (int i = 1; i <= 15; ++i) {
            Team team = this.scoreboard.registerNewTeam("SLOT_" + i);
            team.addEntry(this.genEntry(i));
        }
        player.setScoreboard(this.scoreboard);
        players.put(player.getUniqueId(), this);
    }

    public static HashMap<UUID, GameScoreboard> getScoreboards() {
        return players;
    }

    public static boolean hasScore(Player player) {
        return players.containsKey(player.getUniqueId());
    }

    public static GameScoreboard createScore(Player player) {
        return new GameScoreboard(player);
    }

    public static GameScoreboard getByPlayer(Player player) {
        return players.get(player.getUniqueId());
    }

    public static GameScoreboard getByUUID(UUID uuid) {
        return players.get(uuid);
    }

    public static GameScoreboard removeScore(Player player) {
        return players.remove(player.getUniqueId());
    }

    public void setTitle(String title) {
        this.sidebar.setDisplayName((title = ChatColor.translateAlternateColorCodes((char)'&', (String)title)).length() > 32 ? title.substring(0, 32) : title);
    }

    public void setSlot(int slot, String text) {
        Team team = this.scoreboard.getTeam("SLOT_" + slot);
        String entry = this.genEntry(slot);
        if (!this.scoreboard.getEntries().contains(entry)) {
            this.sidebar.getScore(entry).setScore(slot);
        }
        String pre = this.getFirstSplit(text);
        String suf = this.getFirstSplit(ChatColor.getLastColors((String)pre) + this.getSecondSplit(text));
        team.setPrefix(pre);
        team.setSuffix(suf);
    }

    public void removeSlot(int slot) {
        String entry = this.genEntry(slot);
        if (this.scoreboard.getEntries().contains(entry)) {
            this.scoreboard.resetScores(entry);
        }
    }

    public void setSlotsFromList(List<String> list) {
        while (list.size() > 15) {
            list.remove(list.size() - 1);
        }
        int slot = list.size();
        if (slot < 15) {
            for (int i = slot + 1; i <= 15; ++i) {
                this.removeSlot(i);
            }
        }
        for (String line : list) {
            this.setSlot(slot, line);
            --slot;
        }
    }

    private String genEntry(int slot) {
        return ChatColor.values()[slot].toString();
    }

    private String getFirstSplit(String s) {
        return s.length() > MAX_SIZE ? s.substring(0, MAX_SIZE) : s;
    }

    private String getSecondSplit(String s) {
        if (s.length() > (BowSpleef.ServerVersion.isLegacy() ? 32 : MAX_SIZE)) {
            s = s.substring(0, BowSpleef.ServerVersion.isLegacy() ? 32 : MAX_SIZE);
        }
        return s.length() > MAX_SIZE ? s.substring(MAX_SIZE) : "";
    }

    public void setPlayerTeam(Player player, String teamName) {
        for (Team team : this.scoreboard.getTeams()) {
            team.removePlayer((OfflinePlayer)player);
        }
        Team team = null;
        if (this.scoreboard.getTeam(teamName) == null) {
            team = this.scoreboard.registerNewTeam(teamName);
            if (team.getName().equalsIgnoreCase("spectator")) {
                team.setPrefix("" + ChatColor.RED);
            } else {
                team.setPrefix("" + ChatColor.GRAY);
            }
        } else {
            team = this.scoreboard.getTeam(teamName);
        }
        team.addEntry(player.getName());
        this.scoreboard.getTeam(teamName).addPlayer((OfflinePlayer)player);
    }

    public void removeFromTeam(Player player) {
        for (Team team : this.scoreboard.getTeams()) {
            if (!team.hasEntry(player.getName())) continue;
            team.removePlayer((OfflinePlayer)player);
        }
    }
}

