/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game.player;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.GameTeam;
import com.floodeer.bowspleef.manager.PlayerInventory;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public class GamePlayer {
    private final Player player;
    private final String name;
    private UUID uuid;
    private Game game;
    private GameTeam gameTeam;
    private boolean spectator;
    private PlayerInventory playerInventory;
    private int tripleShots;
    private int doubleJumps;
    private double earnedCoins;
    private int purchasedDoubleJumps;
    private int purchasedTripleShots;
    private int trail;
    private int effect;
    private int gamesPlayed;
    private int wins;
    private int losses;
    private int balance;
    private int arrowsShot;
    private boolean fullyLoaded;

    public GamePlayer(UUID uuid) {
        this.uuid = uuid;
        this.player = Bukkit.getPlayer((UUID)uuid);
        this.name = this.player.getName();
        BowSpleef.get().getStorage().loadPlayer(uuid.toString(), this);
    }

    public GamePlayer(Player player) {
        this.player = player;
        this.name = player.getName();
        this.uuid = player.getUniqueId();
        BowSpleef.get().getStorage().loadPlayer(player.getUniqueId().toString(), this);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public boolean isInGame() {
        return this.game != null;
    }

    public int getTripleShots() {
        return this.tripleShots;
    }

    public void setTripleShots(int tripleShots) {
        this.tripleShots = tripleShots;
    }

    public String getName() {
        return this.name;
    }

    public int getGamesPlayed() {
        return this.gamesPlayed;
    }

    public void setGamesPlayed(int gamesPlayed) {
        this.gamesPlayed = gamesPlayed;
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public void setLosses(int losses) {
        this.losses = losses;
    }

    public int getArrowsShot() {
        return this.arrowsShot;
    }

    public void setArrowsShot(int arrowsShot) {
        this.arrowsShot = arrowsShot;
    }

    public int getDoubleJumps() {
        return this.doubleJumps;
    }

    public void setDoubleJumps(int doubleJumps) {
        this.doubleJumps = doubleJumps;
    }

    public int getBalance() {
        return this.balance;
    }

    public void setBalance(int balance) {
        this.balance = balance;
    }

    public GameTeam getTeam() {
        return this.gameTeam;
    }

    public void setTeam(GameTeam gameTeam) {
        this.gameTeam = gameTeam;
    }

    public boolean isSpectator() {
        return this.spectator;
    }

    public void setSpectator(boolean spectator) {
        this.spectator = spectator;
    }

    public double getEarnedCoins() {
        return this.earnedCoins;
    }

    public void setEarnedCoins(double earnedCoins) {
        this.earnedCoins = earnedCoins;
    }

    public void addMoney(int amount) {
        if (BowSpleef.get().getOptions().isVaultEnabled) {
            BowSpleef.econ.depositPlayer((OfflinePlayer)this.getPlayer(), (double)amount);
        } else {
            this.setBalance(this.getBalance() + amount);
            if (this.getBalance() < 0) {
                this.setBalance(0);
            }
        }
    }

    public void removeMoney(int amount) {
        if (BowSpleef.get().getOptions().isVaultEnabled) {
            BowSpleef.econ.withdrawPlayer((OfflinePlayer)this.getPlayer(), (double)amount);
        } else {
            this.setBalance(this.getBalance() - amount);
        }
    }

    public void setMoney(int amount) {
        this.setBalance(amount);
    }

    public int getMoney() {
        if (BowSpleef.get().getOptions().isVaultEnabled) {
            return (int)BowSpleef.econ.getBalance((OfflinePlayer)this.getPlayer());
        }
        return this.getBalance();
    }

    public void clearInventory(boolean save) {
        if (save && BowSpleef.get().getOptions().saveInventory) {
            this.playerInventory = new PlayerInventory(this.getPlayer());
        }
        this.getPlayer().getInventory().clear();
        this.getPlayer().getInventory().setArmorContents(null);
        for (PotionEffect potions : this.getPlayer().getActivePotionEffects()) {
            this.getPlayer().removePotionEffect(potions.getType());
        }
        this.getPlayer().setLevel(0);
        this.getPlayer().setFireTicks(0);
        this.getPlayer().setExp(0.0f);
        this.getPlayer().setFoodLevel(20);
        this.getPlayer().setHealth(this.getPlayer().getMaxHealth());
        this.getPlayer().updateInventory();
    }

    public void restoreInventory() {
        if (this.playerInventory != null) {
            for (PotionEffect potions : this.getPlayer().getActivePotionEffects()) {
                this.getPlayer().removePotionEffect(potions.getType());
            }
            this.playerInventory.restore();
            this.playerInventory = null;
        }
    }

    public int getPurchasedDoubleJumps() {
        return this.purchasedDoubleJumps;
    }

    public int getPurchasedTripleShots() {
        return this.purchasedTripleShots;
    }

    public void setPurchasedDoubleJumps(int purchasedDoubleJumps) {
        this.purchasedDoubleJumps = purchasedDoubleJumps;
    }

    public void setPurchasedTripleShots(int purchasedTripleShots) {
        this.purchasedTripleShots = purchasedTripleShots;
    }

    public void setEffect(int effect) {
        this.effect = effect;
    }

    public int getTrail() {
        return this.trail;
    }

    public int getEffect() {
        return this.effect;
    }

    public void setTrail(int trail) {
        this.trail = trail;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    public static GamePlayer get(UUID uuid) {
        return BowSpleef.get().getPM().getPlayer(uuid);
    }

    public static GamePlayer get(Player player) {
        return BowSpleef.get().getPM().getPlayer(player.getUniqueId());
    }
}

