/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game;

import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class GameTeam {
    private Game IGame;
    private String name;
    private ChatColor color;
    private HashMap<Player, PlayerState> players = Maps.newHashMap();
    private List<Location> spawns;
    private boolean visible = true;
    private boolean teamEntityAlive;
    private int teamHealth = 0;

    public GameTeam(Game game, String name, ChatColor color2, List<Location> list) {
        this.setGame(game);
        this.name = name;
        this.color = color2;
        this.spawns = list;
        this.teamEntityAlive = true;
    }

    public String getName() {
        return this.name;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public List<Location> getSpawns() {
        return this.spawns;
    }

    public void addPlayer(Player player) {
        this.players.put(player, PlayerState.IN);
        Bukkit.getOnlinePlayers().stream().filter(cur -> !cur.equals(player)).forEach(other -> {
            other.hidePlayer(player);
            other.showPlayer(player);
        });
        GamePlayer.get(player).setTeam(this);
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
        GamePlayer.get(player).setTeam(null);
        Bukkit.getOnlinePlayers().stream().filter(cur -> !cur.equals(player)).forEach(other -> {
            other.hidePlayer(player);
            other.showPlayer(player);
        });
    }

    public Player getPlayer(String name) {
        for (Player player : this.players.keySet()) {
            if (!player.getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    public boolean hasPlayer(Player player) {
        return this.players.containsKey(player);
    }

    public boolean hasPlayer(String name, boolean alive) {
        for (Player player : this.players.keySet()) {
            if (!player.getName().equals(name) || alive && (!alive || this.players.get(player) != PlayerState.IN)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.players.size();
    }

    public void setPlayerState(Player player, PlayerState state) {
        if (player == null) {
            return;
        }
        this.players.put(player, state);
        if (state == PlayerState.OUT) {
            Bukkit.getOnlinePlayers().stream().filter(cur -> !cur.equals(player)).forEach(other -> other.hidePlayer(player));
        } else {
            Bukkit.getOnlinePlayers().stream().filter(cur -> !cur.equals(player)).forEach(other -> {
                other.hidePlayer(player);
                other.showPlayer(player);
            });
        }
    }

    public boolean isTeamAlive() {
        for (PlayerState state : this.players.values()) {
            if (state != PlayerState.IN) continue;
            return true;
        }
        return false;
    }

    public List<Player> getAlivePlayers() {
        return this.players.keySet().stream().filter(player -> this.players.get(player) == PlayerState.IN).collect(Collectors.toList());
    }

    public List<Player> getDeathPlayers() {
        return this.players.keySet().stream().filter(player -> this.players.get(player) == PlayerState.OUT).collect(Collectors.toList());
    }

    public List<Player> getPlayers() {
        return Lists.newArrayList(this.players.keySet());
    }

    public String getFormattedName() {
        return this.getColor() + "\u00a7l" + this.getName();
    }

    public boolean isAlive(Player player) {
        if (!this.players.containsKey(player)) {
            return false;
        }
        return this.players.get(player) == PlayerState.IN;
    }

    public void getColor(ChatColor color) {
        this.color = color;
    }

    public void getName(String name) {
        this.name = name;
    }

    public byte getColorData() {
        if (this.getColor() == ChatColor.WHITE) {
            return 0;
        }
        if (this.getColor() == ChatColor.GOLD) {
            return 1;
        }
        if (this.getColor() == ChatColor.LIGHT_PURPLE) {
            return 2;
        }
        if (this.getColor() == ChatColor.AQUA) {
            return 3;
        }
        if (this.getColor() == ChatColor.YELLOW) {
            return 4;
        }
        if (this.getColor() == ChatColor.GREEN) {
            return 5;
        }
        if (this.getColor() == ChatColor.DARK_GRAY) {
            return 7;
        }
        if (this.getColor() == ChatColor.GRAY) {
            return 8;
        }
        if (this.getColor() == ChatColor.DARK_AQUA) {
            return 9;
        }
        if (this.getColor() == ChatColor.DARK_GRAY) {
            return 10;
        }
        if (this.getColor() == ChatColor.BLUE) {
            return 11;
        }
        if (this.getColor() == ChatColor.DARK_BLUE) {
            return 11;
        }
        if (this.getColor() == ChatColor.DARK_GREEN) {
            return 13;
        }
        if (this.getColor() == ChatColor.RED) {
            return 14;
        }
        return 15;
    }

    public Color getColorBase() {
        if (this.getColor() == ChatColor.WHITE) {
            return Color.WHITE;
        }
        if (this.getColor() == ChatColor.GOLD) {
            return Color.ORANGE;
        }
        if (this.getColor() == ChatColor.DARK_GREEN) {
            return Color.PURPLE;
        }
        if (this.getColor() == ChatColor.AQUA) {
            return Color.AQUA;
        }
        if (this.getColor() == ChatColor.YELLOW) {
            return Color.YELLOW;
        }
        if (this.getColor() == ChatColor.GREEN) {
            return Color.GREEN;
        }
        if (this.getColor() == ChatColor.DARK_GREEN) {
            return Color.GRAY;
        }
        if (this.getColor() == ChatColor.GRAY) {
            return Color.GRAY;
        }
        if (this.getColor() == ChatColor.DARK_AQUA) {
            return Color.AQUA;
        }
        if (this.getColor() == ChatColor.DARK_PURPLE) {
            return Color.PURPLE;
        }
        if (this.getColor() == ChatColor.BLUE) {
            return Color.BLUE;
        }
        if (this.getColor() == ChatColor.DARK_BLUE) {
            return Color.BLUE;
        }
        if (this.getColor() == ChatColor.DARK_GREEN) {
            return Color.GREEN;
        }
        if (this.getColor() == ChatColor.RED) {
            return Color.RED;
        }
        return Color.WHITE;
    }

    public void setSpawns(ArrayList<Location> spawns) {
        this.spawns = spawns;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public Game getGame() {
        return this.IGame;
    }

    public void setGame(Game IGame) {
        this.IGame = IGame;
    }

    public int getTeamHealth() {
        return this.teamHealth;
    }

    public void setTeamHealth(int teamHealth) {
        this.teamHealth = teamHealth;
    }

    public boolean isTeamEntityAlive() {
        return this.teamEntityAlive;
    }

    public void setTeamEntityAlive(boolean teamEntityAlive) {
        this.teamEntityAlive = teamEntityAlive;
    }

    public static enum PlayerState {
        IN("In", ChatColor.GRAY),
        OUT("Out", ChatColor.RED);

        private String name;
        private ChatColor color;

        private PlayerState(String name, ChatColor color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public ChatColor getColor() {
            return this.color;
        }
    }
}

