/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.util.Util;
import com.floodeer.bowspleef.util.XMaterial;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GameSpectator {
    private static final int menuSlotsPerRow = 9;
    private static final int menuSize = 54;
    private static final String menuName = Util.colorString(BowSpleef.get().getLanguage().spectatorMenu, new Player[0]);

    public static void showGameSpectator(GamePlayer gamePlayer) {
        int rowCount;
        Game game = gamePlayer.getGame();
        List availablePlayers = game.getAlive().stream().filter(Objects::nonNull).map(GamePlayer::getPlayer).collect(Collectors.toList());
        for (rowCount = 9; rowCount < game.getMaxPlayers() && rowCount < 54; rowCount += 9) {
        }
        BowSpleef.get().getIconManager().create(gamePlayer.getPlayer(), menuName, rowCount, event -> {
            String name = ChatColor.stripColor((String)event.getName());
            Player player = BowSpleef.get().getServer().getPlayer(name);
            if (player == null) {
                return;
            }
            event.setWillClose(true);
            event.setWillDestroy(true);
            if (BowSpleef.get().getPM().getPlayer(player.getUniqueId()).isInGame() && gamePlayer.getPlayer().getWorld().getName().equalsIgnoreCase(player.getWorld().getName())) {
                gamePlayer.getPlayer().teleport(player.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            BowSpleef.get().getIconManager().destroy(gamePlayer.getPlayer());
        });
        for (int iii = 0; iii < availablePlayers.size() && iii < 54; ++iii) {
            Player player = (Player)availablePlayers.get(iii);
            if (player == null) continue;
            ItemStack playerhead = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial(), 1, 3);
            SkullMeta meta = (SkullMeta)playerhead.getItemMeta();
            meta.setOwner(player.getName());
            playerhead.setItemMeta((ItemMeta)meta);
            BowSpleef.get().getIconManager().setOption(gamePlayer.getPlayer(), iii, playerhead, ChatColor.AQUA + player.getName(), "");
        }
        if (gamePlayer.getPlayer() != null) {
            BowSpleef.get().getIconManager().show(gamePlayer.getPlayer());
        }
    }
}

