/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.game.Game;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.util.ItemFactory;
import com.floodeer.bowspleef.util.Util;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GameJoinMenu {
    private static final int menuSlotsPerRow = 9;
    private static final int menuSize = 54;
    private static final String menuName = Util.colorString(BowSpleef.get().getLanguage().joinGames, new Player[0]);

    public static void showGameJoinMenu(GamePlayer gamePlayer) {
        int rowCount;
        ArrayList games = new ArrayList();
        BowSpleef.get().getGM().getGames().stream().filter(g -> g.getState() == Game.GameState.PRE_GAME || g.getState() == Game.GameState.STARTING).forEach(games::add);
        for (rowCount = 9; rowCount < games.size() && rowCount < 54; rowCount += 9) {
        }
        BowSpleef.get().getIconManager().create(gamePlayer.getPlayer(), menuName, rowCount, event -> {
            String name = ChatColor.stripColor((String)event.getName());
            Game game = BowSpleef.get().getGM().getGameFromName(name);
            if (game == null) {
                event.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().started, new Player[0]));
                return;
            }
            event.setWillClose(true);
            event.setWillDestroy(true);
            if (game.getState() != Game.GameState.PRE_GAME && game.getState() != Game.GameState.STARTING) {
                event.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().started, new Player[0]));
                return;
            }
            game.addPlayer(gamePlayer);
            BowSpleef.get().getIconManager().destroy(gamePlayer.getPlayer());
        });
        for (int iii = 0; iii < games.size() && iii < 54; ++iii) {
            Game game = (Game)games.get(iii);
            if (game == null) continue;
            ItemStack available = ItemFactory.parse(BowSpleef.get().getOptions().joinArenaItem);
            ItemFactory.name(available, ChatColor.GREEN + game.getName(), ItemFactory.applyLorePlaceholder(game, BowSpleef.get().getLanguage().joinLore, gamePlayer.getPlayer()));
            BowSpleef.get().getIconManager().setOption(gamePlayer.getPlayer(), iii, available);
        }
        if (gamePlayer.getPlayer() != null) {
            BowSpleef.get().getIconManager().show(gamePlayer.getPlayer());
        }
    }
}

