/*
 * Decompiled with CFR 0.152.
 */
package com.floodeer.bowspleef.game;

import com.floodeer.bowspleef.BowSpleef;
import com.floodeer.bowspleef.achievement.AchievementType;
import com.floodeer.bowspleef.achievement.PlayerAchievement;
import com.floodeer.bowspleef.api.GameEndEvent;
import com.floodeer.bowspleef.api.GameStartEvent;
import com.floodeer.bowspleef.game.GameTeam;
import com.floodeer.bowspleef.game.player.GamePlayer;
import com.floodeer.bowspleef.game.player.GameScoreboard;
import com.floodeer.bowspleef.game.structure.GameArena;
import com.floodeer.bowspleef.util.ItemFactory;
import com.floodeer.bowspleef.util.Runner;
import com.floodeer.bowspleef.util.Util;
import com.floodeer.bowspleef.util.XMaterial;
import com.floodeer.bowspleef.util.update.UpdateEvent;
import com.floodeer.bowspleef.util.update.UpdateType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class Game
implements Listener {
    private final String name;
    private int gameTime;
    private int preStart;
    private int gracePeriod;
    private boolean canStart;
    private boolean isInGracePeriod;
    private GameState state;
    private GameArena gameArena;
    private Map<GamePlayer, Integer> places;
    private Map<GamePlayer, Integer> shotsFired;
    private List<GameTeam> teams;
    private List<GamePlayer> players;

    public Game(String name, boolean load) {
        this.name = name;
        this.gameArena = new GameArena(name);
        this.setState(GameState.RESTORING);
        if (load) {
            this.load();
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)BowSpleef.get(), () -> this.getGameArena().updateSign(), 60L);
        }
    }

    public void load() {
        this.canStart = true;
        this.isInGracePeriod = false;
        this.gameTime = BowSpleef.get().getOptions().gameLength;
        this.preStart = BowSpleef.get().getOptions().preStartCountdown;
        this.gracePeriod = BowSpleef.get().getOptions().gracePeriod;
        this.places = Maps.newHashMap();
        this.shotsFired = Maps.newHashMap();
        this.teams = Lists.newArrayList();
        this.players = Lists.newArrayList();
        this.setState(GameState.PRE_GAME);
        this.teams.add(new GameTeam(this, "Alive", ChatColor.GRAY, null));
        this.teams.add(new GameTeam(this, "Dead", ChatColor.RED, null));
        this.getGameArena().load(this);
        BowSpleef.get().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)BowSpleef.get());
    }

    @EventHandler
    public void onGameUpdate(UpdateEvent event) {
        if (event.getType() != UpdateType.SEC) {
            return;
        }
        if (this.getState() == GameState.IN_GAME) {
            if (!this.isInGracePeriod) {
                --this.gameTime;
            }
            this.updateGameScoreboard();
            this.checkForWinner();
        } else if (this.getState() == GameState.PRE_GAME || this.getState() == GameState.STARTING) {
            this.updateLobbyScoreboard();
        }
    }

    public void checkForStart() {
        if (this.getState() == GameState.IN_GAME || this.getState() == GameState.ENDING || this.getState() == GameState.RESTORING) {
            return;
        }
        if (this.getPlayers().size() >= this.getMinPlayers()) {
            this.canStart = false;
            this.setState(GameState.STARTING);
            new BukkitRunnable(){

                public void run() {
                    if (Game.this.getPlayers().size() < Game.this.getMinPlayers()) {
                        Game.this.setState(GameState.PRE_GAME);
                        Game.this.preStart = BowSpleef.get().getOptions().preStartCountdown;
                        Game.this.broadcast(BowSpleef.get().getLanguage().countdownCanceled);
                        Game.this.canStart = true;
                        Game.this.getGameArena().updateSign();
                        this.cancel();
                        return;
                    }
                    if (Game.this.state == GameState.IN_GAME) {
                        this.cancel();
                        return;
                    }
                    --Game.this.preStart;
                    if (Game.this.preStart % 5 == 0 || Game.this.preStart <= 5 && Game.this.preStart > 0) {
                        Game.this.broadcast(BowSpleef.get().getLanguage().starting.replace("%time%", String.valueOf(Game.this.preStart)));
                    }
                    if (Game.this.preStart == 0) {
                        this.cancel();
                        Game.this.startGraceTime();
                    }
                }
            }.runTaskTimer((Plugin)BowSpleef.get(), 0L, 20L);
        }
    }

    public void startGraceTime() {
        this.gameTime = BowSpleef.get().getOptions().gameLength;
        this.isInGracePeriod = true;
        this.setState(GameState.IN_GAME);
        this.getPlayers().forEach(gp -> {
            gp.setDoubleJumps(gp.getDoubleJumps());
            gp.setDoubleJumps(gp.getPurchasedDoubleJumps() + BowSpleef.get().getOptions().pergameDJ);
            gp.setPurchasedDoubleJumps(0);
            gp.getPlayer().teleport(this.getGameArena().getLocation(GameArena.LocationType.PLAYER_SPAWN));
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)BowSpleef.get(), () -> {
                gp.clearInventory(false);
                gp.getPlayer().getInventory().addItem(new ItemStack[]{ItemFactory.createBowSpleefBow()});
                gp.getPlayer().getInventory().setItem(9, ItemFactory.create(XMaterial.ARROW.parseMaterial()));
                if (gp.getEffect() > 0 && ItemFactory.parse(BowSpleef.get().getEC().getItem(gp.getEffect())) != null) {
                    gp.getPlayer().getInventory().setHelmet(ItemFactory.parse(BowSpleef.get().getEC().getItem(gp.getEffect())));
                }
            }, 10L);
        });
        new BukkitRunnable(){

            public void run() {
                if (Game.this.getState() != GameState.IN_GAME && Game.this.getState() != GameState.STARTING) {
                    this.cancel();
                    return;
                }
                --Game.this.gracePeriod;
                if (Game.this.gracePeriod > 0) {
                    Game.this.broadcast(BowSpleef.get().getLanguage().graceCountdown.replace("%time%", String.valueOf(Game.this.gracePeriod)));
                }
                if (Game.this.gracePeriod == 0) {
                    Game.this.start();
                    this.cancel();
                }
                Util.playSound(Game.this.get(), BowSpleef.get().getOptions().graceTimeSound);
                Game.this.getPlayers().stream().map(GamePlayer::getPlayer).forEach(player -> Util.sendTitle(player, 0, 20, 0, BowSpleef.get().getLanguage().graceTimeTitle.replace("%time%", Integer.toString(Game.this.gracePeriod)), BowSpleef.get().getLanguage().graceTimeSubTitle.replace("%time%", Integer.toString(Game.this.gracePeriod))));
            }
        }.runTaskTimer((Plugin)BowSpleef.get(), 0L, 20L);
    }

    public void start() {
        BowSpleef.get().getServer().getPluginManager().callEvent((Event)new GameStartEvent(this));
        this.gameTime = BowSpleef.get().getOptions().gameLength;
        this.broadcast(BowSpleef.get().getLanguage().startedBroadcast);
        this.isInGracePeriod = false;
        GameScoreboard.getScoreboards().keySet().stream().filter(cur -> GamePlayer.get(cur).getGame().equals(this)).forEach(cur -> {
            GameScoreboard scoreboard = GameScoreboard.getByUUID(cur);
            this.getPlayers().forEach(players -> scoreboard.setPlayerTeam(players.getPlayer(), "Alive"));
        });
    }

    public void checkForWinner() {
        if (this.getAlivePlayers() <= 1) {
            GamePlayer winner;
            this.endGame(winner, false, (winner = (GamePlayer)this.getAlive().stream().findFirst().orElse(null)) == null);
        } else if (this.gameTime <= 0) {
            this.endGame(null, false, true);
        }
    }

    private void updateLobbyScoreboard() {
        this.getPlayers().forEach(gp -> {
            GameScoreboard scoreboard;
            if (!GameScoreboard.hasScore(gp.getPlayer())) {
                scoreboard = GameScoreboard.createScore(gp.getPlayer());
                scoreboard.setTitle(BowSpleef.get().getLanguage().lobbyBoardTitle);
            } else {
                scoreboard = GameScoreboard.getByPlayer(gp.getPlayer());
            }
            ArrayList lines = Lists.newArrayList();
            for (String line : BowSpleef.get().getLanguage().lobbyBoard) {
                line = StringUtils.replaceEach((String)line, (String[])new String[]{"%players%", "%minplayers%", "%maxplayers%", "%state%", "%capitalize_state%", "%balance%", "%double_jumps%", "%triple_shots%", "%shots_fired%", "%mapname%"}, (String[])new String[]{Integer.toString(this.getPlayers().size()), Integer.toString(this.getMinPlayers()), Integer.toString(this.getMaxPlayers()), Util.colorize(this.getState().toString()), Util.colorize(WordUtils.capitalize((String)this.getState().toString())), Integer.toString(gp.getBalance()), Integer.toString(gp.getDoubleJumps()), Integer.toString(gp.getTripleShots()), Integer.toString(this.shotsFired.get(gp)), this.name});
                line = Util.colorString(line, new Player[0]);
                line = Util.setPlaceholders(gp.getPlayer(), line);
                if (line.equalsIgnoreCase(" ")) {
                    line = Util.createSpacer();
                }
                lines.add(line);
            }
            scoreboard.setSlotsFromList(lines);
        });
    }

    private void updateGameScoreboard() {
        this.getPlayers().forEach(gp -> {
            GameScoreboard scoreboard;
            if (!GameScoreboard.hasScore(gp.getPlayer())) {
                scoreboard = GameScoreboard.createScore(gp.getPlayer());
                scoreboard.setTitle(BowSpleef.get().getLanguage().gameBoardTitle);
            } else {
                scoreboard = GameScoreboard.getByPlayer(gp.getPlayer());
            }
            ArrayList lines = Lists.newArrayList();
            Date date = new Date((long)this.gameTime * 1000L);
            String format = new SimpleDateFormat("mm:ss").format(date);
            for (String line : BowSpleef.get().getLanguage().gameBoard) {
                line = StringUtils.replaceEach((String)line, (String[])new String[]{"%formatted_time_left%", "%raw_timer%", "%double_jumps%", "%triple_shots%", "%alive%", "%shots_fired%", "%earned_coins%", "%mapname%", "%spectators%"}, (String[])new String[]{format, Integer.toString(this.gameTime), Integer.toString(gp.getDoubleJumps()), Integer.toString(gp.getTripleShots()), Integer.toString(this.getAlivePlayers()), Integer.toString(this.shotsFired.get(gp)), Double.toString(gp.getEarnedCoins()), this.name, Integer.toString(this.getSpectatorsCount())});
                line = Util.colorString(line, new Player[0]);
                line = Util.setPlaceholders(gp.getPlayer(), line);
                if (line.equalsIgnoreCase(" ")) {
                    line = Util.createSpacer();
                }
                lines.add(line);
            }
            scoreboard.setSlotsFromList(lines);
        });
    }

    public void addPlayer(GamePlayer gp) {
        Player p = gp.getPlayer();
        p.setAllowFlight(false);
        gp.setGame(this);
        gp.setDoubleJumps(BowSpleef.get().getOptions().pergameDJ);
        gp.setTripleShots(BowSpleef.get().getOptions().tripleShot);
        gp.setEarnedCoins(0.0);
        gp.setPurchasedDoubleJumps(0);
        gp.setPurchasedTripleShots(0);
        this.getPlayers().add(gp);
        this.getTeams().get(0).addPlayer(p);
        this.shotsFired.put(gp, 0);
        p.teleport(this.getGameArena().getLocation(GameArena.LocationType.LOBBY));
        this.broadcast(BowSpleef.get().getLanguage().joinMessage.replaceAll("%player%", p.getName()).replaceAll("%players%", String.valueOf(this.getPlayers().size())).replaceAll("%minplayers%", String.valueOf(this.getMinPlayers())).replaceAll("%maxplayers%", String.valueOf(this.getMaxPlayers())));
        Runner.make(BowSpleef.get()).delay(5).run(() -> {
            if (this.canStart) {
                this.checkForStart();
            }
            gp.clearInventory(BowSpleef.get().getOptions().saveInventory);
            p.setGameMode(GameMode.ADVENTURE);
            if (!BowSpleef.get().getOptions().disableShop) {
                p.getInventory().setItem(BowSpleef.get().getOptions().shopItemSlot, ItemFactory.parse(BowSpleef.get().getOptions().shopItemType));
            }
            p.getInventory().setItem(BowSpleef.get().getOptions().leaveItemSlot, ItemFactory.parse(BowSpleef.get().getOptions().leaveItemType));
            this.getGameArena().updateSign();
        });
    }

    public void removePlayer(GamePlayer gp, boolean force, boolean leave) {
        gp.clearInventory(false);
        gp.setSpectator(false);
        gp.getPlayer().setGameMode(GameMode.SURVIVAL);
        BowSpleef.get().getServer().getOnlinePlayers().forEach(p -> p.showPlayer(gp.getPlayer()));
        gp.getPlayer().setAllowFlight(false);
        gp.getPlayer().setFlying(false);
        Util.toggleCollisions(gp.getPlayer(), true);
        gp.setGame(null);
        if (!force && this.getState() == GameState.IN_GAME && !gp.isSpectator()) {
            gp.setLosses(gp.getLosses() + 1);
            gp.setGamesPlayed(gp.getGamesPlayed() + 1);
            PlayerAchievement.check(gp, AchievementType.GAMES, gp.getGamesPlayed());
        }
        if (!force) {
            if (this.getState() == GameState.PRE_GAME || this.getState() == GameState.STARTING) {
                this.broadcast(BowSpleef.get().getLanguage().quitMessage.replaceAll("%player%", gp.getPlayer().getName()).replaceAll("%players%", String.valueOf(this.getPlayers().size())).replaceAll("%minplayers%", String.valueOf(this.getMinPlayers())).replaceAll("%maxplayers%", String.valueOf(this.getMaxPlayers())));
            }
            this.getPlayers().remove(gp);
        }
        if (BowSpleef.get().getOptions().isBungeeCord) {
            Util.connect(gp.getPlayer(), BowSpleef.get().getOptions().bungeeLobby);
        } else {
            Util.sendToSpawn(gp.getPlayer());
        }
        GameScoreboard.getScoreboards().keySet().stream().filter(cur -> GamePlayer.get(cur) != null && GamePlayer.get(cur).getGame() != null && GamePlayer.get(cur).getGame().equals(this)).forEach(cur -> {
            GameScoreboard scoreboard = GameScoreboard.getByUUID(cur);
            this.getPlayers().forEach(players -> scoreboard.removeFromTeam(gp.getPlayer()));
        });
        GameScoreboard.removeScore(gp.getPlayer());
        gp.getPlayer().setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        gp.restoreInventory();
    }

    public void endGame(GamePlayer winner, boolean shutdown, boolean draw) {
        this.setState(GameState.ENDING);
        this.getGameArena().updateSign();
        BowSpleef.get().getServer().getPluginManager().callEvent((Event)new GameEndEvent(winner, this));
        if (winner == null) {
            if (draw) {
                this.getPlayers().forEach(gp -> {
                    gp.addMoney(BowSpleef.get().getOptions().coinsPerParticipation);
                    gp.setEarnedCoins(gp.getEarnedCoins() + (double)BowSpleef.get().getOptions().coinsPerParticipation);
                    BowSpleef.get().getLanguage().gameEnd.forEach(msg -> {
                        msg = Util.colorString(msg, new Player[0]);
                        msg = msg.replaceAll("%winner%", BowSpleef.get().getLanguage().nobody);
                        msg = msg.replaceAll("%coins%", Double.toString(gp.getEarnedCoins()));
                        gp.getPlayer().sendMessage(Util.colorString(msg, gp.getPlayer()));
                    });
                });
                this.resetArena(false);
                return;
            }
            this.shutdown(!shutdown);
            return;
        }
        winner.setWins(winner.getWins() + 1);
        winner.setGamesPlayed(winner.getGamesPlayed() + 1);
        winner.addMoney(BowSpleef.get().getOptions().coinsPerWin);
        winner.setEarnedCoins(winner.getEarnedCoins() + (double)BowSpleef.get().getOptions().coinsPerWin);
        PlayerAchievement.check(winner, AchievementType.WINS, winner.getWins());
        this.broadcast(BowSpleef.get().getLanguage().winMsg.replace("%player%", winner.getPlayer().getName()));
        BowSpleef.get().getOptions().winCommands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", winner.getPlayer().getName())));
        this.places.keySet().forEach(pos -> {
            if (this.places.get(pos) == 3) {
                BowSpleef.get().getOptions().win3Commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", pos.getPlayer().getName())));
            } else if (this.places.get(pos) == 2) {
                BowSpleef.get().getOptions().win2Commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("%player%", pos.getPlayer().getName())));
            }
        });
        this.getPlayers().forEach(gp -> {
            gp.addMoney(BowSpleef.get().getOptions().coinsPerParticipation);
            gp.setEarnedCoins(gp.getEarnedCoins() + (double)BowSpleef.get().getOptions().coinsPerParticipation);
            BowSpleef.get().getLanguage().gameEnd.forEach(msg -> {
                msg = Util.colorString(msg, new Player[0]);
                msg = msg.replaceAll("%winner%", winner.getPlayer().getName());
                msg = msg.replaceAll("%coins%", Double.toString(gp.getEarnedCoins()));
                gp.getPlayer().sendMessage(Util.colorString(msg, gp.getPlayer()));
            });
        });
        this.resetArena(false);
    }

    private void resetArena(boolean shutdown) {
        Bukkit.getScheduler().runTaskLater((Plugin)BowSpleef.get(), () -> {
            this.getPlayers().forEach(gp -> this.removePlayer((GamePlayer)gp, true, false));
            Runner.make(BowSpleef.get()).delay(5).run(() -> {
                if (BowSpleef.get().getOptions().isBungeeCord && Bukkit.getOnlinePlayers().size() > 0) {
                    Bukkit.getOnlinePlayers().forEach(on -> {
                        if (GamePlayer.get(on) != null) {
                            GamePlayer.get(on).setGame(null);
                        }
                        Util.connect(on, BowSpleef.get().getOptions().bungeeLobby);
                    });
                }
            });
            Runner.make(BowSpleef.get()).delay(35).run(() -> this.restore(!shutdown, shutdown));
        }, (long)BowSpleef.get().getOptions().timerAfterGame * 20L);
    }

    public void shutdown(boolean recreate) {
        if (!this.getPlayers().isEmpty()) {
            this.getPlayers().forEach(gp -> {
                this.removePlayer((GamePlayer)gp, true, false);
                if (this.getState() == GameState.IN_GAME) {
                    this.broadcast(BowSpleef.get().getLanguage().gamenCanceled);
                }
            });
        }
        this.getPlayers().clear();
        this.setState(GameState.RESTORING);
        this.getGameArena().updateSign();
        HandlerList.unregisterAll((Listener)this);
        this.restore(false, recreate);
    }

    public void restore(boolean gracefully, boolean recreate) {
        if (!BowSpleef.get().getOptions().advancedRestore) {
            if (gracefully || recreate) {
                this.getGameArena().getRestore().restoreMap();
            } else {
                this.getGameArena().getRestore().regenRaw();
            }
        } else {
            BowSpleef.get().getGM().recreateGame(this);
        }
    }

    public void eliminatePlayer(GamePlayer gp) {
        gp.clearInventory(false);
        gp.setSpectator(true);
        gp.getPlayer().getInventory().setItem(BowSpleef.get().getOptions().leaveItemSlot, ItemFactory.parse(BowSpleef.get().getOptions().leaveItemType));
        gp.getPlayer().getInventory().setItem(BowSpleef.get().getOptions().spectatorItemSlot, ItemFactory.parse(BowSpleef.get().getOptions().spectatorItem));
        if (this.getAlivePlayers() == 3) {
            this.places.put(gp, 3);
        }
        if (this.getAlivePlayers() == 2) {
            this.places.put(gp, 2);
        }
        gp.getTeam().setPlayerState(gp.getPlayer(), GameTeam.PlayerState.OUT);
        Util.toggleCollisions(gp.getPlayer(), false);
        gp.getPlayer().setAllowFlight(true);
        gp.getPlayer().setFlying(true);
        gp.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 9, false, false));
        gp.getPlayer().teleport(this.getGameArena().getLocation(GameArena.LocationType.SPEC_SPAWN));
        if (BowSpleef.get().getOptions().spectatorGM) {
            gp.getPlayer().setGameMode(GameMode.SPECTATOR);
        } else {
            Bukkit.getOnlinePlayers().forEach(players -> players.hidePlayer(gp.getPlayer()));
        }
        gp.setLosses(gp.getLosses() + 1);
        gp.setGamesPlayed(gp.getGamesPlayed() + 1);
        PlayerAchievement.check(gp, AchievementType.GAMES, gp.getGamesPlayed());
        gp.addMoney(BowSpleef.get().getOptions().coinsPerParticipation);
        gp.setEarnedCoins(gp.getEarnedCoins() + (double)BowSpleef.get().getOptions().coinsPerParticipation);
        this.sendTitle(Util.colorString(BowSpleef.get().getLanguage().eliminatedTitle.replaceAll("%player%", gp.getPlayer().getName()).replaceAll("%alivePlayers%", Integer.toString(this.getAlivePlayers())), new Player[0]), Util.colorString(BowSpleef.get().getLanguage().eliminatedSubTitle.replaceAll("%player%", gp.getPlayer().getName()).replaceAll("%alivePlayers%", Integer.toString(this.getAlivePlayers())), new Player[0]));
        this.getAlive().forEach(alive -> {
            alive.addMoney(BowSpleef.get().getOptions().coinsPerPlayerDeath);
            alive.setEarnedCoins(alive.getEarnedCoins() + (double)BowSpleef.get().getOptions().coinsPerPlayerDeath);
        });
        if (this.getAlivePlayers() > 1) {
            this.broadcast(BowSpleef.get().getLanguage().playerEliminated.replaceAll("%player%", gp.getPlayer().getName()).replaceAll("%alive%", String.valueOf(this.getAlivePlayers())));
        } else if (this.getAlivePlayers() == 0) {
            this.endGame(gp, false, false);
        }
        gp.getPlayer().sendMessage(Util.colorString(BowSpleef.get().getLanguage().eliminatedMsg, gp.getPlayer()));
        if (BowSpleef.get().getOptions().disableSpectator) {
            this.removePlayer(gp, false, false);
        }
    }

    public int getAlivePlayers() {
        return (int)this.getPlayers().stream().filter(cur -> cur.getTeam().isAlive(cur.getPlayer())).count();
    }

    public int getSpectatorsCount() {
        return (int)this.getPlayers().stream().filter(GamePlayer::isSpectator).count();
    }

    public List<GamePlayer> getAlive() {
        return this.getPlayers().stream().filter(cur -> cur.getTeam().isAlive(cur.getPlayer())).collect(Collectors.toList());
    }

    public List<GamePlayer> getSpectators() {
        return this.getPlayers().stream().filter(cur -> !cur.getTeam().isAlive(cur.getPlayer())).collect(Collectors.toList());
    }

    public List<GamePlayer> getPlayers() {
        return this.players;
    }

    public List<GameTeam> getTeams() {
        return this.teams;
    }

    public GameArena getGameArena() {
        return this.gameArena;
    }

    public int getMaxPlayers() {
        return this.getGameArena().getMaxPlayers();
    }

    public int getMinPlayers() {
        return this.getGameArena().getMinPlayers();
    }

    public String getName() {
        return this.name;
    }

    public void sendTitle(String title, String subtitle) {
        this.getPlayers().forEach(gp -> Util.sendFormatted(gp.getPlayer(), title, subtitle));
    }

    public void broadcast(String str) {
        this.getPlayers().forEach(gp -> gp.getPlayer().sendMessage(Util.colorString(str, gp.getPlayer())));
    }

    public Game get() {
        return this;
    }

    public GameState getState() {
        return this.state;
    }

    public void setState(GameState state) {
        this.state = state;
    }

    public boolean isInGracePeriod() {
        return this.isInGracePeriod;
    }

    public boolean canStart() {
        return this.canStart;
    }

    public void addShotsFired(GamePlayer gp, int x) {
        this.shotsFired.put(gp, this.shotsFired.get(gp) + x);
    }

    public static enum GameState {
        PRE_GAME(BowSpleef.get().getLanguage().waitingSign),
        STARTING(BowSpleef.get().getLanguage().startingSign),
        GRACE_TIME(BowSpleef.get().getLanguage().startingSign),
        IN_GAME(BowSpleef.get().getLanguage().ingameSign),
        ENDING(BowSpleef.get().getLanguage().endingSign),
        RESTORING(BowSpleef.get().getLanguage().resettingSign);

        String state;

        private GameState(String state) {
            this.state = state;
        }

        public String toString() {
            return this.state;
        }
    }
}

